/*
 * Decompiled with CFR 0.152.
 */
package io.minio.admin;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.Digest;
import io.minio.MinioProperties;
import io.minio.S3Escaper;
import io.minio.Signer;
import io.minio.Time;
import io.minio.admin.Crypto;
import io.minio.admin.UserInfo;
import io.minio.credentials.Credentials;
import io.minio.credentials.Provider;
import io.minio.credentials.StaticProvider;
import io.minio.http.HttpUtils;
import io.minio.http.Method;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class MinioAdminClient {
    private static final long DEFAULT_CONNECTION_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.parse((String)"application/octet-stream");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String userAgent = MinioProperties.INSTANCE.getDefaultUserAgent();
    private PrintWriter traceStream;
    private HttpUrl baseUrl;
    private String region;
    private Provider provider;
    private OkHttpClient httpClient;

    private MinioAdminClient(HttpUrl baseUrl, String region, Provider provider, OkHttpClient httpClient) {
        this.baseUrl = baseUrl;
        this.region = region;
        this.provider = provider;
        this.httpClient = httpClient;
    }

    private Credentials getCredentials() {
        Credentials creds = this.provider.fetch();
        if (creds == null) {
            throw new RuntimeException("Credential provider returns null credential");
        }
        return creds;
    }

    private Response execute(Method method, Command command, Multimap<String, String> queryParamMap, byte[] body) throws InvalidKeyException, IOException, NoSuchAlgorithmException {
        Credentials creds = this.getCredentials();
        HttpUrl.Builder urlBuilder = this.baseUrl.newBuilder().host(this.baseUrl.host()).addEncodedPathSegments(S3Escaper.encodePath((String)("minio/admin/v3/" + command.toString())));
        if (queryParamMap != null) {
            for (Map.Entry entry : queryParamMap.entries()) {
                urlBuilder.addEncodedQueryParameter(S3Escaper.encode((String)((String)entry.getKey())), S3Escaper.encode((String)((String)entry.getValue())));
            }
        }
        HttpUrl url = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        requestBuilder.header("Host", HttpUtils.getHostHeader((HttpUrl)url));
        requestBuilder.header("Accept-Encoding", "identity");
        requestBuilder.header("User-Agent", this.userAgent);
        requestBuilder.header("x-amz-date", ZonedDateTime.now().format(Time.AMZ_DATE_FORMAT));
        if (creds.sessionToken() != null) {
            requestBuilder.header("X-Amz-Security-Token", creds.sessionToken());
        }
        if (body == null && method != Method.GET && method != Method.HEAD) {
            body = HttpUtils.EMPTY_BODY;
        }
        if (body != null) {
            requestBuilder.header("x-amz-content-sha256", Digest.sha256Hash((byte[])body, (int)body.length));
            requestBuilder.method(method.toString(), RequestBody.create((byte[])body, (MediaType)DEFAULT_MEDIA_TYPE));
        } else {
            requestBuilder.header("x-amz-content-sha256", "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
        }
        Request request = requestBuilder.build();
        request = Signer.signV4S3((Request)request, (String)this.region, (String)creds.accessKey(), (String)creds.secretKey(), (String)request.header("x-amz-content-sha256"));
        PrintWriter traceStream = this.traceStream;
        if (traceStream != null) {
            StringBuilder traceBuilder = new StringBuilder();
            traceBuilder.append("---------START-HTTP---------\n");
            String encodedPath = request.url().encodedPath();
            String encodedQuery = request.url().encodedQuery();
            if (encodedQuery != null) {
                encodedPath = encodedPath + "?" + encodedQuery;
            }
            traceBuilder.append(request.method()).append(" ").append(encodedPath).append(" HTTP/1.1\n");
            traceBuilder.append(request.headers().toString().replaceAll("Signature=([0-9a-f]+)", "Signature=*REDACTED*").replaceAll("Credential=([^/]+)", "Credential=*REDACTED*"));
            if (body != null) {
                traceBuilder.append("\n").append(new String(body, StandardCharsets.UTF_8));
            }
            traceStream.println(traceBuilder.toString());
        }
        OkHttpClient httpClient = this.httpClient;
        Response response = httpClient.newCall(request).execute();
        if (traceStream != null) {
            String trace = response.protocol().toString().toUpperCase(Locale.US) + " " + response.code() + "\n" + response.headers();
            traceStream.println(trace);
            ResponseBody responseBody = response.peekBody(0x100000L);
            traceStream.println(responseBody.string());
            traceStream.println("----------END-HTTP----------");
        }
        if (response.isSuccessful()) {
            return response;
        }
        throw new RuntimeException("Request failed with response: " + response.body().string());
    }

    public void addUser(@Nonnull String accessKey, @Nonnull UserInfo.Status status, @Nullable String secretKey, @Nullable String policyName, @Nullable List<String> memberOf) throws NoSuchAlgorithmException, InvalidKeyException, IOException, InvalidCipherTextException {
        if (accessKey == null || accessKey.isEmpty()) {
            throw new IllegalArgumentException("access key must be provided");
        }
        UserInfo userInfo = new UserInfo(status, secretKey, policyName, memberOf);
        Credentials creds = this.getCredentials();
        Response response = this.execute(Method.PUT, Command.ADD_USER, (Multimap<String, String>)ImmutableMultimap.of((Object)"accessKey", (Object)accessKey), Crypto.encrypt(creds.secretKey(), OBJECT_MAPPER.writeValueAsBytes((Object)userInfo)));
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    public Map<String, UserInfo> listUsers() throws NoSuchAlgorithmException, InvalidKeyException, IOException, InvalidCipherTextException {
        try (Response response = this.execute(Method.GET, Command.LIST_USERS, null, null);){
            Credentials creds = this.getCredentials();
            byte[] jsonData = Crypto.decrypt(creds.secretKey(), response.body().bytes());
            MapType mapType = OBJECT_MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, UserInfo.class);
            Map map = (Map)OBJECT_MAPPER.readValue(jsonData, (JavaType)mapType);
            return map;
        }
    }

    public void deleteUser(@Nonnull String accessKey) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (accessKey == null || accessKey.isEmpty()) {
            throw new IllegalArgumentException("access key must be provided");
        }
        Response response = this.execute(Method.DELETE, Command.REMOVE_USER, (Multimap<String, String>)ImmutableMultimap.of((Object)"accessKey", (Object)accessKey), null);
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    public void addCannedPolicy(@Nonnull String name, @Nonnull String policy) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be provided");
        }
        if (policy == null || policy.isEmpty()) {
            throw new IllegalArgumentException("policy must be provided");
        }
        Response response = this.execute(Method.PUT, Command.ADD_CANNED_POLICY, (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)name), policy.getBytes(StandardCharsets.UTF_8));
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    public void setPolicy(@Nonnull String userOrGroupName, boolean isGroup, @Nonnull String policyName) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (userOrGroupName == null || userOrGroupName.isEmpty()) {
            throw new IllegalArgumentException("user/group name must be provided");
        }
        if (policyName == null || policyName.isEmpty()) {
            throw new IllegalArgumentException("policy name must be provided");
        }
        Response response = this.execute(Method.PUT, Command.SET_USER_OR_GROUP_POLICY, (Multimap<String, String>)ImmutableMultimap.of((Object)"userOrGroup", (Object)userOrGroupName, (Object)"isGroup", (Object)String.valueOf(isGroup), (Object)"policyName", (Object)policyName), null);
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    public Map<String, String> listCannedPolicies() throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        try (Response response = this.execute(Method.GET, Command.LIST_CANNED_POLICIES, null, null);){
            MapType mapType = OBJECT_MAPPER.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
            Map map = (Map)OBJECT_MAPPER.readValue(response.body().bytes(), (JavaType)mapType);
            return map;
        }
    }

    public void removeCannedPolicy(@Nonnull String name) throws NoSuchAlgorithmException, InvalidKeyException, IOException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be provided");
        }
        Response response = this.execute(Method.DELETE, Command.REMOVE_CANNED_POLICY, (Multimap<String, String>)ImmutableMultimap.of((Object)"name", (Object)name), null);
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                response.close();
            }
        }
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.httpClient = HttpUtils.setTimeout((OkHttpClient)this.httpClient, (long)connectTimeout, (long)writeTimeout, (long)readTimeout);
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public void ignoreCertCheck() throws KeyManagementException, NoSuchAlgorithmException {
        this.httpClient = HttpUtils.disableCertCheck((OkHttpClient)this.httpClient);
    }

    public void setAppInfo(String name, String version) {
        if (name == null || version == null) {
            return;
        }
        this.userAgent = MinioProperties.INSTANCE.getDefaultUserAgent() + " " + name.trim() + "/" + version.trim();
    }

    public void traceOn(OutputStream traceStream) {
        if (traceStream == null) {
            throw new IllegalArgumentException("trace stream must be provided");
        }
        this.traceStream = new PrintWriter((Writer)new OutputStreamWriter(traceStream, StandardCharsets.UTF_8), true);
    }

    public void traceOff() throws IOException {
        this.traceStream = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpUrl baseUrl;
        private String region = "";
        private Provider provider;
        private OkHttpClient httpClient;

        public Builder endpoint(String endpoint) {
            this.baseUrl = HttpUtils.getBaseUrl((String)endpoint);
            return this;
        }

        public Builder endpoint(String endpoint, int port, boolean secure) {
            HttpUrl url = HttpUtils.getBaseUrl((String)endpoint);
            if (port < 1 || port > 65535) {
                throw new IllegalArgumentException("port must be in range of 1 to 65535");
            }
            this.baseUrl = url.newBuilder().port(port).scheme(secure ? "https" : "http").build();
            return this;
        }

        public Builder endpoint(HttpUrl url) {
            HttpUtils.validateNotNull((Object)url, (String)"url");
            HttpUtils.validateUrl((HttpUrl)url);
            this.baseUrl = url;
            return this;
        }

        public Builder endpoint(URL url) {
            HttpUtils.validateNotNull((Object)url, (String)"url");
            return this.endpoint(HttpUrl.get((URL)url));
        }

        public Builder region(String region) {
            HttpUtils.validateNotNull((Object)region, (String)"region");
            this.region = region;
            return this;
        }

        public Builder credentials(String accessKey, String secretKey) {
            this.provider = new StaticProvider(accessKey, secretKey, null);
            return this;
        }

        public Builder credentialsProvider(Provider provider) {
            HttpUtils.validateNotNull((Object)provider, (String)"credential provider");
            this.provider = provider;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            HttpUtils.validateNotNull((Object)httpClient, (String)"http client");
            this.httpClient = httpClient;
            return this;
        }

        public MinioAdminClient build() {
            HttpUtils.validateNotNull((Object)this.baseUrl, (String)"base url");
            HttpUtils.validateNotNull((Object)this.provider, (String)"credential provider");
            if (this.httpClient == null) {
                this.httpClient = HttpUtils.newDefaultHttpClient((long)DEFAULT_CONNECTION_TIMEOUT, (long)DEFAULT_CONNECTION_TIMEOUT, (long)DEFAULT_CONNECTION_TIMEOUT);
            }
            return new MinioAdminClient(this.baseUrl, this.region, this.provider, this.httpClient);
        }
    }

    private static enum Command {
        ADD_USER("add-user"),
        LIST_USERS("list-users"),
        REMOVE_USER("remove-user"),
        ADD_CANNED_POLICY("add-canned-policy"),
        SET_USER_OR_GROUP_POLICY("set-user-or-group-policy"),
        LIST_CANNED_POLICIES("list-canned-policies"),
        REMOVE_CANNED_POLICY("remove-canned-policy");

        private final String value;

        private Command(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

