/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.noise.module.modifier;

import com.flowpowered.noise.Utils;
import com.flowpowered.noise.exception.NoModuleException;
import com.flowpowered.noise.module.Module;
import java.util.ArrayList;
import java.util.List;

public class Curve
extends Module {
    private final List<ControlPoint> controlPoints = new ArrayList<ControlPoint>();

    public Curve() {
        super(1);
    }

    public void addControlPoint(double inputValue, double outputValue) {
        int index = this.findInsertionPos(inputValue);
        this.insertAtPos(index, inputValue, outputValue);
    }

    public ControlPoint[] getControlPoints() {
        return (ControlPoint[])this.controlPoints.toArray();
    }

    public void clearAllControlPoints() {
        this.controlPoints.clear();
    }

    private int findInsertionPos(double inputValue) {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.controlPoints.size() && !(inputValue < this.controlPoints.get(insertionPos).inputValue); ++insertionPos) {
            if (inputValue != this.controlPoints.get(insertionPos).inputValue) continue;
            throw new IllegalArgumentException("inputValue must be unique");
        }
        return insertionPos;
    }

    private void insertAtPos(int insertionPos, double inputValue, double outputValue) {
        ControlPoint newPoint = new ControlPoint();
        newPoint.inputValue = inputValue;
        newPoint.outputValue = outputValue;
        this.controlPoints.add(insertionPos, newPoint);
    }

    @Override
    public int getSourceModuleCount() {
        return 1;
    }

    @Override
    public double getValue(double x, double y, double z) {
        int indexPos;
        if (this.sourceModule[0] == null) {
            throw new NoModuleException();
        }
        if (this.controlPoints.size() < 4) {
            throw new RuntimeException("Curve module must have at least 4 control points");
        }
        double sourceModuleValue = this.sourceModule[0].getValue(x, y, z);
        for (indexPos = 0; indexPos < this.controlPoints.size() && !(sourceModuleValue < this.controlPoints.get(indexPos).inputValue); ++indexPos) {
        }
        int index0 = Utils.clamp(indexPos - 2, 0, this.controlPoints.size() - 1);
        int index1 = Utils.clamp(indexPos - 1, 0, this.controlPoints.size() - 1);
        int index2 = Utils.clamp(indexPos, 0, this.controlPoints.size() - 1);
        int index3 = Utils.clamp(indexPos + 1, 0, this.controlPoints.size() - 1);
        if (index1 == index2) {
            return this.controlPoints.get(indexPos).outputValue;
        }
        double input0 = this.controlPoints.get(indexPos).inputValue;
        double input1 = this.controlPoints.get(indexPos).inputValue;
        double alpha = (sourceModuleValue - input0) / (input1 - input0);
        return Utils.cubicInterp(this.controlPoints.get(index0).outputValue, this.controlPoints.get(index1).outputValue, this.controlPoints.get(index2).outputValue, this.controlPoints.get(index3).outputValue, alpha);
    }

    public static class ControlPoint {
        private double inputValue;
        private double outputValue;
    }
}

