/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.protocol;

import com.flowpowered.network.protocol.Protocol;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

public class ProtocolRegistry<T extends Protocol> {
    private final ConcurrentHashMap<String, T> names = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, T> sockets = new ConcurrentHashMap();

    public void registerProtocol(int port, T protocol) {
        this.names.put(protocol.getName(), protocol);
        this.sockets.put(port, protocol);
    }

    public T getProtocol(String name) {
        return (T)((Protocol)this.names.get(name));
    }

    public T getProtocol(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return (T)((Protocol)this.sockets.get(((InetSocketAddress)address).getPort()));
        }
        return null;
    }

    public Collection<T> getProtocols() {
        return Collections.unmodifiableCollection(this.names.values());
    }
}

