/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.pipeline;

import com.flowpowered.network.pipeline.MessageHandler;
import com.flowpowered.network.processor.MessageProcessor;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;

public class MessageProcessorEncoder
extends MessageToMessageEncoder<ByteBuf> {
    private final MessageHandler messageHandler;

    public MessageProcessorEncoder(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        MessageProcessor processor = this.getProcessor();
        if (processor == null) {
            out.add(buf.readBytes(buf.readableBytes()));
            return;
        }
        ByteBuf toAdd = ctx.alloc().buffer();
        toAdd = processor.processOutbound(ctx, buf, toAdd);
        out.add(toAdd);
    }

    protected MessageProcessor getProcessor() {
        return this.messageHandler.getSession().getProcessor();
    }
}

