/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.pipeline;

import com.flowpowered.network.Codec;
import com.flowpowered.network.Message;
import com.flowpowered.network.pipeline.MessageHandler;
import com.flowpowered.network.protocol.Protocol;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;

public class MessageEncoder
extends MessageToMessageEncoder<Message> {
    private final MessageHandler messageHandler;

    public MessageEncoder(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    protected void encode(ChannelHandlerContext ctx, Message message, List<Object> out) throws Exception {
        Protocol protocol = this.messageHandler.getSession().getProtocol();
        Class<?> clazz = message.getClass();
        Codec.CodecRegistration reg = protocol.getCodecRegistration(message.getClass());
        if (reg == null) {
            throw new Exception("Unknown message type: " + clazz + ".");
        }
        ByteBuf messageBuf = ctx.alloc().buffer();
        messageBuf = reg.getCodec().encode(messageBuf, message);
        ByteBuf headerBuf = ctx.alloc().buffer();
        headerBuf = protocol.writeHeader(headerBuf, reg, messageBuf);
        out.add(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{headerBuf, messageBuf}));
    }
}

