/*
 * Decompiled with CFR 0.152.
 */
package com.flowpowered.network.pipeline;

import com.flowpowered.network.Codec;
import com.flowpowered.network.exception.UnknownPacketException;
import com.flowpowered.network.pipeline.MessageHandler;
import com.flowpowered.network.protocol.Protocol;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;

public class MessageDecoder
extends ReplayingDecoder<ByteBuf> {
    private final MessageHandler messageHandler;

    public MessageDecoder(MessageHandler handler) {
        this.messageHandler = handler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        Protocol protocol = this.messageHandler.getSession().getProtocol();
        Codec<?> codec = null;
        try {
            codec = protocol.readHeader(buf);
        }
        catch (UnknownPacketException e) {
            int length = e.getLength();
            if (length != -1 && length != 0) {
                buf.readBytes(length);
            }
            throw e;
        }
        if (codec == null) {
            throw new UnsupportedOperationException("Protocol#readHeader cannot return null!");
        }
        Object decoded = codec.decode(buf);
        out.add(decoded);
    }
}

