/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions.plotsquared;

import com.fastasyncworldedit.core.FaweAPI;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.processor.lighting.RelightMode;
import com.fastasyncworldedit.core.util.TaskManager;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.function.FlatRegionFunction;
import com.sk89q.worldedit.function.biome.BiomeReplace;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.FlatRegionVisitor;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class FaweDelegateRegionManager {
    public boolean setCuboids(@NonNull PlotArea area, @NonNull Set<CuboidRegion> regions, @NonNull Pattern blocks, int minY, int maxY, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)area.getWorldName()));
                EditSession session = WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                for (CuboidRegion region : regions) {
                    region.setPos1(region.getPos1().withY(minY));
                    region.setPos2(region.getPos2().withY(maxY));
                    session.setBlocks((Region)region, blocks);
                }
                try {
                    session.flushQueue();
                    for (CuboidRegion region : regions) {
                        FaweAPI.fixLighting((World)world, (Region)region, null, (RelightMode)RelightMode.valueOf((int)Settings.settings().LIGHTING.MODE));
                    }
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                finally {
                    if (whenDone != null) {
                        TaskManager.taskManager().task(whenDone);
                    }
                }
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return;
            }
        });
        return true;
    }

    public boolean notifyClear(PlotManager manager) {
        HybridPlotWorld hpw = ((HybridPlotManager)manager).getHybridPlotWorld();
        return hpw.getType() != PlotAreaType.AUGMENTED || hpw.getTerrain() == PlotAreaTerrainType.NONE;
    }

    public boolean handleClear(@Nonnull Plot plot, @Nullable Runnable whenDone, @Nonnull PlotManager manager) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                HybridPlotWorld hybridPlotWorld = ((HybridPlotManager)manager).getHybridPlotWorld();
                World world = BukkitAdapter.adapt(Bukkit.getWorld((String)hybridPlotWorld.getWorldName()));
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                if (!hybridPlotWorld.PLOT_SCHEMATIC || !Settings.Schematics.PASTE_ON_TOP) {
                    BlockType air = BlockTypes.AIR;
                    BlockType bedrock = hybridPlotWorld.PLOT_BEDROCK ? BlockTypes.BEDROCK : air;
                    Pattern filling = hybridPlotWorld.MAIN_BLOCK.toPattern();
                    Pattern plotfloor = hybridPlotWorld.TOP_BLOCK.toPattern();
                    BiomeType biome = hybridPlotWorld.getPlotBiome();
                    BlockVector3 pos1 = plot.getBottomAbs().getBlockVector3();
                    BlockVector3 pos2 = pos1.add(BlockVector3.at((int)(hybridPlotWorld.PLOT_WIDTH - 1), (int)hybridPlotWorld.getMaxGenHeight(), (int)(hybridPlotWorld.PLOT_WIDTH - 1)));
                    if (hybridPlotWorld.PLOT_BEDROCK) {
                        CuboidRegion bedrockRegion = new CuboidRegion(pos1, pos2.withY(hybridPlotWorld.getMinGenHeight()));
                        editSession.setBlocks((Region)bedrockRegion, (Pattern)bedrock);
                    }
                    CuboidRegion fillingRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.getMinGenHeight() + 1), pos2.withY(hybridPlotWorld.PLOT_HEIGHT - 1));
                    CuboidRegion floorRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT), pos2.withY(hybridPlotWorld.PLOT_HEIGHT));
                    CuboidRegion airRegion = new CuboidRegion(pos1.withY(hybridPlotWorld.PLOT_HEIGHT + 1), pos2.withY(hybridPlotWorld.getMaxGenHeight()));
                    editSession.setBlocks((Region)fillingRegion, filling);
                    editSession.setBlocks((Region)floorRegion, plotfloor);
                    editSession.setBlocks((Region)airRegion, (Pattern)air);
                    if (hybridPlotWorld.getMinBuildHeight() < hybridPlotWorld.getMinGenHeight()) {
                        CuboidRegion underneath = new CuboidRegion(pos1.withY(hybridPlotWorld.getMinBuildHeight()), pos2.withY(hybridPlotWorld.getMinGenHeight()));
                        editSession.setBlocks((Region)underneath, (Pattern)air);
                    }
                    if (hybridPlotWorld.getMaxGenHeight() < hybridPlotWorld.getMaxBuildHeight() - 1) {
                        CuboidRegion onTop = new CuboidRegion(pos1.withY(hybridPlotWorld.getMaxGenHeight()), pos2.withY(hybridPlotWorld.getMaxBuildHeight() - 1));
                        editSession.setBlocks((Region)onTop, (Pattern)air);
                    }
                    BiomeReplace replace = new BiomeReplace((Extent)editSession, biome);
                    FlatRegionVisitor visitor = new FlatRegionVisitor((FlatRegion)floorRegion, (FlatRegionFunction)replace, (Extent)editSession);
                    Operations.completeLegacy((Operation)visitor);
                }
                if (hybridPlotWorld.PLOT_SCHEMATIC) {
                    EditSession scheditsession = !Settings.Schematics.PASTE_ON_TOP ? editSession : WorldEdit.getInstance().newEditSessionBuilder().world(world).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                    File schematicFile = new File(hybridPlotWorld.getSchematicRoot(), "plot.schem");
                    if (!schematicFile.exists()) {
                        schematicFile = new File(hybridPlotWorld.getSchematicRoot(), "plot.schematic");
                    }
                    BlockVector3 to = plot.getBottomAbs().getBlockVector3().withY(hybridPlotWorld.getPlotYStart());
                    try {
                        Clipboard clip = ClipboardFormats.findByFile((File)schematicFile).getReader((InputStream)new FileInputStream(schematicFile)).read();
                        clip.setOrigin(clip.getRegion().getMinimumPoint());
                        clip.paste((Extent)scheditsession, to, true, true, true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    scheditsession.flushQueue();
                }
                editSession.flushQueue();
                FaweAPI.fixLighting((World)world, (Region)new CuboidRegion(plot.getBottomAbs().getBlockVector3(), plot.getTopAbs().getBlockVector3()), null, (RelightMode)RelightMode.valueOf((int)Settings.settings().LIGHTING.MODE));
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }

    public void swap(Location pos1, Location pos2, Location swapPos, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)swapPos.getWorldName()));
                EditSession sessionA = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                EditSession sessionB = WorldEdit.getInstance().newEditSessionBuilder().world(pos3World).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                CuboidRegion regionA = new CuboidRegion(pos1World, pos1.getBlockVector3(), pos2.getBlockVector3());
                CuboidRegion regionB = new CuboidRegion(pos3World, swapPos.getBlockVector3(), swapPos.getBlockVector3().add(pos2.getBlockVector3()).subtract(pos1.getBlockVector3()));
                Clipboard clipA = Clipboard.create((Region)regionA, (UUID)UUID.randomUUID());
                Clipboard clipB = Clipboard.create((Region)regionB, (UUID)UUID.randomUUID());
                ForwardExtentCopy copyA = new ForwardExtentCopy((Extent)sessionA, (Region)regionA, (Extent)clipA, clipA.getMinimumPoint());
                ForwardExtentCopy copyB = new ForwardExtentCopy((Extent)sessionB, (Region)regionB, (Extent)clipB, clipB.getMinimumPoint());
                copyA.setCopyingBiomes(true);
                copyB.setCopyingBiomes(true);
                try {
                    Operations.completeLegacy((Operation)copyA);
                    Operations.completeLegacy((Operation)copyB);
                    clipA.flush();
                    clipB.flush();
                    clipA.paste((Extent)sessionB, swapPos.getBlockVector3(), true, true, true);
                    clipB.paste((Extent)sessionA, pos1.getBlockVector3(), true, true, true);
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                finally {
                    sessionA.close();
                    sessionB.close();
                }
                FaweAPI.fixLighting((World)pos1World, (Region)new CuboidRegion(pos1.getBlockVector3(), pos2.getBlockVector3()), null, (RelightMode)RelightMode.valueOf((int)Settings.settings().LIGHTING.MODE));
                FaweAPI.fixLighting((World)pos1World, (Region)new CuboidRegion(swapPos.getBlockVector3(), BlockVector3.at((int)(swapPos.getX() + pos2.getX() - pos1.getX()), (int)0, (int)(swapPos.getZ() + pos2.getZ() - pos1.getZ()))), null, (RelightMode)RelightMode.valueOf((int)Settings.settings().LIGHTING.MODE));
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
    }

    public void setBiome(CuboidRegion region, int extendBiome, BiomeType biome, String world, Runnable whenDone) {
        region.expand(new BlockVector3[]{BlockVector3.at((int)extendBiome, (int)0, (int)extendBiome)});
        region.expand(new BlockVector3[]{BlockVector3.at((int)(-extendBiome), (int)0, (int)(-extendBiome))});
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(BukkitAdapter.adapt(Bukkit.getWorld((String)world))).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                BiomeReplace replace = new BiomeReplace((Extent)editSession, biome);
                FlatRegionVisitor visitor = new FlatRegionVisitor((FlatRegion)region, (FlatRegionFunction)replace, (Extent)editSession);
                try {
                    Operations.completeLegacy((Operation)visitor);
                    editSession.flushQueue();
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        });
    }

    public boolean copyRegion(@NonNull Location pos1, @NonNull Location pos2, @NonNull Location pos3, @NonNull Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                World pos3World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos3.getWorldName()));
                EditSession from = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                EditSession to = WorldEdit.getInstance().newEditSessionBuilder().world(pos3World).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();
                CuboidRegion region = new CuboidRegion(BlockVector3.at((int)pos1.getX(), (int)pos1.getY(), (int)pos1.getZ()), BlockVector3.at((int)pos2.getX(), (int)pos2.getY(), (int)pos2.getZ()));
                ForwardExtentCopy copy = new ForwardExtentCopy((Extent)from, (Region)region, (Extent)to, BlockVector3.at((int)pos3.getX(), (int)pos3.getY(), (int)pos3.getZ()));
                try {
                    Operations.completeLegacy((Operation)copy);
                    to.flushQueue();
                    FaweAPI.fixLighting((World)pos1World, (Region)new CuboidRegion(pos3.getBlockVector3(), pos3.getBlockVector3().add(pos2.getBlockVector3().subtract(pos1.getBlockVector3()))), null, (RelightMode)RelightMode.valueOf((int)Settings.settings().LIGHTING.MODE));
                }
                catch (MaxChangedBlocksException e) {
                    e.printStackTrace();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                return;
            }
        });
        return true;
    }

    public boolean regenerateRegion(Location pos1, Location pos2, boolean ignore, Runnable whenDone) {
        TaskManager.taskManager().async(() -> {
            Class<FaweDelegateRegionManager> clazz = FaweDelegateRegionManager.class;
            synchronized (FaweDelegateRegionManager.class) {
                World pos1World = BukkitAdapter.adapt(Bukkit.getWorld((String)pos1.getWorldName()));
                try (EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world(pos1World).checkMemory(Boolean.valueOf(false)).fastMode(Boolean.valueOf(true)).limitUnlimited().changeSetNull().build();){
                    CuboidRegion region = new CuboidRegion(BlockVector3.at((int)pos1.getX(), (int)pos1.getY(), (int)pos1.getZ()), BlockVector3.at((int)pos2.getX(), (int)pos2.getY(), (int)pos2.getZ()));
                    editSession.regenerate((Region)region);
                    editSession.flushQueue();
                }
                if (whenDone != null) {
                    TaskManager.taskManager().task(whenDone);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return true;
    }
}

