/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.fastasyncworldedit.bukkit.BukkitPermissionAttachmentManager;
import com.fastasyncworldedit.bukkit.FaweBukkit;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.util.UpdateNotification;
import com.fastasyncworldedit.core.util.WEManager;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.bukkit.util.ClassSourceValidator;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitBlockCommandSender;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.event.platform.PlatformUnreadyEvent;
import com.sk89q.worldedit.event.platform.PlatformsRegisteredEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.lifecycle.Lifecycled;
import com.sk89q.worldedit.util.lifecycle.SimpleLifecycled;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import io.papermc.lib.PaperLib;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.SimplePie;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.enginehub.piston.CommandManager;
import org.incendo.serverlib.ServerLib;

public class WorldEditPlugin
extends JavaPlugin {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private static final int BSTATS_ID = 1403;
    private final SimpleLifecycled<BukkitImplAdapter> adapter = SimpleLifecycled.invalid();
    private BukkitServerInterface platform;
    private BukkitConfiguration config;
    private BukkitPermissionAttachmentManager permissionAttachmentManager;
    private BukkitCommandSender bukkitConsoleCommandSender;

    public void onLoad() {
        Plugin[] plugins;
        this.bukkitConsoleCommandSender = new BukkitCommandSender(this, (CommandSender)Bukkit.getConsoleSender());
        for (Plugin p : plugins = Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!p.getName().equals("WorldEdit")) continue;
            LOGGER.warn("You installed WorldEdit alongside FastAsyncWorldEdit. That is unneeded and will cause unforeseen issues, because FastAsyncWorldEdit already provides WorldEdit. Stop your server and delete the 'worldedit-bukkit' jar from your plugins folder.");
        }
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.platform = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register((Platform)this.platform);
        this.migrateLegacyConfig();
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "worldedit-config.yml"), true), this);
        this.permissionAttachmentManager = new BukkitPermissionAttachmentManager(this);
        Path delChunks = Paths.get(this.getDataFolder().getPath(), "delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile((Path)delChunks, (boolean)true);
        }
        if (this.getDataFolder().getParentFile().listFiles(file -> {
            if (file.getName().equals("DummyFawe.jar")) {
                file.delete();
                return true;
            }
            return false;
        }).length > 0) {
            LOGGER.warn("DummyFawe detected and automatically deleted! This file is no longer necessary.");
        }
    }

    public void onEnable() {
        ClassSourceValidator verifier = new ClassSourceValidator((Plugin)this);
        verifier.reportMismatches((List<Class<?>>)ImmutableList.of(World.class, CommandManager.class, EditSession.class, Actor.class));
        new FaweBukkit((Plugin)this);
        this.config.load();
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformsRegisteredEvent());
        PermissionsResolverManager.initialize((Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        if (PaperLib.isPaper()) {
            this.getServer().getPluginManager().registerEvents((Listener)new AsyncTabCompleteListener(), (Plugin)this);
        }
        this.initializeRegistries();
        if (Bukkit.getWorlds().isEmpty()) {
            this.setupPreWorldData();
            this.getServer().getPluginManager().registerEvents((Listener)new WorldInitListener(), (Plugin)this);
        } else {
            LOGGER.warn("Server reload detected. This may cause various issues with FastAsyncWorldEdit and dependent plugins. Reloading the server is not advised.");
            LOGGER.warn("For more information why reloading is bad, see https://madelinemiller.dev/blog/problem-with-reload/");
            try {
                this.setupPreWorldData();
                this.setupWorldData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Metrics m = new Metrics((JavaPlugin)this, 1403);
        m.addCustomChart((CustomChart)new SimplePie("residence", () -> WEManager.weManager().getManagers().toString().contains("residence") ? "Yes" : "No"));
        ServerLib.checkUnsafeForks();
        UpdateNotification.doUpdateCheck();
    }

    private void setupPreWorldData() {
        this.loadAdapter();
        WorldEdit.getInstance().loadMappings();
    }

    private void setupWorldData() {
        this.setupTags();
        this.setupBiomes(false);
        WorldEdit.getInstance().getEventBus().post((Object)new PlatformReadyEvent((Platform)this.platform));
    }

    private void initializeRegistries() {
        this.setupBiomes(true);
        for (EntityType entityType : EntityType.values()) {
            String mcid = entityType.getName();
            if (mcid == null) continue;
            String lowerCaseMcId = mcid.toLowerCase(Locale.ROOT);
            com.sk89q.worldedit.world.entity.EntityType.REGISTRY.register("minecraft:" + lowerCaseMcId, (Keyed)new com.sk89q.worldedit.world.entity.EntityType("minecraft:" + lowerCaseMcId));
        }
        GameModes.get((String)"");
        WeatherTypes.get((String)"");
    }

    private void setupTags() {
        try {
            for (Tag blockTag : Bukkit.getTags((String)"blocks", Material.class)) {
                BlockCategory.REGISTRY.register(blockTag.getKey().toString(), (Keyed)new BlockCategory(blockTag.getKey().toString()));
            }
            for (Tag itemTag : Bukkit.getTags((String)"items", Material.class)) {
                ItemCategory.REGISTRY.register(itemTag.getKey().toString(), (Keyed)new ItemCategory(itemTag.getKey().toString()));
            }
        }
        catch (NoSuchMethodError ignored) {
            LOGGER.warn("The version of Spigot/Paper you are using doesn't support Tags. The usage of tags with WorldEdit will not work until you update.");
        }
    }

    private void setupBiomes(boolean expectFail) {
        if (this.adapter.value().isPresent()) {
            for (NamespacedKey biome : ((BukkitImplAdapter)this.adapter.value().get()).getRegisteredBiomes()) {
                BiomeType biomeType = (BiomeType)BiomeType.REGISTRY.get(biome.toString());
                if (biomeType == null) {
                    biomeType = new BiomeType(biome.toString());
                    BiomeType.REGISTRY.register(biome.toString(), (Keyed)biomeType);
                }
                biomeType.setLegacyId(((BukkitImplAdapter)this.adapter.value().get()).getInternalBiomeId(biomeType));
            }
        } else {
            if (!expectFail) {
                LOGGER.warn("Failed to load biomes via adapter (not present). Will load via bukkit");
            }
            for (Biome biome : Biome.values()) {
                String lowerCaseBiome;
                if (biome.name().equals("CUSTOM") || BiomeType.REGISTRY.get(lowerCaseBiome = biome.getKey().toString().toLowerCase(Locale.ROOT)) != null) continue;
                BiomeType.REGISTRY.register(lowerCaseBiome, (Keyed)new BiomeType(lowerCaseBiome));
            }
        }
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to search " + this.getFile() + " for Bukkit adapters", (Throwable)e);
        }
        try {
            BukkitImplAdapter bukkitAdapter = adapterLoader.loadAdapter();
            LOGGER.info("Using " + bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
            this.adapter.newValue((Object)bukkitAdapter);
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                LOGGER.warn(e.getMessage());
            } else {
                LOGGER.info("FastAsyncWorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of FastAsyncWorldEdit installed ({}) that handles the world editing.", (Object)platform.getPlatformName());
            }
            this.adapter.invalidate();
        }
    }

    public void onDisable() {
        Fawe.instance().onDisable();
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        if (this.platform != null) {
            worldEdit.getEventBus().post((Object)new PlatformUnreadyEvent((Platform)this.platform));
            worldEdit.getPlatformManager().unregister((Platform)this.platform);
            this.platform.unregisterCommands();
        }
        if (this.config != null) {
            this.config.unload();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            try (InputStream stream = this.getResource("defaults/" + name);){
                if (stream == null) {
                    throw new FileNotFoundException();
                }
                this.copyDefaultConfig(stream, actual, name);
            }
            catch (IOException e) {
                LOGGER.error("Unable to read default configuration: " + name);
            }
        }
    }

    private void migrateLegacyConfig() {
        File legacy = new File(this.getDataFolder(), "config-legacy.yml");
        if (legacy.exists()) {
            try {
                legacy.renameTo(new File(this.getDataFolder(), "worldedit-config.yml"));
                LOGGER.info("Migrated config-legacy.yml to worldedit-config.yml");
            }
            catch (Exception e) {
                LOGGER.error("Unable to rename legacy config file", (Throwable)e);
            }
        }
        this.createDefaultConfiguration("worldedit-config.yml");
    }

    private void copyDefaultConfig(InputStream input, File actual, String name) {
        try (FileOutputStream output = new FileOutputStream(actual);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = input.read(buf)) > 0) {
                output.write(buf, 0, length);
            }
            LOGGER.info("Default configuration file written: " + name);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write default config file", (Throwable)e);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Object[] split = new String[args.length + 1];
        System.arraycopy(args, 0, split, 1, args.length);
        split[0] = commandLabel.startsWith("fastasyncworldedit:") ? commandLabel.replace("fastasyncworldedit:", "") : commandLabel;
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), Joiner.on((String)" ").join(split));
        this.getWorldEdit().getEventBus().post((Object)event);
        return true;
    }

    public LocalSession getSession(org.bukkit.entity.Player player) {
        return WorldEdit.getInstance().getSessionManager().get((SessionOwner)this.wrapPlayer(player));
    }

    public EditSession createEditSession(org.bukkit.entity.Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        BlockBag blockBag = session.getBlockBag((Player)wePlayer);
        EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().locatableActor((Actor)wePlayer).maxBlocks(session.getBlockChangeLimit()).blockBag(blockBag).build();
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(org.bukkit.entity.Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        session.remember(editSession);
        editSession.close();
        WorldEdit.getInstance().flushBlockBag((Actor)wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPermissionAttachmentManager getPermissionAttachmentManager() {
        return this.permissionAttachmentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BukkitPlayer wrapPlayer(org.bukkit.entity.Player player) {
        BukkitPlayer wePlayer = this.getCachedPlayer(player);
        if (wePlayer == null) {
            org.bukkit.entity.Player player2 = player;
            synchronized (player2) {
                wePlayer = this.getCachedPlayer(player);
                if (wePlayer == null) {
                    wePlayer = new BukkitPlayer(this, player);
                    player.setMetadata("WE", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)wePlayer));
                    return wePlayer;
                }
            }
        }
        return wePlayer;
    }

    BukkitPlayer getCachedPlayer(org.bukkit.entity.Player player) {
        List meta = player.getMetadata("WE");
        if (meta.isEmpty()) {
            return null;
        }
        return (BukkitPlayer)((Object)((MetadataValue)meta.get(0)).value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BukkitPlayer reCachePlayer(org.bukkit.entity.Player player) {
        org.bukkit.entity.Player player2 = player;
        synchronized (player2) {
            BukkitPlayer wePlayer = new BukkitPlayer(this, player);
            player.setMetadata("WE", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)wePlayer));
            return wePlayer;
        }
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof org.bukkit.entity.Player) {
            return this.wrapPlayer((org.bukkit.entity.Player)sender);
        }
        if (this.config.commandBlockSupport && sender instanceof BlockCommandSender) {
            return new BukkitBlockCommandSender(this, (BlockCommandSender)sender);
        }
        return this.bukkitConsoleCommandSender;
    }

    public BukkitServerInterface getInternalPlatform() {
        return this.platform;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    Lifecycled<BukkitImplAdapter> getLifecycledBukkitImplAdapter() {
        return this.adapter;
    }

    public BukkitImplAdapter getBukkitImplAdapter() {
        return this.adapter.value().orElse(null);
    }

    private class AsyncTabCompleteListener
    implements Listener {
        AsyncTabCompleteListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
            if (!event.isCommand()) {
                return;
            }
            String buffer = event.getBuffer();
            int firstSpace = buffer.indexOf(32);
            if (firstSpace < 0) {
                return;
            }
            String label = buffer.substring(0, firstSpace);
            label = label.startsWith("/") ? label.substring(1) : label;
            Plugin owner = WorldEditPlugin.this.platform.getDynamicCommands().getCommandOwner(label);
            if (owner != WorldEditPlugin.this) {
                return;
            }
            Optional command = WorldEdit.getInstance().getPlatformManager().getPlatformCommandManager().getCommandManager().getCommand(label);
            if (!command.isPresent()) {
                return;
            }
            CommandSuggestionEvent suggestEvent = new CommandSuggestionEvent(WorldEditPlugin.this.wrapCommandSender(event.getSender()), buffer);
            WorldEditPlugin.this.getWorldEdit().getEventBus().post((Object)suggestEvent);
            event.setCompletions(CommandUtil.fixSuggestions((String)buffer, (List)suggestEvent.getSuggestions()));
            event.setHandled(true);
        }
    }

    private class WorldInitListener
    implements Listener {
        private boolean loaded = false;

        private WorldInitListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onWorldInit(WorldInitEvent event) {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            WorldEditPlugin.this.setupWorldData();
        }
    }
}

