/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.adapter.BukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.core.FAWEPlatformAdapterImpl;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.util.MathMan;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NMSAdapter
implements FAWEPlatformAdapterImpl {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int createPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, char[] set, CachedBukkitAdapter adapter, short[] nonEmptyBlockCount) {
        int i;
        int nonAir = 4096;
        int num_palette = 0;
        for (int i2 = 0; i2 < 4096; ++i2) {
            int ordinal = set[i2];
            switch (ordinal) {
                case 0: {
                    ordinal = 1;
                    nonAir = (short)(nonAir - 1);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    nonAir = (short)(nonAir - 1);
                }
            }
            int palette = blockToPalette[ordinal];
            if (palette != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        for (i = 0; i < 4096; ++i) {
            int palette;
            char ordinal = set[i];
            if (ordinal == '\u0000') {
                ordinal = '\u0001';
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        if (nonEmptyBlockCount != null) {
            nonEmptyBlockCount[0] = nonAir;
        }
        return num_palette;
    }

    public static int createPalette(int layer, int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, Function<Integer, char[]> get, char[] set, CachedBukkitAdapter adapter, short[] nonEmptyBlockCount) {
        int i;
        char[] copy = new char[set.length];
        int nonAir = 4096;
        int num_palette = 0;
        char[] getArr = null;
        for (int i2 = 0; i2 < 4096; ++i2) {
            int ordinal = set[i2];
            switch (ordinal) {
                case 0: {
                    if (getArr == null) {
                        getArr = get.apply(layer);
                    }
                    ordinal = getArr[i2];
                    switch (ordinal) {
                        case 0: {
                            nonAir = (short)(nonAir - 1);
                            ordinal = 1;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            nonAir = (short)(nonAir - 1);
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    nonAir = (short)(nonAir - 1);
                }
            }
            copy[i2] = ordinal;
            int palette = blockToPalette[ordinal];
            if (palette != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        for (i = 0; i < 4096; ++i) {
            int palette;
            char ordinal = copy[i];
            if (ordinal == '\u0000') {
                LOGGER.error("Empty (__RESERVED__) ordinal given where not expected, default to air.");
                ordinal = '\u0001';
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        if (nonEmptyBlockCount != null) {
            nonEmptyBlockCount[0] = nonAir;
        }
        return num_palette;
    }

    public void sendChunk(IChunkGet chunk, int mask, boolean lighting) {
        if (!(chunk instanceof BukkitGetBlocks)) {
            throw new IllegalArgumentException("(IChunkGet) chunk not of type BukkitGetBlocks");
        }
        ((BukkitGetBlocks)chunk).send(mask, lighting);
    }
}

