/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Plugin towny;

    public TownyFeature(Plugin townyPlugin) {
        super(townyPlugin.getName());
        this.towny = townyPlugin;
        LOGGER.info("Plugin 'Towny' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, TownBlock block) {
        if (block == null) {
            return false;
        }
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null) {
            return false;
        }
        if (block.hasResident(resident) || block.hasTrustedResident(resident)) {
            return true;
        }
        Town town = block.getTownOrNull();
        if (town.isMayor(resident) || town.hasTrustedResident(resident)) {
            return true;
        }
        if (!town.hasResident(resident)) {
            return false;
        }
        if (player.hasPermission("fawe.towny.*")) {
            return true;
        }
        for (String rank : resident.getTownRanks()) {
            if (!player.hasPermission("fawe.towny." + rank)) continue;
            return true;
        }
        return false;
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location location = player.getLocation();
        WorldCoord mycoord = WorldCoord.parseWorldCoord((Location)location);
        if (mycoord.isWilderness()) {
            return null;
        }
        final TownBlock myplot = mycoord.getTownBlockOrNull();
        boolean isMember = this.isAllowed(player, myplot);
        if (isMember) {
            Location loc1 = mycoord.getLowerMostCornerLocation();
            Location loc2 = mycoord.getUpperMostCornerLocation();
            BlockVector3 pos1 = BlockVector3.at((double)loc1.getX(), (double)loc1.getY(), (double)loc1.getZ());
            BlockVector3 pos2 = BlockVector3.at((double)loc2.getX(), (double)loc2.getY(), (double)loc2.getZ());
            return new FaweMask((Region)new CuboidRegion(pos1, pos2)){

                public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                    return TownyFeature.this.isAllowed(BukkitAdapter.adapt(player), myplot);
                }
            };
        }
        return null;
    }
}

