/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.MathMan;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.WorldInfo;

public abstract class Regenerator<IChunkAccess, ProtoChunk extends IChunkAccess, Chunk extends IChunkAccess, ChunkStatus extends ChunkStatusWrapper<IChunkAccess>> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected final World originalBukkitWorld;
    protected final Region region;
    protected final Extent target;
    protected final RegenOptions options;
    protected final Map<ChunkStatus, Concurrency> chunkStati = new LinkedHashMap<ChunkStatus, Concurrency>();
    private final Long2ObjectLinkedOpenHashMap<ProtoChunk> protoChunks = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectOpenHashMap<Chunk> chunks = new Long2ObjectOpenHashMap();
    protected boolean generateConcurrent = true;
    protected long seed;
    private ExecutorService executor;
    private SingleThreadQueueExtent source;

    public Regenerator(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        this.originalBukkitWorld = originalBukkitWorld;
        this.region = region;
        this.target = target;
        this.options = options;
    }

    private static Random getChunkRandom(long worldseed, int x, int z) {
        Random random = new Random();
        random.setSeed(worldseed);
        long xRand = random.nextLong() / 2L * 2L + 1L;
        long zRand = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)x * xRand + (long)z * zRand ^ worldseed);
        return random;
    }

    public boolean regenerate() throws Exception {
        if (!this.prepare()) {
            return false;
        }
        try {
            if (!this.initNewWorld()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            if (!this.generate()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            this.copyToWorld();
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        this.cleanup0();
        return true;
    }

    protected ProtoChunk getProtoChunkAt(int x, int z) {
        return (ProtoChunk)this.protoChunks.get(MathMan.pairInt((int)x, (int)z));
    }

    protected Chunk getChunkAt(int x, int z) {
        return (Chunk)this.chunks.get(MathMan.pairInt((int)x, (int)z));
    }

    private boolean generate() throws Exception {
        if (this.generateConcurrent) {
            this.executor = Executors.newFixedThreadPool(Settings.settings().QUEUE.PARALLEL_THREADS, new ThreadFactoryBuilder().setNameFormat("fawe-regen-%d").build());
        }
        Int2ObjectOpenHashMap chunkCoordsForRadius = new Int2ObjectOpenHashMap();
        this.chunkStati.keySet().stream().map(ChunkStatusWrapper::requiredNeighborChunkRadius0).distinct().forEach(radius -> {
            if (radius == -1) {
                return;
            }
            int border = 10 - radius;
            chunkCoordsForRadius.put(radius, this.getChunkCoordsRegen(this.region, border));
        });
        for (Iterator xz : (List)chunkCoordsForRadius.get(0)) {
            ProtoChunk ProtoChunk = this.createProtoChunk(MathMan.unpairIntX((long)((Long)((Object)xz))), MathMan.unpairIntY((long)((Long)((Object)xz))));
            this.protoChunks.put((Long)((Object)xz), ProtoChunk);
        }
        Int2ObjectOpenHashMap worldlimits = new Int2ObjectOpenHashMap();
        this.chunkStati.keySet().stream().map(ChunkStatusWrapper::requiredNeighborChunkRadius0).distinct().forEach(radius -> {
            if (radius == -1) {
                return;
            }
            Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
            for (Long xz : (List)chunkCoordsForRadius.get(radius)) {
                int x = MathMan.unpairIntX((long)xz);
                int z = MathMan.unpairIntY((long)xz);
                ArrayList<Object> l = new ArrayList<Object>((radius + 1 + radius) * (radius + 1 + radius));
                for (int zz = z - radius; zz <= z + radius; ++zz) {
                    for (int xx = x - radius; xx <= x + radius; ++xx) {
                        l.add(this.protoChunks.get(MathMan.pairInt((int)xx, (int)zz)));
                    }
                }
                map.put(xz, l);
            }
            worldlimits.put(radius, (Object)map);
        });
        for (Map.Entry entry : this.chunkStati.entrySet()) {
            ChunkStatusWrapper chunkStatus = (ChunkStatusWrapper)entry.getKey();
            int radius2 = chunkStatus.requiredNeighborChunkRadius0();
            List coords = (List)chunkCoordsForRadius.get(radius2);
            if (this.generateConcurrent && entry.getValue() == Concurrency.RADIUS) {
                SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> tasks = this.getChunkStatusTaskRows(coords, radius2);
                for (ConcurrentTasks concurrentTasks : tasks) {
                    ArrayList<Runnable> scheduled = new ArrayList<Runnable>(tasks.size());
                    for (SequentialTasks row : concurrentTasks) {
                        scheduled.add(() -> {
                            for (Long xz : row) {
                                chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get((Object)xz));
                            }
                        });
                    }
                    try {
                        ArrayList futures = new ArrayList();
                        scheduled.forEach(task -> futures.add(this.executor.submit((Runnable)task)));
                        for (Future future : futures) {
                            future.get();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (this.generateConcurrent && entry.getValue() == Concurrency.FULL) {
                ArrayList<Runnable> scheduled = new ArrayList<Runnable>(coords.size());
                Iterator<Object> iterator = coords.iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    scheduled.add(() -> chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get(xz)));
                }
                try {
                    ArrayList futures = new ArrayList();
                    scheduled.forEach(task -> futures.add(this.executor.submit((Runnable)task)));
                    for (Future future : futures) {
                        future.get();
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            this.executor.submit(() -> {
                Iterator iterator = coords.iterator();
                while (iterator.hasNext()) {
                    long xz = (Long)iterator.next();
                    chunkStatus.processChunkSave(xz, (List)((Long2ObjectOpenHashMap)worldlimits.get(radius2)).get(xz));
                }
            }).get();
        }
        for (Long l : (List)chunkCoordsForRadius.get(0)) {
            Object proto = this.protoChunks.get((Object)l);
            this.chunks.put(l, this.createChunk(proto));
        }
        ChunkStatus FULL = this.getFullChunkStatus();
        for (Long xz : (List)chunkCoordsForRadius.get(0)) {
            Object chunk = this.chunks.get((Object)xz);
            ((ChunkStatusWrapper)FULL).processChunkSave(xz, Arrays.asList(chunk));
        }
        List<BlockPopulator> list = this.getBlockPopulators();
        for (Long xz : (List)chunkCoordsForRadius.get(0)) {
            int x = MathMan.unpairIntX((long)xz);
            int z = MathMan.unpairIntY((long)xz);
            Random random = Regenerator.getChunkRandom(this.seed, x, z);
            Object object = this.chunks.get((Object)xz);
            list.forEach(pop -> this.populate((Chunk)c, random, (BlockPopulator)pop));
        }
        this.source = new SingleThreadQueueExtent(BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMinHeight() : 0, BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMaxHeight() : 256);
        this.source.init(this.target, this.initSourceQueueCache(), null);
        return true;
    }

    private void copyToWorld() {
        boolean genbiomes = this.options.shouldRegenBiomes();
        boolean hasBiome = this.options.hasBiomeType();
        BiomeType biome = this.options.getBiomeType();
        if (!genbiomes && !hasBiome) {
            this.target.setBlocks(this.region, (Pattern)new PlacementPattern());
        }
        if (hasBiome) {
            this.target.setBlocks(this.region, (Pattern)new WithBiomePlacementPattern(ignored -> biome));
        } else if (genbiomes) {
            this.target.setBlocks(this.region, (Pattern)new WithBiomePlacementPattern(vec -> this.source.getBiome(vec)));
        }
    }

    private void cleanup0() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.cleanup();
    }

    protected abstract boolean prepare();

    protected abstract boolean initNewWorld() throws Exception;

    protected abstract void cleanup();

    protected abstract ProtoChunk createProtoChunk(int var1, int var2);

    protected abstract Chunk createChunk(ProtoChunk var1);

    protected abstract ChunkStatus getFullChunkStatus();

    protected abstract List<BlockPopulator> getBlockPopulators();

    protected abstract void populate(Chunk var1, Random var2, BlockPopulator var3);

    protected abstract IChunkCache<IChunkGet> initSourceQueueCache();

    private List<Long> getChunkCoordsRegen(Region region, int border) {
        BlockVector3 oldMin = region.getMinimumPoint();
        BlockVector3 newMin = BlockVector3.at((int)((oldMin.getX() >> 4 << 4) - border * 16), (int)oldMin.getY(), (int)((oldMin.getZ() >> 4 << 4) - border * 16));
        BlockVector3 oldMax = region.getMaximumPoint();
        BlockVector3 newMax = BlockVector3.at((int)((oldMax.getX() >> 4 << 4) + (border + 1) * 16 - 1), (int)oldMax.getY(), (int)((oldMax.getZ() >> 4 << 4) + (border + 1) * 16 - 1));
        CuboidRegion adjustedRegion = new CuboidRegion(newMin, newMax);
        return adjustedRegion.getChunks().stream().sorted(Comparator.comparingInt(BlockVector2::getZ).thenComparingInt(BlockVector2::getX)).map(c -> MathMan.pairInt((int)c.getX(), (int)c.getZ())).collect(Collectors.toList());
    }

    private SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> getChunkStatusTaskRows(List<Long> allcoords, int requiredNeighborChunkRadius) {
        SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>> tasks;
        int maxz;
        int requiredneighbors = Math.max(0, requiredNeighborChunkRadius);
        int minx = allcoords.isEmpty() ? 0 : MathMan.unpairIntX((long)allcoords.get(0));
        int maxx = allcoords.isEmpty() ? 0 : MathMan.unpairIntX((long)allcoords.get(allcoords.size() - 1));
        int minz = allcoords.isEmpty() ? 0 : MathMan.unpairIntY((long)allcoords.get(0));
        int n = maxz = allcoords.isEmpty() ? 0 : MathMan.unpairIntY((long)allcoords.get(allcoords.size() - 1));
        if (maxz - minz > maxx - minx) {
            int numlists = Math.min(requiredneighbors * 2 + 1, maxx - minx + 1);
            Int2ObjectOpenHashMap byx = new Int2ObjectOpenHashMap();
            int expectedListLength = (allcoords.size() + 1) / (maxx - minx);
            for (int i = minx; i <= maxx; ++i) {
                byx.put(i, new SequentialTasks(expectedListLength));
            }
            for (Long xz : allcoords) {
                ((SequentialTasks)byx.get(MathMan.unpairIntX((long)xz))).add(xz);
            }
            tasks = new SequentialTasks<ConcurrentTasks<SequentialTasks<Long>>>(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks<SequentialTasks> para = new ConcurrentTasks<SequentialTasks>((maxz - minz + 1) / numlists + 1);
                int i = 0;
                while (minx + i * numlists + offset <= maxx) {
                    para.add((SequentialTasks)byx.get(minx + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        } else {
            int numlists = Math.min(requiredneighbors * 2 + 1, maxz - minz + 1);
            Int2ObjectOpenHashMap byz = new Int2ObjectOpenHashMap();
            int expectedListLength = (allcoords.size() + 1) / (maxz - minz);
            for (int i = minz; i <= maxz; ++i) {
                byz.put(i, new SequentialTasks(expectedListLength));
            }
            for (Long xz : allcoords) {
                ((SequentialTasks)byz.get(MathMan.unpairIntY((long)xz))).add(xz);
            }
            tasks = new SequentialTasks(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks<SequentialTasks> para = new ConcurrentTasks<SequentialTasks>((maxx - minx + 1) / numlists + 1);
                int i = 0;
                while (minz + i * numlists + offset <= maxz) {
                    para.add((SequentialTasks)byz.get(minz + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        }
        return tasks;
    }

    protected BiomeProvider getBiomeProvider() {
        if (this.options.hasBiomeType()) {
            return new SingleBiomeProvider();
        }
        return this.originalBukkitWorld.getBiomeProvider();
    }

    public static abstract class ChunkStatusWrapper<IChunkAccess> {
        public abstract int requiredNeighborChunkRadius();

        int requiredNeighborChunkRadius0() {
            return Math.max(0, this.requiredNeighborChunkRadius());
        }

        public abstract String name();

        public abstract CompletableFuture<?> processChunk(Long var1, List<IChunkAccess> var2);

        void processChunkSave(Long xz, List<IChunkAccess> accessibleChunks) {
            try {
                this.processChunk(xz, accessibleChunks).get();
            }
            catch (Exception e) {
                LOGGER.error("Error while running " + this.name() + " on chunk " + MathMan.unpairIntX((long)xz) + "/" + MathMan.unpairIntY((long)xz), (Throwable)e);
            }
        }
    }

    public static enum Concurrency {
        FULL,
        RADIUS,
        NONE;

    }

    public static class SequentialTasks<T>
    extends Tasks<T> {
        public SequentialTasks(int expectedsize) {
            super(expectedsize);
        }
    }

    public static class ConcurrentTasks<T>
    extends Tasks<T> {
        public ConcurrentTasks(int expectedsize) {
            super(expectedsize);
        }
    }

    private class PlacementPattern
    implements Pattern {
        private PlacementPattern() {
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            return extent.setBlock(set.getX(), set.getY(), set.getZ(), (BlockStateHolder)Regenerator.this.source.getFullBlock(get.getX(), get.getY(), get.getZ()));
        }
    }

    private class WithBiomePlacementPattern
    implements Pattern {
        private final Function<BlockVector3, BiomeType> biomeGetter;

        private WithBiomePlacementPattern(Function<BlockVector3, BiomeType> biomeGetter) {
            this.biomeGetter = biomeGetter;
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            return extent.setBlock(set.getX(), set.getY(), set.getZ(), (BlockStateHolder)Regenerator.this.source.getFullBlock(get.getX(), get.getY(), get.getZ())) && extent.setBiome(set.getX(), set.getY(), set.getZ(), this.biomeGetter.apply(get));
        }
    }

    public class SingleBiomeProvider
    extends BiomeProvider {
        private final Biome biome;

        public SingleBiomeProvider() {
            this.biome = BukkitAdapter.adapt(Regenerator.this.options.getBiomeType());
        }

        public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
            return this.biome;
        }

        public List<Biome> getBiomes(WorldInfo worldInfo) {
            return Collections.singletonList(this.biome);
        }
    }

    public static class Tasks<T>
    implements Iterable<T> {
        private final List<T> tasks;

        public Tasks(int expectedsize) {
            this.tasks = new ArrayList<T>(expectedsize);
        }

        public void add(T task) {
            this.tasks.add(task);
        }

        public List<T> list() {
            return this.tasks;
        }

        public int size() {
            return this.tasks.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.tasks.iterator();
        }

        public String toString() {
            return this.tasks.toString();
        }
    }
}

