/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.apache.logging.log4j.Logger;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TownyFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final Plugin towny;

    public TownyFeature(Plugin townyPlugin) {
        super(townyPlugin.getName());
        this.towny = townyPlugin;
        LOGGER.info("Plugin 'Towny' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, TownBlock block) {
        if (block == null) {
            return false;
        }
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getName());
            try {
                if (block.getResident().equals(resident)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            Town town = block.getTown();
            if (town.isMayor(resident)) {
                return true;
            }
            if (!town.hasResident(resident)) {
                return false;
            }
            if (player.hasPermission("fawe.towny.*")) {
                return true;
            }
            for (String rank : resident.getTownRanks()) {
                if (!player.hasPermission("fawe.towny." + rank)) continue;
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location location = player.getLocation();
        try {
            PlayerCache cache = ((Towny)this.towny).getCache(player);
            WorldCoord mycoord = cache.getLastTownBlock();
            if (mycoord == null) {
                return null;
            }
            final TownBlock myplot = mycoord.getTownBlock();
            if (myplot == null) {
                return null;
            }
            boolean isMember = this.isAllowed(player, myplot);
            if (isMember) {
                Chunk chunk = location.getChunk();
                BlockVector3 pos1 = BlockVector3.at((int)(chunk.getX() * 16), (int)0, (int)(chunk.getZ() * 16));
                BlockVector3 pos2 = BlockVector3.at((int)(chunk.getX() * 16 + 15), (int)156, (int)(chunk.getZ() * 16 + 15));
                return new FaweMask((Region)new CuboidRegion(pos1, pos2)){

                    public boolean isValid(Player player, FaweMaskManager.MaskType type) {
                        return TownyFeature.this.isAllowed(BukkitAdapter.adapt(player), myplot);
                    }
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

