/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.BundledBlockRegistry;
import com.sk89q.worldedit.world.registry.PassthroughBlockMaterial;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import org.bukkit.Material;

public class BukkitBlockRegistry
extends BundledBlockRegistry {
    private BukkitBlockMaterial[] materialMap;

    public Component getRichName(BlockType blockType) {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().getRichBlockName(blockType);
        }
        return super.getRichName(blockType);
    }

    @Nullable
    public BlockMaterial getMaterial(BlockType blockType) {
        BukkitBlockMaterial result;
        BlockMaterial result2;
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null && (result2 = adapter.getMaterial(blockType)) != null) {
            return result2;
        }
        Material mat = BukkitAdapter.adapt(blockType);
        if (mat == null) {
            return new PassthroughBlockMaterial(null);
        }
        if (this.materialMap == null) {
            this.materialMap = new BukkitBlockMaterial[Material.values().length];
        }
        if ((result = this.materialMap[mat.ordinal()]) == null) {
            this.materialMap[mat.ordinal()] = result = new BukkitBlockMaterial(BukkitBlockRegistry.super.getMaterial(blockType), mat);
        }
        return result;
    }

    @Nullable
    public BlockMaterial getMaterial(BlockState state) {
        BlockMaterial result;
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null && (result = adapter.getMaterial(state)) != null) {
            return result;
        }
        return super.getMaterial(state);
    }

    @Nullable
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getProperties(blockType);
        }
        return super.getProperties(blockType);
    }

    public OptionalInt getInternalBlockStateId(BlockState state) {
        if (WorldEditPlugin.getInstance().getBukkitImplAdapter() != null) {
            return WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state);
        }
        return OptionalInt.empty();
    }

    public Collection<String> values() {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getRegisteredDefaultBlockStates();
        }
        return super.values();
    }

    public Map<String, ? extends List<Property<?>>> getAllProperties() {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getAllProperties();
        }
        return super.getAllProperties();
    }

    public static class BukkitBlockMaterial
    extends PassthroughBlockMaterial {
        private final Material material;

        public BukkitBlockMaterial(@Nullable BlockMaterial material, Material bukkitMaterial) {
            super(material);
            this.material = bukkitMaterial;
        }

        public boolean isAir() {
            switch (this.material) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSolid() {
            return this.material.isSolid();
        }

        public boolean isBurnable() {
            return this.material.isBurnable();
        }

        public boolean isTranslucent() {
            return this.material.isTransparent();
        }
    }
}

