/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.fastasyncworldedit.bukkit.util.WorldUnloadedException;
import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.nbt.FaweCompoundTag;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.packet.ChunkPacket;
import com.fastasyncworldedit.core.util.TaskManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.UnsupportedVersionEditException;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.world.AbstractWorld;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.weather.WeatherType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import io.papermc.lib.PaperLib;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BukkitWorld
extends AbstractWorld {
    private static final Logger LOGGER;
    private static final boolean HAS_3D_BIOMES;
    public static final boolean HAS_MIN_Y;
    private static final Map<Integer, Effect> effects;
    private WeakReference<org.bukkit.World> worldRef;
    private final String worldNameRef;
    private final WorldNativeAccess<?, ?, ?> worldNativeAccess;
    private static final EnumMap<TreeGenerator.TreeType, TreeType> treeTypeMapping;
    private static volatile boolean hasWarnedImplError;

    public BukkitWorld(org.bukkit.World world) {
        this.worldRef = new WeakReference<org.bukkit.World>(world);
        this.worldNameRef = world.getName();
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        this.worldNativeAccess = adapter != null ? adapter.createWorldNativeAccess(world) : null;
    }

    public List<Entity> getEntities(Region region) {
        org.bukkit.World world = this.getWorld();
        List ents = (List)TaskManager.taskManager().sync(() -> ((org.bukkit.World)world).getEntities());
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (org.bukkit.entity.Entity ent : ents) {
            if (!region.contains(BukkitAdapter.asBlockVector(ent.getLocation()))) continue;
            entities.add(BukkitAdapter.adapt(ent));
        }
        return entities;
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        List ents = (List)TaskManager.taskManager().sync(() -> ((org.bukkit.World)this.getWorld()).getEntities());
        for (org.bukkit.entity.Entity entity : ents) {
            list.add(BukkitAdapter.adapt(entity));
        }
        return list;
    }

    public org.bukkit.World getWorld() {
        org.bukkit.World tmp = (org.bukkit.World)this.worldRef.get();
        if (tmp == null && (tmp = Bukkit.getWorld((String)this.worldNameRef)) != null) {
            this.worldRef = new WeakReference<org.bukkit.World>(tmp);
        }
        return (org.bukkit.World)Preconditions.checkNotNull((Object)tmp, (Object)"The world was unloaded and the reference is unavailable");
    }

    protected org.bukkit.World getWorldChecked() throws WorldEditException {
        org.bukkit.World tmp = (org.bukkit.World)this.worldRef.get();
        if (tmp == null && (tmp = Bukkit.getWorld((String)this.worldNameRef)) != null) {
            this.worldRef = new WeakReference<org.bukkit.World>(tmp);
        }
        if (tmp == null) {
            throw new WorldUnloadedException(this.worldNameRef);
        }
        return tmp;
    }

    public String getName() {
        return this.getWorldChecked().getName();
    }

    public String getNameUnsafe() {
        return this.worldNameRef;
    }

    public String id() {
        return this.getWorld().getName().replace(" ", "_").toLowerCase(Locale.ROOT);
    }

    public Path getStoragePath() {
        Path worldFolder = this.getWorld().getWorldFolder().toPath();
        switch (this.getWorld().getEnvironment()) {
            case NETHER: {
                return worldFolder.resolve("DIM-1");
            }
            case THE_END: {
                return worldFolder.resolve("DIM1");
            }
        }
        return worldFolder;
    }

    public int getBlockLightLevel(BlockVector3 pt) {
        this.testCoords(pt);
        return this.getWorld().getBlockAt(pt.x(), pt.y(), pt.z()).getLightLevel();
    }

    public boolean regenerate(Region region, Extent extent, RegenOptions options) {
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        try {
            if (adapter != null) {
                return adapter.regenerate(this.getWorld(), region, extent, options);
            }
            throw new UnsupportedOperationException("Missing BukkitImplAdapter for this version.");
        }
        catch (FaweException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Regeneration via adapter failed.", (Throwable)e);
            return false;
        }
    }

    public boolean clearContainerBlockContents(BlockVector3 pt) {
        Preconditions.checkNotNull((Object)pt);
        this.testCoords(pt);
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            try {
                return adapter.clearContainerBlockContents(this.getWorld(), pt);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.getBlock(pt).getBlockType().getMaterial().hasContainer()) {
            return false;
        }
        Block block = this.getWorld().getBlockAt(pt.x(), pt.y(), pt.z());
        BlockState state = PaperLib.getBlockState((Block)block, (boolean)false).getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        TaskManager.taskManager().sync(() -> {
            InventoryHolder chest = (InventoryHolder)state;
            Inventory inven = chest.getInventory();
            if (chest instanceof Chest) {
                inven = ((Chest)chest).getBlockInventory();
            }
            inven.clear();
            return null;
        });
        return true;
    }

    public static TreeType toBukkitTreeType(TreeGenerator.TreeType type) {
        return treeTypeMapping.get(type);
    }

    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, BlockVector3 pt) {
        this.testCoords(pt);
        return WorldEditPlugin.getInstance().getBukkitImplAdapter().generateTree(type, editSession, pt, this.getWorld());
    }

    public void dropItem(Vector3 pt, BaseItemStack item) {
        org.bukkit.World world = this.getWorld();
        world.dropItemNaturally(BukkitAdapter.adapt(world, pt), BukkitAdapter.adapt(item));
    }

    public void checkLoadedChunk(BlockVector3 pt) {
        this.testCoords(pt);
        org.bukkit.World world = this.getWorld();
        int X = pt.x() >> 4;
        int Z = pt.z() >> 4;
        if (Fawe.isMainThread()) {
            world.getChunkAt(X, Z);
        } else if (PaperLib.isPaper()) {
            PaperLib.getChunkAtAsync((org.bukkit.World)world, (int)X, (int)Z, (boolean)true);
        }
    }

    public boolean equals(Object other) {
        org.bukkit.World ref = (org.bukkit.World)this.worldRef.get();
        if (ref == null) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof BukkitWorld) {
            org.bukkit.World otherWorld = (org.bukkit.World)((BukkitWorld)((Object)other)).worldRef.get();
            return ref.equals((Object)otherWorld);
        }
        if (other instanceof World) {
            return ((World)other).getName().equals(ref.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getWorld().hashCode();
    }

    public int getMaxY() {
        return this.getWorld().getMaxHeight() - 1;
    }

    public int getMinY() {
        if (HAS_MIN_Y) {
            return this.getWorld().getMinHeight();
        }
        return super.getMinY();
    }

    public void fixAfterFastMode(Iterable<BlockVector2> chunks) {
        org.bukkit.World world = this.getWorld();
        for (BlockVector2 chunkPos : chunks) {
            world.refreshChunk(chunkPos.x(), chunkPos.z());
        }
    }

    public boolean playEffect(Vector3 position, int type, int data) {
        org.bukkit.World world = this.getWorld();
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        world.playEffect(BukkitAdapter.adapt(world, position), effect, data);
        return true;
    }

    public boolean playBlockBreakEffect(Vector3 position, BlockType type) {
        org.bukkit.World world = this.getWorld();
        world.playEffect(BukkitAdapter.adapt(world, position), Effect.STEP_SOUND, (Object)BukkitAdapter.adapt(type));
        return true;
    }

    public WeatherType getWeather() {
        if (this.getWorld().isThundering()) {
            return WeatherTypes.THUNDER_STORM;
        }
        if (this.getWorld().hasStorm()) {
            return WeatherTypes.RAIN;
        }
        return WeatherTypes.CLEAR;
    }

    public long getRemainingWeatherDuration() {
        return this.getWorld().getWeatherDuration();
    }

    public void setWeather(WeatherType weatherType) {
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            this.getWorld().setThundering(true);
        } else if (weatherType == WeatherTypes.RAIN) {
            this.getWorld().setStorm(true);
        } else {
            this.getWorld().setStorm(false);
            this.getWorld().setThundering(false);
        }
    }

    public void setWeather(WeatherType weatherType, long duration) {
        if (weatherType == WeatherTypes.THUNDER_STORM) {
            this.getWorld().setThundering(true);
            this.getWorld().setThunderDuration((int)duration);
            this.getWorld().setWeatherDuration((int)duration);
        } else if (weatherType == WeatherTypes.RAIN) {
            this.getWorld().setStorm(true);
            this.getWorld().setWeatherDuration((int)duration);
        } else {
            this.getWorld().setStorm(false);
            this.getWorld().setThundering(false);
            this.getWorld().setWeatherDuration((int)duration);
        }
    }

    public BlockVector3 getSpawnPosition() {
        return BukkitAdapter.asBlockVector(this.getWorld().getSpawnLocation());
    }

    public void simulateBlockMine(BlockVector3 pt) {
        this.testCoords(pt);
        this.getWorld().getBlockAt(pt.x(), pt.y(), pt.z()).breakNaturally();
    }

    public Collection<BaseItemStack> getBlockDrops(BlockVector3 position) {
        return this.getWorld().getBlockAt(position.x(), position.y(), position.z()).getDrops().stream().map(BukkitAdapter::adapt).collect(Collectors.toList());
    }

    public boolean canPlaceAt(BlockVector3 position, com.sk89q.worldedit.world.block.BlockState blockState) {
        this.testCoords(position);
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.canPlaceAt(this.getWorld(), position, blockState);
        }
        return true;
    }

    public com.sk89q.worldedit.world.block.BlockState getBlock(BlockVector3 position) {
        block4: {
            this.testCoords(position);
            BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
            if (adapter != null) {
                try {
                    return adapter.getBlock(BukkitAdapter.adapt(this.getWorld(), position)).toImmutableState();
                }
                catch (Exception e) {
                    if (hasWarnedImplError) break block4;
                    hasWarnedImplError = true;
                    LOGGER.warn("Unable to retrieve block via impl adapter", (Throwable)e);
                }
            }
        }
        if (WorldEditPlugin.getInstance().getLocalConfiguration().unsupportedVersionEditing) {
            Block bukkitBlock = this.getWorld().getBlockAt(position.x(), position.y(), position.z());
            return BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        throw new RuntimeException((Throwable)((Object)new UnsupportedVersionEditException()));
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 position, B block, SideEffectSet sideEffects) {
        this.testCoords(position);
        if (this.worldNativeAccess != null) {
            try {
                return this.worldNativeAccess.setBlock(position, block, sideEffects);
            }
            catch (Exception e) {
                if (block instanceof BaseBlock && ((BaseBlock)block).getNbt() != null) {
                    LOGGER.warn("Tried to set a corrupt tile entity at " + position.toString() + ": " + String.valueOf(((BaseBlock)block).getNbt()), (Throwable)e);
                }
                LOGGER.warn("Failed to set block via adapter, falling back to generic", (Throwable)e);
            }
        }
        Block bukkitBlock = this.getWorld().getBlockAt(position.x(), position.y(), position.z());
        bukkitBlock.setBlockData(BukkitAdapter.adapt(block), sideEffects.doesApplyAny());
        return true;
    }

    public BaseBlock getFullBlock(BlockVector3 position) {
        this.testCoords(position);
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.getFullBlock(BukkitAdapter.adapt(this.getWorld(), position));
        }
        return this.getBlock(position).toBaseBlock();
    }

    private void testCoords(BlockVector3 position) throws FaweException {
        if (!Settings.settings().REGION_RESTRICTIONS_OPTIONS.RESTRICT_TO_SAFE_RANGE) {
            return;
        }
        int x = position.x();
        int z = position.z();
        if (x > 30000000 || z > 30000000 || x < -30000000 || z < -30000000) {
            throw FaweCache.OUTSIDE_SAFE_REGION;
        }
    }

    public Set<SideEffect> applySideEffects(BlockVector3 position, com.sk89q.worldedit.world.block.BlockState previousType, SideEffectSet sideEffectSet) {
        this.testCoords(position);
        if (this.worldNativeAccess != null) {
            this.worldNativeAccess.applySideEffects(position, previousType, sideEffectSet);
            return Sets.intersection(WorldEditPlugin.getInstance().getInternalPlatform().getSupportedSideEffects(), (Set)sideEffectSet.getSideEffectsToApply());
        }
        return ImmutableSet.of();
    }

    public boolean useItem(BlockVector3 position, BaseItem item, Direction face) {
        this.testCoords(position);
        BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
        if (adapter != null) {
            return adapter.simulateItemUse(this.getWorld(), position, item, face);
        }
        return false;
    }

    public boolean fullySupports3DBiomes() {
        return HAS_3D_BIOMES && this.getWorld().getEnvironment() != World.Environment.NORMAL || PaperLib.isVersion((int)18);
    }

    public BiomeType getBiome(BlockVector3 position) {
        this.testCoords(position);
        if (HAS_3D_BIOMES) {
            return BukkitAdapter.adapt(this.getWorld().getBiome(position.x(), position.y(), position.z()));
        }
        return BukkitAdapter.adapt(this.getWorld().getBiome(position.x(), position.z()));
    }

    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        this.testCoords(position);
        if (HAS_3D_BIOMES) {
            this.getWorld().setBiome(position.x(), position.y(), position.z(), BukkitAdapter.adapt(biome));
        } else {
            this.getWorld().setBiome(position.x(), position.z(), BukkitAdapter.adapt(biome));
        }
        return true;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
        return this.setBlock(BlockVector3.at((int)x, (int)y, (int)z), block);
    }

    public boolean tile(int x, int y, int z, FaweCompoundTag tile) throws WorldEditException {
        return false;
    }

    public boolean setBiome(int x, int y, int z, BiomeType biome) {
        return this.setBiome(BlockVector3.at((int)x, (int)y, (int)z), biome);
    }

    public void refreshChunk(int chunkX, int chunkZ) {
        this.testCoords(BlockVector3.at((int)(chunkX << 4), (int)0, (int)(chunkZ << 4)));
        this.getWorld().refreshChunk(chunkX, chunkZ);
    }

    public IChunkGet get(int chunkX, int chunkZ) {
        this.testCoords(BlockVector3.at((int)(chunkX << 4), (int)0, (int)(chunkZ << 4)));
        return WorldEditPlugin.getInstance().getBukkitImplAdapter().get(this.getWorldChecked(), chunkX, chunkZ);
    }

    public void sendFakeChunk(Player player, ChunkPacket packet) {
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt(player);
        WorldEditPlugin.getInstance().getBukkitImplAdapter().sendFakeChunk(this.getWorld(), bukkitPlayer, packet);
    }

    public void flush() {
        if (this.worldNativeAccess != null) {
            this.worldNativeAccess.flush();
        }
    }

    static {
        boolean temp;
        LOGGER = LogManagerCompat.getLogger();
        effects = new HashMap<Integer, Effect>();
        Effect[] effectArray = Effect.values();
        int n = effectArray.length;
        for (int i = 0; i < n; ++i) {
            Effect effect = effectArray[i];
            int id = effect.getId();
            effects.put(id, effect);
        }
        try {
            org.bukkit.World.class.getMethod("getBiome", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            temp = true;
        }
        catch (NoSuchMethodException e) {
            temp = false;
        }
        HAS_3D_BIOMES = temp;
        try {
            org.bukkit.World.class.getMethod("getMinHeight", new Class[0]);
            temp = true;
        }
        catch (NoSuchMethodException e) {
            temp = false;
        }
        HAS_MIN_Y = temp;
        treeTypeMapping = new EnumMap(TreeGenerator.TreeType.class);
        for (TreeGenerator.TreeType type : TreeGenerator.TreeType.values()) {
            try {
                TreeType bukkitType = TreeType.valueOf((String)type.name());
                treeTypeMapping.put(type, bukkitType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        treeTypeMapping.put(TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.SMALL_JUNGLE);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM, TreeType.BROWN_MUSHROOM);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_REDWOOD, TreeType.REDWOOD);
        treeTypeMapping.put(TreeGenerator.TreeType.PINE, TreeType.REDWOOD);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_BIRCH, TreeType.BIRCH);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_JUNGLE, TreeType.JUNGLE);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_MUSHROOM, TreeType.BROWN_MUSHROOM);
        for (TreeGenerator.TreeType type : TreeGenerator.TreeType.values()) {
            if (treeTypeMapping.get(type) != null) continue;
            LOGGER.info("No TreeType mapping for TreeGenerator.TreeType." + String.valueOf(type));
            LOGGER.info("The above message is displayed because your FAWE version is newer than {} and contains features of future minecraft versions which do not exist in {} hence the tree type {} is not available. This is not an error. This version of FAWE will work on your version of  Minecraft. This is an informative message only.", (Object)Bukkit.getVersion(), (Object)Bukkit.getVersion(), (Object)type);
        }
        hasWarnedImplError = false;
    }
}

