/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.util.StringUtil;
import com.sk89q.wepif.VaultResolver;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayerBlockBag;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.component.TextUtils;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.adapter.bukkit.TextAdapter;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.enginehub.linbus.tree.LinCompoundTag;

public class BukkitPlayer
extends AbstractPlayerActor {
    private final Player player;
    private final WorldEditPlugin plugin;
    private final PermissionAttachment permAttachment;

    @Deprecated
    public BukkitPlayer(@Nullable Player player) {
        super(player != null ? BukkitPlayer.getExistingMap(WorldEditPlugin.getInstance(), player) : new ConcurrentHashMap());
        this.plugin = WorldEditPlugin.getInstance();
        this.player = player;
        this.permAttachment = this.plugin.getPermissionAttachmentManager().getOrAddAttachment(player);
    }

    @Deprecated
    public BukkitPlayer(@Nonnull WorldEditPlugin plugin, @Nullable Player player) {
        BukkitPlayer cached;
        this.plugin = plugin;
        this.player = player;
        this.permAttachment = plugin.getPermissionAttachmentManager().getOrAddAttachment(player);
        if (player != null && Settings.settings().CLIPBOARD.USE_DISK && (cached = WorldEditPlugin.getInstance().getCachedPlayer(player)) == null) {
            this.loadClipboardFromDisk();
        }
    }

    private static Map<String, Object> getExistingMap(WorldEditPlugin plugin, Player player) {
        BukkitPlayer cached = plugin.getCachedPlayer(player);
        if (cached != null) {
            return cached.getRawMeta();
        }
        return new ConcurrentHashMap<String, Object>();
    }

    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    public BaseItemStack getItemInHand(HandSide handSide) {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.adapt(itemStack);
    }

    public BaseBlock getBlockInHand(HandSide handSide) throws WorldEditException {
        ItemStack itemStack = handSide == HandSide.MAIN_HAND ? this.player.getInventory().getItemInMainHand() : this.player.getInventory().getItemInOffHand();
        return BukkitAdapter.asBlockState(itemStack).toBaseBlock();
    }

    public String getName() {
        return this.player.getName();
    }

    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    public void giveItem(BaseItemStack itemStack) {
        PlayerInventory inv = this.player.getInventory();
        ItemStack newItem = BukkitAdapter.adapt(itemStack);
        TaskManager.taskManager().sync(() -> {
            if (itemStack.getType().id().equalsIgnoreCase(WorldEdit.getInstance().getConfiguration().wandItem)) {
                inv.remove(newItem);
            }
            ItemStack item = this.player.getInventory().getItemInMainHand();
            this.player.getInventory().setItemInMainHand(newItem);
            HashMap overflow = inv.addItem(new ItemStack[]{item});
            if (!overflow.isEmpty()) {
                for (Map.Entry entry : overflow.entrySet()) {
                    ItemStack stack = (ItemStack)entry.getValue();
                    if (stack.getType() == Material.AIR || stack.getAmount() <= 0) continue;
                    Item dropped = this.player.getWorld().dropItem(this.player.getLocation(), stack);
                    PlayerDropItemEvent event = new PlayerDropItemEvent(this.player, dropped);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) continue;
                    dropped.remove();
                }
            }
            this.player.updateInventory();
            return null;
        });
    }

    @Deprecated
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage(part);
        }
    }

    @Deprecated
    public void print(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7d" + part);
        }
    }

    @Deprecated
    public void printDebug(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a77" + part);
        }
    }

    @Deprecated
    public void printError(String msg) {
        for (String part : msg.split("\n")) {
            this.player.sendMessage("\u00a7c" + part);
        }
    }

    public void print(Component component) {
        component = Caption.color((Component)TranslatableComponent.of((String)"prefix", (Component[])new Component[]{component}), (Locale)this.getLocale());
        TextAdapter.sendMessage((CommandSender)this.player, (Component)WorldEditText.format((Component)component, (Locale)this.getLocale()));
    }

    public boolean trySetPosition(Vector3 pos, float pitch, float yaw) {
        com.sk89q.worldedit.util.Location loc;
        Extent extent;
        org.bukkit.World world = this.player.getWorld();
        if (pos instanceof com.sk89q.worldedit.util.Location && (extent = (loc = (com.sk89q.worldedit.util.Location)pos).getExtent()) instanceof World) {
            world = Bukkit.getWorld((String)((World)extent).getName());
        }
        org.bukkit.World finalWorld = world;
        return (Boolean)TaskManager.taskManager().sync(() -> this.player.teleport(new Location(finalWorld, pos.x(), pos.y(), pos.z(), yaw, pitch)));
    }

    public String[] getGroups() {
        return this.plugin.getPermissionsResolver().getGroups((OfflinePlayer)this.player);
    }

    public BlockBag getInventoryBlockBag() {
        return new BukkitPlayerBlockBag(this.player);
    }

    public GameMode getGameMode() {
        return GameModes.get((String)this.player.getGameMode().name().toLowerCase(Locale.ROOT));
    }

    public void setGameMode(GameMode gameMode) {
        this.player.setGameMode(org.bukkit.GameMode.valueOf((String)gameMode.id().toUpperCase(Locale.ROOT)));
    }

    public boolean hasPermission(String perm) {
        return !this.plugin.getLocalConfiguration().noOpPermissions && this.player.isOp() || this.plugin.getPermissionsResolver().hasPermission(this.player.getWorld().getName(), (OfflinePlayer)this.player, perm);
    }

    public void setPermission(String permission, boolean value) {
        boolean usesuperperms;
        boolean bl = usesuperperms = VaultResolver.perms == null;
        if (VaultResolver.perms != null) {
            if (value) {
                if (!VaultResolver.perms.playerAdd(this.player, permission)) {
                    usesuperperms = true;
                }
            } else if (!VaultResolver.perms.playerRemove(this.player, permission)) {
                usesuperperms = true;
            }
        }
        if (usesuperperms) {
            this.permAttachment.setPermission(permission, value);
        }
    }

    public World getWorld() {
        return BukkitAdapter.adapt(this.player.getWorld());
    }

    public void dispatchCUIEvent(CUIEvent event) {
        String[] params = event.getParameters();
        Object send = event.getTypeId();
        if (params.length > 0) {
            send = (String)send + "|" + StringUtil.joinString((String[])params, (String)"|");
        }
        this.player.sendPluginMessage((Plugin)this.plugin, "worldedit:cui", ((String)send).getBytes(StandardCharsets.UTF_8));
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean isAllowedToFly() {
        return this.player.getAllowFlight();
    }

    public void setFlying(boolean flying) {
        this.player.setFlying(flying);
    }

    public BaseEntity getState() {
        throw new UnsupportedOperationException("Cannot create a state from this object");
    }

    public com.sk89q.worldedit.util.Location getLocation() {
        Location nativeLocation = this.player.getLocation();
        Vector3 position = BukkitAdapter.asVector(nativeLocation);
        return new com.sk89q.worldedit.util.Location((Extent)this.getWorld(), position, nativeLocation.getYaw(), nativeLocation.getPitch());
    }

    public boolean setLocation(com.sk89q.worldedit.util.Location location) {
        return this.player.teleport(BukkitAdapter.adapt(location));
    }

    public Locale getLocale() {
        return TextUtils.getLocaleByMinecraftTag((String)this.player.getLocale());
    }

    public void sendAnnouncements() {
        if (!WorldEditPlugin.getInstance().getLifecycledBukkitImplAdapter().isValid()) {
            this.print((Component)Caption.of((String)"worldedit.version.bukkit.unsupported-adapter", (Object[])new Object[]{TextComponent.of((String)"https://intellectualsites.github.io/download/fawe.html", (TextColor)TextColor.AQUA).clickEvent(ClickEvent.openUrl((String)"https://intellectualsites.github.io/download/fawe.html"))}));
        }
    }

    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    public SessionKey getSessionKey() {
        return new SessionKeyImpl(this.player);
    }

    public <B extends BlockStateHolder<B>> void sendFakeBlock(BlockVector3 pos, B block) {
        Location loc = new Location(this.player.getWorld(), (double)pos.x(), (double)pos.y(), (double)pos.z());
        if (block == null) {
            this.player.sendBlockChange(loc, this.player.getWorld().getBlockAt(loc).getBlockData());
        } else {
            LinCompoundTag nbt;
            this.player.sendBlockChange(loc, BukkitAdapter.adapt(block));
            BukkitImplAdapter adapter = WorldEditPlugin.getInstance().getBukkitImplAdapter();
            if (adapter != null && block.getBlockType() == BlockTypes.STRUCTURE_BLOCK && block instanceof BaseBlock && (nbt = ((BaseBlock)block).getNbt()) != null) {
                adapter.sendFakeNBT(this.player, pos, nbt);
                adapter.sendFakeOP(this.player);
            }
        }
    }

    public void sendTitle(Component title, Component sub) {
        String titleStr = WorldEditText.reduceToText((Component)title, (Locale)this.getLocale());
        String subStr = WorldEditText.reduceToText((Component)sub, (Locale)this.getLocale());
        this.player.sendTitle(titleStr, subStr, 0, 70, 20);
    }

    public void unregister() {
        this.player.removeMetadata("WE", (Plugin)WorldEditPlugin.getInstance());
        this.plugin.getPermissionAttachmentManager().removeAttachment(this.player);
        super.unregister();
    }

    static class SessionKeyImpl
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        SessionKeyImpl(Player player) {
            this.uuid = player.getUniqueId();
            this.name = player.getName();
        }

        public UUID getUniqueId() {
            return this.uuid;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return Bukkit.getServer().getPlayer(this.uuid) != null;
        }

        public boolean isPersistent() {
            return true;
        }
    }
}

