/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.ClaimManager;
import com.griefdefender.api.claim.TrustTypes;
import com.griefdefender.lib.flowpowered.math.vector.Vector3i;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.apache.logging.log4j.Logger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GriefDefenderFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    public GriefDefenderFeature(Plugin plugin) {
        super(plugin.getName());
        LOGGER.info("Plugin 'GriefDefender' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, Claim claim, FaweMaskManager.MaskType type) {
        return type == FaweMaskManager.MaskType.MEMBER && claim.isUserTrusted(player.getUniqueId(), TrustTypes.BUILDER);
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        final org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        final Claim claim = GriefDefender.getCore().getClaimAt((Object)player.getLocation());
        if (claim != null && !claim.isWilderness() && this.isAllowed(player, claim, type)) {
            final BlockVector3 pos1 = BlockVector3.at((int)claim.getLesserBoundaryCorner().getX(), (int)claim.getLesserBoundaryCorner().getY(), (int)claim.getLesserBoundaryCorner().getZ());
            final BlockVector3 pos2 = BlockVector3.at((int)claim.getGreaterBoundaryCorner().getX(), (int)claim.getGreaterBoundaryCorner().getY(), (int)claim.getGreaterBoundaryCorner().getZ());
            return new FaweMask((Region)new CuboidRegion(pos1, pos2)){
                private final int[] bounds;
                {
                    super(region);
                    this.bounds = new int[]{pos1.x(), pos1.y(), pos1.z(), pos2.x(), pos2.y(), pos2.z()};
                }

                public boolean isValid(Player wePlayer, FaweMaskManager.MaskType type) {
                    return GriefDefenderFeature.validateClaimAgainstCache(claim, this.bounds) && GriefDefenderFeature.this.isAllowed(player, claim, type);
                }
            };
        }
        return null;
    }

    private static boolean validateClaimAgainstCache(Claim claim, int[] bounds) {
        Vector3i min = claim.getLesserBoundaryCorner();
        Vector3i max = claim.getGreaterBoundaryCorner();
        if (min.getX() != bounds[0] || min.getY() != bounds[1] || min.getZ() != bounds[2]) {
            return false;
        }
        if (max.getX() != bounds[3] || max.getY() != bounds[4] || max.getZ() != bounds[5]) {
            return false;
        }
        ClaimManager manager = GriefDefender.getCore().getClaimManager(claim.getWorldUniqueId());
        if (manager == null) {
            return false;
        }
        return manager.getClaimByUUID(claim.getUniqueId()) != null;
    }
}

