/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.MathMan;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.WorldInfo;

public abstract class Regenerator<IChunkAccess, ProtoChunk extends IChunkAccess, Chunk extends IChunkAccess, ChunkStatus extends ChunkStatusWrapper<IChunkAccess>> {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected final World originalBukkitWorld;
    protected final Region region;
    protected final Extent target;
    protected final RegenOptions options;
    protected final LinkedHashMap<ChunkStatus, Concurrency> chunkStatuses = new LinkedHashMap();
    private final Long2ObjectLinkedOpenHashMap<ProtoChunk> protoChunks = new Long2ObjectLinkedOpenHashMap();
    private final Long2ObjectOpenHashMap<Chunk> chunks = new Long2ObjectOpenHashMap();
    protected boolean generateConcurrent = true;
    protected long seed;
    private ExecutorService executor;
    private SingleThreadQueueExtent source;

    public Regenerator(World originalBukkitWorld, Region region, Extent target, RegenOptions options) {
        this.originalBukkitWorld = originalBukkitWorld;
        this.region = region;
        this.target = target;
        this.options = options;
    }

    private static Random getChunkRandom(long worldSeed, int x, int z) {
        Random random = new Random();
        random.setSeed(worldSeed);
        long xRand = random.nextLong() / 2L * 2L + 1L;
        long zRand = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)x * xRand + (long)z * zRand ^ worldSeed);
        return random;
    }

    public boolean regenerate() throws Exception {
        if (!this.prepare()) {
            return false;
        }
        try {
            if (!this.initNewWorld()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            if (!this.generate()) {
                this.cleanup0();
                return false;
            }
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        try {
            this.copyToWorld();
        }
        catch (Exception e) {
            this.cleanup0();
            throw e;
        }
        this.cleanup0();
        return true;
    }

    protected ProtoChunk getProtoChunkAt(int x, int z) {
        return (ProtoChunk)this.protoChunks.get(MathMan.pairInt((int)x, (int)z));
    }

    protected Chunk getChunkAt(int x, int z) {
        return (Chunk)this.chunks.get(MathMan.pairInt((int)x, (int)z));
    }

    private boolean generate() throws Exception {
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("FAWE Regenerator - %d").build();
        this.executor = this.generateConcurrent ? Executors.newFixedThreadPool(Settings.settings().QUEUE.PARALLEL_THREADS, factory) : Executors.newSingleThreadExecutor(factory);
        LinkedHashMap<ChunkStatusWrapper, long[]> chunkCoordsForChunkStatus = new LinkedHashMap<ChunkStatusWrapper, long[]>();
        int borderSum = 1;
        List reversedKeys = Lists.reverse(new ArrayList<ChunkStatus>(this.chunkStatuses.keySet()));
        for (ChunkStatusWrapper status : reversedKeys) {
            chunkCoordsForChunkStatus.put(status, this.getChunkCoordsRegen(this.region, borderSum));
            borderSum += status.requiredNeighborChunkRadius();
        }
        for (Object xz : (Object)((long[])chunkCoordsForChunkStatus.get(this.chunkStatuses.keySet().iterator().next()))) {
            ProtoChunk chunk = this.createProtoChunk(MathMan.unpairIntX((long)xz), MathMan.unpairIntY((long)xz));
            this.protoChunks.put((long)xz, chunk);
        }
        for (Map.Entry<ChunkStatus, Concurrency> entry : this.chunkStatuses.entrySet()) {
            class LazyChunkList
            extends AbstractList<IChunkAccess> {
                private final int size;
                private final int minX;
                private final int minZ;
                private final int sizeSqrt;

                LazyChunkList(int radius, int centerX, int centerZ) {
                    this.sizeSqrt = radius + 1 + radius;
                    this.size = this.sizeSqrt * this.sizeSqrt;
                    this.minX = centerX - radius;
                    this.minZ = centerZ - radius;
                }

                @Override
                public IChunkAccess get(int index) {
                    Objects.checkIndex(index, this.size);
                    int absX = index % this.sizeSqrt + this.minX;
                    int absZ = index / this.sizeSqrt + this.minZ;
                    return Regenerator.this.protoChunks.get(MathMan.pairInt((int)absX, (int)absZ));
                }

                @Override
                public int size() {
                    return this.size;
                }
            }
            ChunkStatusWrapper chunkStatus = (ChunkStatusWrapper)entry.getKey();
            @Label(value="Regeneration")
            @Category(value={"FAWE"})
            @Name(value="fawe.regen")
            class RegenerationEvent
            extends Event {
                private String chunkStatus;
                private int chunksToProcess;

                RegenerationEvent() {
                }
            }
            RegenerationEvent event = new RegenerationEvent();
            event.begin();
            event.chunkStatus = chunkStatus.name();
            int radius = Math.max(1, chunkStatus.requiredNeighborChunkRadius0());
            long[] coords = (long[])chunkCoordsForChunkStatus.get(chunkStatus);
            event.chunksToProcess = coords.length;
            if (this.generateConcurrent && entry.getValue() == Concurrency.RADIUS) {
                SequentialTasks<ConcurrentTasks<LongList>> tasks = this.getChunkStatusTaskRows(coords, radius);
                for (ConcurrentTasks concurrentTasks : tasks) {
                    ArrayList<Runnable> scheduled = new ArrayList<Runnable>(tasks.size());
                    for (LongList row : concurrentTasks) {
                        scheduled.add(() -> {
                            LongListIterator longListIterator = row.iterator();
                            while (longListIterator.hasNext()) {
                                long xz = (Long)longListIterator.next();
                                chunkStatus.processChunkSave(xz, new LazyChunkList(radius, MathMan.unpairIntX((long)xz), MathMan.unpairIntY((long)xz)));
                            }
                        });
                    }
                    this.runAndWait(scheduled);
                }
            } else if (this.generateConcurrent && entry.getValue() == Concurrency.FULL) {
                ArrayList<Runnable> scheduled = new ArrayList<Runnable>(coords.length);
                for (Object xz : (Object)coords) {
                    scheduled.add(() -> this.lambda$generate$1(chunkStatus, (long)xz, radius));
                }
                this.runAndWait(scheduled);
            } else {
                this.executor.submit(() -> {
                    for (long xz : coords) {
                        chunkStatus.processChunkSave(xz, new LazyChunkList(radius, MathMan.unpairIntX((long)xz), MathMan.unpairIntY((long)xz)));
                    }
                }).get();
            }
            event.commit();
        }
        for (Object xz : (Object)((long[])chunkCoordsForChunkStatus.values().iterator().next())) {
            Object proto = this.protoChunks.get((long)xz);
            this.chunks.put((long)xz, this.createChunk(proto));
        }
        ChunkStatus FULL = this.getFullChunkStatus();
        for (long xz : (long[])chunkCoordsForChunkStatus.values().iterator().next()) {
            Object chunk = this.chunks.get(xz);
            ((ChunkStatusWrapper)FULL).processChunkSave(xz, List.of(chunk));
        }
        List<BlockPopulator> populators = this.getBlockPopulators();
        for (long xz : (long[])chunkCoordsForChunkStatus.values().iterator().next()) {
            int x = MathMan.unpairIntX((long)xz);
            int n = MathMan.unpairIntY((long)xz);
            Random random = Regenerator.getChunkRandom(this.seed, x, n);
            Object c = this.chunks.get(xz);
            populators.forEach(pop -> this.populate((Chunk)c, random, (BlockPopulator)pop));
        }
        this.source = new SingleThreadQueueExtent(BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMinHeight() : 0, BukkitWorld.HAS_MIN_Y ? this.originalBukkitWorld.getMaxHeight() : 256);
        this.source.init(this.target, this.initSourceQueueCache(), null);
        return true;
    }

    private void runAndWait(List<Runnable> tasks) {
        try {
            ArrayList futures = new ArrayList();
            tasks.forEach(task -> futures.add(this.executor.submit((Runnable)task)));
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    private void copyToWorld() {
        boolean genbiomes = this.options.shouldRegenBiomes();
        boolean hasBiome = this.options.hasBiomeType();
        BiomeType biome = this.options.getBiomeType();
        if (!genbiomes && !hasBiome) {
            this.target.setBlocks(this.region, (Pattern)new PlacementPattern());
        }
        if (hasBiome) {
            this.target.setBlocks(this.region, (Pattern)new WithBiomePlacementPattern(ignored -> biome));
        } else if (genbiomes) {
            this.target.setBlocks(this.region, (Pattern)new WithBiomePlacementPattern(vec -> this.source.getBiome(vec)));
        }
    }

    private void cleanup0() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.cleanup();
    }

    protected abstract boolean prepare();

    protected abstract boolean initNewWorld() throws Exception;

    protected abstract void cleanup();

    protected abstract ProtoChunk createProtoChunk(int var1, int var2);

    protected abstract Chunk createChunk(ProtoChunk var1);

    protected abstract ChunkStatus getFullChunkStatus();

    protected abstract List<BlockPopulator> getBlockPopulators();

    protected abstract void populate(Chunk var1, Random var2, BlockPopulator var3);

    protected abstract IChunkCache<IChunkGet> initSourceQueueCache();

    private long[] getChunkCoordsRegen(Region region, int border) {
        BlockVector3 oldMin = region.getMinimumPoint();
        BlockVector3 newMin = BlockVector3.at((int)((oldMin.getX() >> 4 << 4) - border * 16), (int)oldMin.getY(), (int)((oldMin.getZ() >> 4 << 4) - border * 16));
        BlockVector3 oldMax = region.getMaximumPoint();
        BlockVector3 newMax = BlockVector3.at((int)((oldMax.getX() >> 4 << 4) + (border + 1) * 16 - 1), (int)oldMax.getY(), (int)((oldMax.getZ() >> 4 << 4) + (border + 1) * 16 - 1));
        CuboidRegion adjustedRegion = new CuboidRegion(newMin, newMax);
        return adjustedRegion.getChunks().stream().sorted(Comparator.comparingInt(BlockVector2::getZ).thenComparingInt(BlockVector2::getX)).mapToLong(c -> MathMan.pairInt((int)c.getX(), (int)c.getZ())).toArray();
    }

    private SequentialTasks<ConcurrentTasks<LongList>> getChunkStatusTaskRows(long[] allCoords, int requiredNeighborChunkRadius) {
        SequentialTasks<ConcurrentTasks<LongList>> tasks;
        int requiredNeighbors = Math.max(0, requiredNeighborChunkRadius);
        int coordsCount = allCoords.length;
        long first = coordsCount == 0 ? 0L : allCoords[0];
        long last = coordsCount == 0 ? 0L : allCoords[coordsCount - 1];
        int minX = MathMan.unpairIntX((long)first);
        int maxX = MathMan.unpairIntX((long)last);
        int minZ = MathMan.unpairIntY((long)first);
        int maxZ = MathMan.unpairIntY((long)last);
        if (maxZ - minZ > maxX - minX) {
            int numlists = Math.min(requiredNeighbors * 2 + 1, maxX - minX + 1);
            Int2ObjectOpenHashMap byX = new Int2ObjectOpenHashMap();
            int expectedListLength = (coordsCount + 1) / (maxX - minX);
            for (int i = minX; i <= maxX; ++i) {
                byX.put(i, (Object)new LongArrayList(expectedListLength));
            }
            for (long allCoord : allCoords) {
                ((LongList)byX.get(MathMan.unpairIntX((long)allCoord))).add(allCoord);
            }
            tasks = new SequentialTasks<ConcurrentTasks<LongList>>(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks<LongList> para = new ConcurrentTasks<LongList>((maxZ - minZ + 1) / numlists + 1);
                int i = 0;
                while (minX + i * numlists + offset <= maxX) {
                    para.add((LongList)byX.get(minX + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        } else {
            int numlists = Math.min(requiredNeighbors * 2 + 1, maxZ - minZ + 1);
            Int2ObjectOpenHashMap byZ = new Int2ObjectOpenHashMap();
            int expectedListLength = (coordsCount + 1) / (maxZ - minZ + 2);
            for (int i = minZ; i <= maxZ; ++i) {
                byZ.put(i, (Object)new LongArrayList(expectedListLength));
            }
            for (long allCoord : allCoords) {
                ((LongList)byZ.get(MathMan.unpairIntY((long)allCoord))).add(allCoord);
            }
            tasks = new SequentialTasks(numlists);
            for (int offset = 0; offset < numlists; ++offset) {
                ConcurrentTasks<LongList> para = new ConcurrentTasks<LongList>((maxX - minX + 1) / numlists + 1);
                int i = 0;
                while (minZ + i * numlists + offset <= maxZ) {
                    para.add((LongList)byZ.get(minZ + i * numlists + offset));
                    ++i;
                }
                tasks.add(para);
            }
        }
        return tasks;
    }

    protected BiomeProvider getBiomeProvider() {
        if (this.options.hasBiomeType()) {
            return new SingleBiomeProvider();
        }
        return this.originalBukkitWorld.getBiomeProvider();
    }

    private /* synthetic */ void lambda$generate$1(ChunkStatusWrapper chunkStatus, long xz, int radius) {
        chunkStatus.processChunkSave(xz, new LazyChunkList(radius, MathMan.unpairIntX((long)xz), MathMan.unpairIntY((long)xz)));
    }

    public static abstract class ChunkStatusWrapper<IChunkAccess> {
        public abstract int requiredNeighborChunkRadius();

        int requiredNeighborChunkRadius0() {
            return Math.max(0, this.requiredNeighborChunkRadius());
        }

        public abstract String name();

        public abstract CompletableFuture<?> processChunk(List<IChunkAccess> var1);

        void processChunkSave(long xz, List<IChunkAccess> accessibleChunks) {
            try {
                this.processChunk(accessibleChunks).get();
            }
            catch (Exception e) {
                LOGGER.error("Error while running {} on chunk {}/{}", (Object)this.name(), (Object)MathMan.unpairIntX((long)xz), (Object)MathMan.unpairIntY((long)xz), (Object)e);
            }
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum Concurrency {
        FULL,
        RADIUS,
        NONE;

    }

    public static class SequentialTasks<T>
    extends Tasks<T> {
        public SequentialTasks(int expectedSize) {
            super(expectedSize);
        }
    }

    public static class ConcurrentTasks<T>
    extends Tasks<T> {
        public ConcurrentTasks(int expectedSize) {
            super(expectedSize);
        }
    }

    private class PlacementPattern
    implements Pattern {
        private PlacementPattern() {
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            return extent.setBlock(set.getX(), set.getY(), set.getZ(), (BlockStateHolder)Regenerator.this.source.getFullBlock(get.getX(), get.getY(), get.getZ()));
        }
    }

    private class WithBiomePlacementPattern
    implements Pattern {
        private final Function<BlockVector3, BiomeType> biomeGetter;

        private WithBiomePlacementPattern(Function<BlockVector3, BiomeType> biomeGetter) {
            this.biomeGetter = biomeGetter;
        }

        public BaseBlock applyBlock(BlockVector3 position) {
            return Regenerator.this.source.getFullBlock(position);
        }

        public boolean apply(Extent extent, BlockVector3 get, BlockVector3 set) throws WorldEditException {
            return extent.setBlock(set.getX(), set.getY(), set.getZ(), (BlockStateHolder)Regenerator.this.source.getFullBlock(get.getX(), get.getY(), get.getZ())) && extent.setBiome(set.getX(), set.getY(), set.getZ(), this.biomeGetter.apply(get));
        }
    }

    public class SingleBiomeProvider
    extends BiomeProvider {
        private final Biome biome;

        public SingleBiomeProvider() {
            this.biome = BukkitAdapter.adapt(Regenerator.this.options.getBiomeType());
        }

        public Biome getBiome(WorldInfo worldInfo, int x, int y, int z) {
            return this.biome;
        }

        public List<Biome> getBiomes(WorldInfo worldInfo) {
            return Collections.singletonList(this.biome);
        }
    }

    public static class Tasks<T>
    implements Iterable<T> {
        private final List<T> tasks;

        public Tasks(int expectedSize) {
            this.tasks = new ArrayList<T>(expectedSize);
        }

        public void add(T task) {
            this.tasks.add(task);
        }

        public List<T> list() {
            return this.tasks;
        }

        public int size() {
            return this.tasks.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.tasks.iterator();
        }

        public String toString() {
            return this.tasks.toString();
        }
    }
}

