/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.adapter.BukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.core.FAWEPlatformAdapterImpl;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.util.MathMan;
import java.util.function.Function;

public class NMSAdapter
implements FAWEPlatformAdapterImpl {
    public static int createPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, char[] set, CachedBukkitAdapter adapter) {
        int i;
        int num_palette = 0;
        for (int i2 = 0; i2 < 4096; ++i2) {
            int palette;
            int ordinal = set[i2];
            if (ordinal == 0) {
                ordinal = 1;
            }
            if ((palette = blockToPalette[ordinal]) != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        for (i = 0; i < 4096; ++i) {
            int palette;
            char ordinal = set[i];
            if (ordinal == '\u0000') {
                ordinal = '\u0001';
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        return num_palette;
    }

    public static int createPalette(int layer, int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, Function<Integer, char[]> get, char[] set, CachedBukkitAdapter adapter) {
        int i;
        int num_palette = 0;
        char[] getArr = null;
        for (int i2 = 0; i2 < 4096; ++i2) {
            int palette;
            int ordinal = set[i2];
            if (ordinal == 0) {
                if (getArr == null) {
                    getArr = get.apply(layer);
                }
                if ((ordinal = getArr[i2]) == 0) {
                    ordinal = 1;
                }
            }
            if ((palette = blockToPalette[ordinal]) != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        for (i = 0; i < 4096; ++i) {
            int palette;
            char ordinal = set[i];
            if (ordinal == '\u0000') {
                if (getArr == null) {
                    getArr = get.apply(layer);
                }
                if ((ordinal = getArr[i]) == '\u0000') {
                    ordinal = '\u0001';
                }
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        return num_palette;
    }

    public void sendChunk(IChunkGet chunk, int mask, boolean lighting) {
        if (!(chunk instanceof BukkitGetBlocks)) {
            throw new IllegalArgumentException("(IChunkGet) chunk not of type BukkitGetBlocks");
        }
        ((BukkitGetBlocks)chunk).send(mask, lighting);
    }
}

