/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.util;

import com.google.common.collect.ComparisonChain;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;

public class MinecraftVersion
implements Comparable<MinecraftVersion> {
    public static final MinecraftVersion NETHER = new MinecraftVersion(1, 16);
    public static final MinecraftVersion CAVES_17 = new MinecraftVersion(1, 17);
    public static final MinecraftVersion CAVES_18 = new MinecraftVersion(1, 18);
    private final int major;
    private final int minor;
    private final int release;

    public MinecraftVersion(int major, int minor, int release) {
        this.major = major;
        this.minor = minor;
        this.release = release;
    }

    public MinecraftVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public MinecraftVersion() {
        String[] versionParts = MinecraftVersion.getPackageVersion().split("_");
        if (versionParts.length != 3) {
            throw new IllegalStateException("Failed to determine minecraft version!");
        }
        this.major = Integer.parseInt(versionParts[0].substring(1));
        this.minor = Integer.parseInt(versionParts[1]);
        this.release = Integer.parseInt(versionParts[2].substring(1));
    }

    public boolean isEqual(MinecraftVersion other) {
        return this.compareTo(other) == 0;
    }

    public boolean isEqualOrHigherThan(MinecraftVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isEqualOrLowerThan(MinecraftVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isHigherThan(MinecraftVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLowerThan(MinecraftVersion other) {
        return this.compareTo(other) < 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    @Override
    public int compareTo(@Nonnull MinecraftVersion other) {
        if (other.equals(this)) {
            return 0;
        }
        return ComparisonChain.start().compare(this.getMajor(), other.getMajor()).compare(this.getMinor(), other.getMinor()).compare(this.getRelease(), other.getRelease()).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinecraftVersion that = (MinecraftVersion)o;
        if (this.getMajor() != that.getMajor()) {
            return false;
        }
        if (this.getMinor() != that.getMinor()) {
            return false;
        }
        return this.getRelease() == that.getRelease();
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.release;
    }

    private static String getPackageVersion() {
        String fullPackagePath = Bukkit.getServer().getClass().getPackage().getName();
        return fullPackagePath.substring(fullPackagePath.lastIndexOf(46) + 1);
    }
}

