/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.apache.logging.log4j.Logger;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GriefPreventionFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    public GriefPreventionFeature(Plugin griefpreventionPlugin) {
        super(griefpreventionPlugin.getName());
        LOGGER.info("Plugin 'GriefPrevention' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, Claim claim, FaweMaskManager.MaskType type) {
        return claim != null && (claim.getOwnerName().equalsIgnoreCase(player.getName()) || claim.getOwnerName().equals(player.getUniqueId()) || type == FaweMaskManager.MaskType.MEMBER && claim.allowBuild(player, Material.AIR) == null);
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        final org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        final Claim claim = GriefPrevention.instance.dataStore.getClaimAt(player.getLocation(), true, null);
        if (claim != null && this.isAllowed(player, claim, type)) {
            claim.getGreaterBoundaryCorner().getBlockX();
            BlockVector3 pos1 = BlockVector3.at((int)claim.getLesserBoundaryCorner().getBlockX(), (int)player.getWorld().getMinHeight(), (int)claim.getLesserBoundaryCorner().getBlockZ());
            BlockVector3 pos2 = BlockVector3.at((int)claim.getGreaterBoundaryCorner().getBlockX(), (int)player.getWorld().getMaxHeight(), (int)claim.getGreaterBoundaryCorner().getBlockZ());
            return new FaweMask((Region)new CuboidRegion(pos1, pos2)){

                public boolean isValid(Player wePlayer, FaweMaskManager.MaskType type) {
                    return GriefPreventionFeature.this.isAllowed(player, claim, type);
                }
            };
        }
        return null;
    }
}

