/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.regions;

import com.fastasyncworldedit.bukkit.regions.BukkitMaskManager;
import com.fastasyncworldedit.core.regions.FaweMask;
import com.fastasyncworldedit.core.regions.FaweMaskManager;
import com.flowpowered.math.vector.Vector3i;
import com.griefdefender.api.GriefDefender;
import com.griefdefender.api.claim.Claim;
import com.griefdefender.api.claim.TrustTypes;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.apache.logging.log4j.Logger;
import org.bukkit.Location;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GriefDefenderFeature
extends BukkitMaskManager
implements Listener {
    private static final Logger LOGGER = LogManagerCompat.getLogger();

    public GriefDefenderFeature(Plugin GriefDefenderPlugin) {
        super(GriefDefenderPlugin.getName());
        LOGGER.info("Plugin 'GriefDefender' found. Using it now.");
    }

    public boolean isAllowed(org.bukkit.entity.Player player, Claim claim, FaweMaskManager.MaskType type) {
        return GriefDefender.getCore().isEnabled(player.getWorld().getUID()) && !claim.isWilderness() && (claim.getOwnerName().equalsIgnoreCase(player.getName()) || claim.getOwnerUniqueId().equals(player.getUniqueId()) || type == FaweMaskManager.MaskType.MEMBER && claim.getUserTrusts(TrustTypes.BUILDER).contains(player.getUniqueId()));
    }

    public FaweMask getMask(Player wePlayer, FaweMaskManager.MaskType type, boolean isWhitelist) {
        final org.bukkit.entity.Player player = BukkitAdapter.adapt(wePlayer);
        Location loc = player.getLocation();
        Vector3i vector = Vector3i.from((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
        final Claim claim = GriefDefender.getCore().getClaimManager(loc.getWorld().getUID()).getClaimAt(vector);
        if (!claim.isWilderness() && this.isAllowed(player, claim, type)) {
            claim.getGreaterBoundaryCorner().getX();
            BlockVector3 pos1 = BlockVector3.at((int)claim.getLesserBoundaryCorner().getX(), (int)claim.getLesserBoundaryCorner().getY(), (int)claim.getLesserBoundaryCorner().getZ());
            BlockVector3 pos2 = BlockVector3.at((int)claim.getGreaterBoundaryCorner().getX(), (int)claim.getGreaterBoundaryCorner().getY(), (int)claim.getGreaterBoundaryCorner().getZ());
            return new FaweMask((Region)new CuboidRegion(pos1, pos2)){

                public boolean isValid(Player wePlayer, FaweMaskManager.MaskType type) {
                    return GriefDefenderFeature.this.isAllowed(player, claim, type);
                }
            };
        }
        return null;
    }
}

