/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.bukkit.adapter;

import com.fastasyncworldedit.bukkit.adapter.BukkitGetBlocks;
import com.fastasyncworldedit.bukkit.adapter.CachedBukkitAdapter;
import com.fastasyncworldedit.core.FAWEPlatformAdapterImpl;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.Map;
import java.util.function.Function;

public class NMSAdapter
implements FAWEPlatformAdapterImpl {
    public static int createPalette(int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, int[] num_palette_buffer, char[] set, Map<BlockVector3, Integer> ticking_blocks, boolean fastmode, CachedBukkitAdapter adapter) {
        int air = 0;
        int num_palette = 0;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            int ordinal = set[i];
            if (ordinal == 0) {
                ordinal = 1;
            }
            if ((palette = blockToPalette[ordinal]) != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (int i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        char lastOrdinal = '\u0000';
        boolean lastticking = false;
        boolean tick_placed = Settings.settings().EXPERIMENTAL.ALLOW_TICK_PLACED;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            char ordinal = set[i];
            switch (ordinal) {
                case '\u0000': {
                    ordinal = '\u0001';
                }
                case '\u0001': 
                case '\u0002': 
                case '\u0003': {
                    ++air;
                    break;
                }
                default: {
                    boolean ticking;
                    if (fastmode || tick_placed) break;
                    if (ordinal != lastOrdinal) {
                        ticking = BlockTypesCache.ticking[ordinal];
                        lastOrdinal = ordinal;
                        lastticking = ticking;
                    } else {
                        ticking = lastticking;
                    }
                    if (!ticking) break;
                    BlockState state = BlockState.getFromOrdinal((int)ordinal);
                    ticking_blocks.put(BlockVector3.at((int)(i & 0xF), (int)(i >> 8 & 0xF), (int)(i >> 4 & 0xF)), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                }
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        num_palette_buffer[0] = num_palette;
        return air;
    }

    public static int createPalette(int layer, int[] blockToPalette, int[] paletteToBlock, int[] blocksCopy, int[] num_palette_buffer, Function<Integer, char[]> get, char[] set, Map<BlockVector3, Integer> ticking_blocks, boolean fastmode, CachedBukkitAdapter adapter) {
        int air = 0;
        int num_palette = 0;
        char[] getArr = null;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            int ordinal = set[i];
            if (ordinal == 0) {
                if (getArr == null) {
                    getArr = get.apply(layer);
                }
                if ((ordinal = getArr[i]) == 0) {
                    ordinal = 1;
                }
            }
            if ((palette = blockToPalette[ordinal]) != Integer.MAX_VALUE) continue;
            blockToPalette[ordinal] = num_palette;
            paletteToBlock[num_palette] = ordinal;
            ++num_palette;
        }
        int bitsPerEntry = MathMan.log2nlz((int)(num_palette - 1));
        if (bitsPerEntry > 8 && adapter != null) {
            for (int i = 0; i < adapter.getIbdToStateOrdinal().length; ++i) {
                paletteToBlock[i] = adapter.getIbdToStateOrdinal()[i];
            }
            System.arraycopy(adapter.getOrdinalToIbdID(), 0, blockToPalette, 0, adapter.getOrdinalToIbdID().length);
        }
        char lastOrdinal = '\u0000';
        boolean lastticking = false;
        boolean tick_placed = Settings.settings().EXPERIMENTAL.ALLOW_TICK_PLACED;
        boolean tick_existing = Settings.settings().EXPERIMENTAL.ALLOW_TICK_EXISTING;
        for (int i = 0; i < 4096; ++i) {
            int palette;
            BlockState state;
            boolean ticking;
            char ordinal = set[i];
            switch (ordinal) {
                case '\u0000': {
                    char c;
                    if (getArr == null) {
                        getArr = get.apply(layer);
                    }
                    ordinal = getArr[i];
                    switch (ordinal) {
                        case '\u0000': {
                            ordinal = '\u0001';
                        }
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': {
                            ++air;
                            c = ordinal;
                            break;
                        }
                        default: {
                            if (!fastmode && !tick_placed && tick_existing) {
                                if (ordinal != lastOrdinal) {
                                    ticking = BlockTypesCache.ticking[ordinal];
                                    lastOrdinal = ordinal;
                                    lastticking = ticking;
                                } else {
                                    ticking = lastticking;
                                }
                                if (ticking) {
                                    state = BlockState.getFromOrdinal((int)ordinal);
                                    ticking_blocks.put(BlockVector3.at((int)(i & 0xF), (int)(i >> 8 & 0xF), (int)(i >> 4 & 0xF)), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                                }
                            }
                            c = ordinal;
                        }
                    }
                    set[i] = c;
                    break;
                }
                case '\u0001': 
                case '\u0002': 
                case '\u0003': {
                    ++air;
                }
            }
            if (!fastmode && tick_placed) {
                if (ordinal != lastOrdinal) {
                    ticking = BlockTypesCache.ticking[ordinal];
                    lastOrdinal = ordinal;
                    lastticking = ticking;
                } else {
                    ticking = lastticking;
                }
                if (ticking) {
                    state = BlockState.getFromOrdinal((int)ordinal);
                    ticking_blocks.put(BlockVector3.at((int)(i & 0xF), (int)(i >> 8 & 0xF), (int)(i >> 4 & 0xF)), WorldEditPlugin.getInstance().getBukkitImplAdapter().getInternalBlockStateId(state).orElse(0));
                }
            }
            blocksCopy[i] = palette = blockToPalette[ordinal];
        }
        num_palette_buffer[0] = num_palette;
        return air;
    }

    public void sendChunk(IChunkGet chunk, int mask, boolean lighting) {
        if (!(chunk instanceof BukkitGetBlocks)) {
            throw new IllegalArgumentException("(IChunkGet) chunk not of type BukkitGetBlocks");
        }
        ((BukkitGetBlocks)chunk).send(mask, lighting);
    }
}

