/*
 * Decompiled with CFR 0.152.
 */
package com.ezylang.evalex.functions.basic;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.AbstractFunction;
import com.ezylang.evalex.functions.FunctionParameter;
import com.ezylang.evalex.parser.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

@FunctionParameter(name="value", nonNegative=true)
public class SqrtFunction
extends AbstractFunction {
    @Override
    public EvaluationValue evaluate(Expression expression, Token functionToken, EvaluationValue ... parameterValues) {
        BigInteger ixPrev;
        BigInteger test;
        BigDecimal x = parameterValues[0].getNumberValue();
        MathContext mathContext = expression.getConfiguration().getMathContext();
        if (x.compareTo(BigDecimal.ZERO) == 0) {
            return new EvaluationValue(BigDecimal.ZERO);
        }
        BigInteger n = x.movePointRight(mathContext.getPrecision() << 1).toBigInteger();
        int bits = n.bitLength() + 1 >> 1;
        BigInteger ix = n.shiftRight(bits);
        do {
            ixPrev = ix;
            ix = ix.add(n.divide(ix)).shiftRight(1);
            Thread.yield();
        } while ((test = ix.subtract(ixPrev).abs()).compareTo(BigInteger.ZERO) != 0 && test.compareTo(BigInteger.ONE) != 0);
        return new EvaluationValue(new BigDecimal(ix, mathContext.getPrecision()));
    }
}

