/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tuple;

public class Pair<L, R> {
    public L left;
    public R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }

    public Sealed<L, R> sealed() {
        return new Sealed<L, R>(this.left, this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.left != null ? !this.left.equals(pair.left) : pair.left != null) {
            return false;
        }
        return !(this.right == null ? pair.right != null : !this.right.equals(pair.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return '(' + (this.left == null ? null : this.left.toString()) + ',' + (this.right == null ? null : this.right.toString()) + ')';
    }

    public <L2> Pair<L2, R> map_left(L2 left) {
        return Pair.of(left, this.right);
    }

    public <R2> Pair<L, R2> map_right(R2 right) {
        return Pair.of(this.left, right);
    }

    public static class Sealed<L, R> {
        public final L left;
        public final R right;

        protected Sealed(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public static <L, R> Sealed<L, R> of(L left, R right) {
            return new Sealed<L, R>(left, right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Sealed)) {
                return false;
            }
            Sealed pair = (Sealed)o;
            if (this.left != null ? !this.left.equals(pair.left) : pair.left != null) {
                return false;
            }
            return !(this.right == null ? pair.right != null : !this.right.equals(pair.right));
        }

        public int hashCode() {
            int result = this.left != null ? this.left.hashCode() : 0;
            result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
            return result;
        }

        public String toString() {
            return '(' + (this.left == null ? null : this.left.toString()) + ',' + (this.right == null ? null : this.right.toString()) + ')';
        }
    }
}

