/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.tree.oct;

import com.extollit.linalg.immutable.IntAxisAlignedBox;
import com.extollit.linalg.mutable.Vec3i;
import com.extollit.tree.oct.AddEntryOctantOp;
import com.extollit.tree.oct.AllIterationOctantOp;
import com.extollit.tree.oct.BoxIterationOctantOp;
import com.extollit.tree.oct.BulkRemoveOp;
import com.extollit.tree.oct.IIterationOctantOperation;
import com.extollit.tree.oct.Octant;
import com.extollit.tree.oct.PointIterationOctantOp;
import com.extollit.tree.oct.RemoveOp;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class OctTree<T> {
    private final Octant<T> root;
    private final Set<Entry<T>> remq = new HashSet<Entry<T>>();

    public OctTree() {
        this.root = new Octant();
    }

    public void add(IntAxisAlignedBox key, T value) {
        this.flushRemovals();
        AddEntryOctantOp<T> addOp = new AddEntryOctantOp<T>(new Entry<T>(key, value));
        this.root.operation(addOp, key, new Vec3i(0, 0, 0), 0x40000000);
    }

    public void remove(IntAxisAlignedBox key, T value) {
        this.flushRemovals();
        this.remove(new Entry<T>(key, value));
    }

    private void remove(Entry<T> entry) {
        this.flushRemovals();
        RemoveOp<T> remOp = new RemoveOp<T>(entry);
        this.root.operation(remOp, entry.key, new Vec3i(0, 0, 0), 0x40000000);
    }

    public Iterator<Entry<T>> findAll(com.extollit.linalg.immutable.Vec3i point) {
        this.flushRemovals();
        return new PointIter(point);
    }

    public Iterator<Entry<T>> findAll(IntAxisAlignedBox box) {
        this.flushRemovals();
        return new BoxIter(box);
    }

    public Iterator<Entry<T>> findAll() {
        this.flushRemovals();
        return new AllIter();
    }

    public void flushRemovals() {
        if (!this.remq.isEmpty()) {
            BulkRemoveOp<T> remOp = new BulkRemoveOp<T>(this.remq);
            this.root.operation(remOp, remOp.range, new Vec3i(0, 0, 0), 0x40000000);
            this.remq.clear();
        }
    }

    private class BoxIter
    extends BaseIter
    implements Iterator<Entry<T>> {
        private final IntAxisAlignedBox query;

        public BoxIter(IntAxisAlignedBox query) {
            super(new BoxIterationOctantOp(query));
            this.query = query;
        }

        @Override
        protected void start(Octant<T> root, IIterationOctantOperation<T> op) {
            root.operation(op, this.query, new Vec3i(0, 0, 0), 0x40000000);
        }
    }

    private class AllIter
    extends BaseIter
    implements Iterator<Entry<T>> {
        protected AllIter() {
            super(new AllIterationOctantOp());
        }

        @Override
        protected void start(Octant<T> root, IIterationOctantOperation<T> op) {
            root.operation(op, new Vec3i(0, 0, 0), 0x40000000);
        }
    }

    private class PointIter
    extends BaseIter
    implements Iterator<Entry<T>> {
        private final com.extollit.linalg.immutable.Vec3i query;

        public PointIter(com.extollit.linalg.immutable.Vec3i query) {
            super(new PointIterationOctantOp(query));
            this.query = query;
        }

        @Override
        protected void start(Octant<T> root, IIterationOctantOperation<T> op) {
            root.operation(op, this.query, new Vec3i(0, 0, 0), 0x40000000);
        }
    }

    private abstract class BaseIter
    implements Iterator<Entry<T>> {
        private final IIterationOctantOperation<T> op;
        private Iterator<Entry<T>> sub;
        protected Entry<T> current;
        protected Entry<T> last;

        protected BaseIter(IIterationOctantOperation<T> op) {
            this.op = op;
        }

        protected Entry<T> find() {
            if (this.sub == null) {
                this.start(OctTree.this.root, this.op);
            }
            if (this.sub == null || !this.sub.hasNext()) {
                this.sub = this.op.next().iterator();
            }
            if (this.sub.hasNext()) {
                this.current = this.sub.next();
                return this.current;
            }
            this.current = null;
            return null;
        }

        protected abstract void start(Octant<T> var1, IIterationOctantOperation<T> var2);

        @Override
        public final boolean hasNext() {
            if (this.current == null) {
                this.find();
            }
            return this.current != null;
        }

        @Override
        public final Entry<T> next() {
            if (this.current == null && this.find() == null) {
                throw new NoSuchElementException();
            }
            Entry next = this.current;
            this.find();
            this.last = next;
            return this.last;
        }

        @Override
        public final void remove() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            OctTree.this.remq.add(this.last);
        }
    }

    public static final class Entry<T> {
        public final IntAxisAlignedBox key;
        public final T value;

        public Entry(IntAxisAlignedBox key, T value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.key.equals(entry.key)) {
                return false;
            }
            return this.value.equals(entry.value);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return MessageFormat.format("{0} -> {1}", this.key, this.value);
        }
    }
}

