/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ImmutableListMap<K, V>
implements Iterable<V> {
    private final List<V> list;
    private final Map<K, V> map;

    public ImmutableListMap(List<? extends V> delegate) {
        this.list = Collections.unmodifiableList(new ArrayList<V>(delegate));
        this.map = new LinkedHashMap(delegate.size());
        for (V value : delegate) {
            this.map.put(this.keyFor(value), value);
        }
    }

    protected abstract K keyFor(V var1);

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return this.list.iterator();
    }

    public V get(K key) {
        return this.map.get(key);
    }

    public boolean equals(Object o) {
        if (o instanceof List) {
            return this.list.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableListMap that = (ImmutableListMap)o;
        return this.list.equals(that.list);
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean has(K name) {
        return this.map.containsKey(name);
    }
}

