/*
 * Decompiled with CFR 0.152.
 */
package com.extollit.collect;

import com.extollit.collect.FlattenIterable;
import com.extollit.collect.IXFormer;
import com.extollit.collect.XFormIterable;
import com.extollit.collect.ZipIterable;
import com.extollit.functional.Func1;
import com.extollit.tuple.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionsExt {
    private static <E, C extends Collection<E>> C populate(C target, Iterable<E> source) {
        for (E item : source) {
            target.add(item);
        }
        return target;
    }

    private static <E, C extends Collection<E>> C populate(C target, Iterator<E> source) {
        while (source.hasNext()) {
            target.add(source.next());
        }
        return target;
    }

    public static <E> List<E> toList(Iterator<E> iter) {
        return CollectionsExt.populate(new ArrayList(), iter);
    }

    public static <E> List<E> toList(Iterable<E> iter) {
        return CollectionsExt.populate(new ArrayList(), iter);
    }

    public static <E> Set<E> toSet(Iterator<E> iter) {
        return CollectionsExt.populate(new HashSet(), iter);
    }

    public static <E> Set<E> toSet(Iterable<E> iter) {
        return CollectionsExt.populate(new HashSet(), iter);
    }

    public static <K, V> Iterable<Pair.Sealed<K, V>> pairIterable(Map<K, V> source) {
        return new XFormIterable<Pair.Sealed<K, V>, Map.Entry<K, V>>(source.entrySet()){

            @Override
            public Pair.Sealed<K, V> transform(Map.Entry<K, V> element) {
                return Pair.Sealed.of(element.getKey(), element.getValue());
            }
        };
    }

    private static <Out, In> List<Out> mapList(Iterator<In> iter, int initialCapacity, IXFormer<Out, In> xformer) {
        ArrayList<Out> result = new ArrayList<Out>(initialCapacity);
        while (iter.hasNext()) {
            result.add(xformer.transform(iter.next()));
        }
        return result;
    }

    public static <Out, In> List<Out> mapList(Iterable<In> iter, IXFormer<Out, In> xformer) {
        return CollectionsExt.mapList(iter.iterator(), 0, xformer);
    }

    public static <Out, In> List<Out> mapList(List<In> list, IXFormer<Out, In> xformer) {
        return CollectionsExt.mapList(list.iterator(), list.size(), xformer);
    }

    public static <L, R> Iterable<Pair.Sealed<L, R>> zip(Iterable<L> left, Iterable<R> right) {
        return new ZipIterable<L, R>(left, right);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends Iterable<T>> argument) {
        return new FlattenIterable(argument);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second) {
        return new FlattenIterable<T>(first, second);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second, Iterable<T> third) {
        return new FlattenIterable<T>(first, second, third);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second, Iterable<? extends T> third, Iterable<? extends T> fourth) {
        return new FlattenIterable<T>(first, second, third, fourth);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second, Iterable<? extends T> third, Iterable<? extends T> fourth, Iterable<? extends T> fifth) {
        return new FlattenIterable<T>(first, second, third, fourth, fifth);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second, Iterable<? extends T> third, Iterable<? extends T> fourth, Iterable<? extends T> fifth, Iterable<? extends T> sixth) {
        return new FlattenIterable<T>(first, second, third, fourth, fifth, sixth);
    }

    public static <T> Iterable<T> flatten(Iterable<? extends T> first, Iterable<? extends T> second, Iterable<? extends T> third, Iterable<? extends T> fourth, Iterable<? extends T> fifth, Iterable<? extends T> sixth, Iterable<? extends T> seventh) {
        return new FlattenIterable<T>(first, second, third, fourth, fifth, sixth, seventh);
    }

    public static <Key, Value> void load(Iterable<? extends Pair.Sealed<Key, ? extends Value>> source, Map<Key, Value> dest) {
        for (Pair.Sealed<Key, Value> sealed : source) {
            dest.put(sealed.left, sealed.right);
        }
    }

    public static <A, B> Map<A, List<B>> groupBy(Collection<B> collection, final Func1<A, B> selector) {
        Object[] array = collection.toArray(new Object[collection.size()]);
        Arrays.sort(array, new Comparator<B>(){

            @Override
            public int compare(B left, B right) {
                return selector.apply(left).hashCode() - selector.apply(right).hashCode();
            }
        });
        Hashtable map = new Hashtable();
        Object keyed0 = null;
        LinkedList<Object> current = null;
        for (Object x : array) {
            A keyed = selector.apply(x);
            if (keyed0 == null || !keyed.equals(keyed0)) {
                current = new LinkedList<Object>();
                map.put(keyed, current);
            }
            current.add(x);
            keyed0 = keyed;
        }
        return map;
    }

    public static <T> boolean anyNullIn(T[] array) {
        for (T entry : array) {
            if (entry != null) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean anyNonNullIn(T[] array) {
        for (T entry : array) {
            if (entry == null) continue;
            return true;
        }
        return false;
    }
}

