/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.LayoutCharacters;
import com.sun.tools.javac.util.Log;
import java.util.Arrays;

public class UnicodeReader {
    private final char[] buffer;
    private final int length;
    private int position;
    private int width;
    private char character;
    private int codepoint;
    private boolean wasBackslash;
    private char replacedCharacter;
    int seek;
    private final Log log;

    protected UnicodeReader(ScannerFactory sf, char[] array, int length) {
        this.buffer = array;
        this.length = length;
        this.position = 0;
        this.width = 0;
        this.character = '\u0000';
        this.codepoint = 0;
        this.wasBackslash = false;
        this.log = sf.log;
        this.nextCodePoint();
    }

    protected int length() {
        return this.length;
    }

    protected boolean isAvailable() {
        return this.position < this.length;
    }

    private void nextCodeUnit() {
        int index = this.position + this.width;
        if (this.length <= index) {
            this.character = (char)26;
        } else {
            this.character = this.buffer[index];
            ++this.width;
        }
    }

    private void nextUnicodeInputCharacter() {
        this.position += this.width;
        this.width = 0;
        this.nextCodeUnit();
        if (this.wasBackslash) {
            this.wasBackslash = false;
        } else if (this.character == '\\') {
            switch (this.unicodeEscape()) {
                case BACKSLASH: {
                    this.wasBackslash = true;
                    break;
                }
                case VALID_ESCAPE: {
                    this.wasBackslash = false;
                    break;
                }
                case BROKEN_ESCAPE: {
                    this.nextUnicodeInputCharacter();
                }
            }
        }
        this.codepoint = this.character;
    }

    private void nextCodePoint() {
        this.nextUnicodeInputCharacter();
        if (this.isASCII() || !Character.isHighSurrogate(this.character)) {
            return;
        }
        char hi = this.character;
        int savePosition = this.position;
        int saveWidth = this.width;
        this.nextUnicodeInputCharacter();
        char lo = this.character;
        if (Character.isLowSurrogate(lo)) {
            this.position = savePosition;
            this.width += saveWidth;
            this.codepoint = Character.toCodePoint(hi, lo);
        } else {
            this.position = savePosition;
            this.width = saveWidth;
            this.character = hi;
            this.codepoint = hi;
        }
    }

    private UnicodeEscapeResult unicodeEscape() {
        int digit;
        int index;
        int start = this.position + this.width;
        this.character = (char)92;
        this.width = 1;
        for (index = start; index < this.length && this.buffer[index] == 'u'; ++index) {
        }
        if (index == start) {
            return UnicodeEscapeResult.BACKSLASH;
        }
        int code = 0;
        for (int i = 0; i < 4 && (code = code << 4 | (digit = index < this.length ? Character.digit(this.buffer[index], 16) : -1)) >= 0; ++i) {
            ++index;
        }
        this.width = index - this.position;
        if (code >= 0) {
            this.character = (char)code;
            return UnicodeEscapeResult.VALID_ESCAPE;
        }
        this.log.error(index, CompilerProperties.Errors.IllegalUnicodeEsc);
        return UnicodeEscapeResult.BROKEN_ESCAPE;
    }

    protected int position() {
        return this.position;
    }

    protected void reset(int pos) {
        this.position = pos;
        this.width = 0;
        this.wasBackslash = false;
        this.nextCodePoint();
    }

    protected char get() {
        return this.character;
    }

    protected int getCodepoint() {
        return this.codepoint;
    }

    protected boolean isSurrogate() {
        return 65535 < this.codepoint;
    }

    protected boolean isASCII() {
        return this.character <= '\u007f';
    }

    protected char next() {
        this.nextCodePoint();
        return this.character;
    }

    protected boolean is(char ch) {
        return this.character == ch;
    }

    protected boolean isOneOf(char ch1, char ch2) {
        return this.is(ch1) || this.is(ch2);
    }

    protected boolean isOneOf(char ch1, char ch2, char ch3) {
        return this.is(ch1) || this.is(ch2) || this.is(ch3);
    }

    protected boolean isOneOf(char ch1, char ch2, char ch3, char ch4, char ch5, char ch6) {
        return this.is(ch1) || this.is(ch2) || this.is(ch3) || this.is(ch4) || this.is(ch5) || this.is(ch6);
    }

    protected boolean inRange(char lo, char hi) {
        return lo <= this.character && this.character <= hi;
    }

    protected boolean accept(char ch) {
        if (this.is(ch)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOf(char ch1, char ch2) {
        if (this.isOneOf(ch1, ch2)) {
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOf(char ch1, char ch2, char ch3) {
        if (this.isOneOf(ch1, ch2, ch3)) {
            this.next();
            return true;
        }
        return false;
    }

    protected void skip(char ch) {
        while (this.accept(ch)) {
        }
    }

    protected void skipWhitespace() {
        while (this.acceptOneOf(' ', '\t', '\f')) {
        }
    }

    protected void skipToEOLN() {
        while (this.isAvailable() && !this.isOneOf('\r', '\n')) {
            this.next();
        }
    }

    protected boolean accept(String string) {
        if (string.length() == 0 || !this.is(string.charAt(0))) {
            return false;
        }
        int savedPosition = this.position;
        this.nextCodePoint();
        for (int i = 1; i < string.length(); ++i) {
            if (!this.is(string.charAt(i))) {
                this.reset(savedPosition);
                return false;
            }
            this.nextCodePoint();
        }
        return true;
    }

    protected int digit(int pos, int digitRadix) {
        int result;
        if (this.inRange('0', '9')) {
            int result2 = this.character - 48;
            return result2 < digitRadix ? result2 : -1;
        }
        int n = result = this.isSurrogate() ? Character.digit(this.codepoint, digitRadix) : Character.digit(this.character, digitRadix);
        if (result >= 0 && !this.isASCII()) {
            this.log.error(this.position(), CompilerProperties.Errors.IllegalNonasciiDigit);
            this.character = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    public char[] getRawCharacters() {
        return this.length == this.buffer.length ? this.buffer : Arrays.copyOf(this.buffer, this.length);
    }

    public char[] getRawCharacters(int beginIndex, int endIndex) {
        return Arrays.copyOfRange(this.buffer, beginIndex, endIndex);
    }

    static class PositionTrackingReader
    extends UnicodeReader {
        private final int offset;
        private int column;

        protected PositionTrackingReader(ScannerFactory sf, char[] array, int offset) {
            super(sf, array, array.length);
            this.offset = offset;
            this.column = 0;
        }

        @Override
        protected char next() {
            super.next();
            this.column = this.isOneOf('\n', '\r', '\f') ? 0 : (this.is('\t') ? LayoutCharacters.tabulate(this.column) : ++this.column);
            return this.get();
        }

        protected int column() {
            return this.column;
        }

        protected int offsetPosition() {
            return this.position() + this.offset;
        }
    }

    private static enum UnicodeEscapeResult {
        BACKSLASH,
        VALID_ESCAPE,
        BROKEN_ESCAPE;

    }
}

