/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.DocTreeMaker;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class DocCommentParser {
    private final ParserFactory fac;
    private final EndPosTable ept;
    private final DiagnosticSource diagSource;
    private final Tokens.Comment comment;
    private final DocTreeMaker m;
    private final Names names;
    private final boolean isFileContent;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int textStart = -1;
    private int lastNonWhite = -1;
    private boolean newline = true;
    private final Map<Name, TagParser> tagParsers;
    private final boolean breakOnError;
    private ListBuffer<JCDiagnostic> errors = new ListBuffer();

    public DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment, boolean isFileContent) {
        this(fac, false, new JavacParser.EmptyEndPosTable(null), diagSource, comment, isFileContent);
    }

    public DocCommentParser(ParserFactory fac, boolean breakOnError, EndPosTable ept, DiagnosticSource diagSource, Tokens.Comment comment, boolean isFileContent) {
        this.fac = fac;
        this.ept = ept;
        this.breakOnError = breakOnError;
        this.diagSource = diagSource;
        this.comment = comment;
        this.names = fac.names;
        this.isFileContent = isFileContent;
        this.m = fac.docTreeMaker;
        this.tagParsers = this.createTagParsers();
    }

    public DocCommentParser(ParserFactory fac, DiagnosticSource diagSource, Tokens.Comment comment) {
        this(fac, diagSource, comment, false);
    }

    public DocCommentParser(ParserFactory fac) {
        this(fac, null, null, false);
    }

    public DCTree.DCDocComment parse() {
        this.errors.clear();
        String c = this.comment.getText();
        this.buf = new char[c.length() + 1];
        c.getChars(0, c.length(), this.buf, 0);
        this.buf[this.buf.length - 1] = 26;
        this.buflen = this.buf.length - 1;
        this.bp = -1;
        this.nextChar();
        List preamble = this.isFileContent ? this.blockContent(Phase.PREAMBLE) : List.nil();
        List<DCTree> body = this.blockContent(Phase.BODY);
        List<DCTree> tags = this.blockTags();
        List postamble = this.isFileContent ? this.blockContent(Phase.POSTAMBLE) : List.nil();
        int pos = -1;
        if (!preamble.isEmpty()) {
            pos = ((DCTree)preamble.head).pos;
        } else if (!body.isEmpty()) {
            pos = ((DCTree)body.head).pos;
        } else if (!tags.isEmpty()) {
            pos = ((DCTree)tags.head).pos;
        } else if (!postamble.isEmpty()) {
            pos = ((DCTree)postamble.head).pos;
        }
        DCTree.DCDocComment dc = this.m.at(pos).newDocCommentTree(this.comment, body, tags, preamble, postamble);
        dc.errors = this.errors.toList();
        return dc;
    }

    void nextChar() {
        this.ch = this.buf[this.bp < this.buflen ? (this.bp = this.bp + 1) : this.buflen];
        switch (this.ch) {
            case '\n': 
            case '\f': 
            case '\r': {
                this.newline = true;
            }
        }
    }

    char peekNextChar() {
        return this.buf[this.bp < this.buflen ? this.bp + 1 : this.buflen];
    }

    protected List<DCTree> blockContent() {
        return this.blockContent(Phase.BODY);
    }

    protected List<DCTree> blockContent(Phase phase) {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.textStart = -1;
        block12: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block12;
                }
                case '&': {
                    this.entity(trees);
                    continue block12;
                }
                case '<': {
                    this.newline = false;
                    if (this.isFileContent) {
                        switch (phase) {
                            case PREAMBLE: {
                                if (!this.isEndPreamble()) break;
                                trees.add(this.html());
                                if (this.textStart == -1) {
                                    this.textStart = this.bp;
                                    this.lastNonWhite = -1;
                                }
                                this.newline = true;
                                break block12;
                            }
                            case BODY: {
                                if (!this.isEndBody()) break;
                                this.addPendingText(trees, this.lastNonWhite);
                                break block12;
                            }
                        }
                    }
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    if (phase == Phase.PREAMBLE || phase == Phase.POSTAMBLE || this.textStart != -1) continue block12;
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block12;
                }
                case '{': {
                    this.inlineTag(trees);
                    continue block12;
                }
                case '@': {
                    if (this.newline) {
                        this.addPendingText(trees, this.lastNonWhite);
                        break block12;
                    }
                }
                default: {
                    this.newline = false;
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.lastNonWhite = this.bp;
                    this.nextChar();
                    continue block12;
                }
            }
        }
        if (this.lastNonWhite != -1) {
            this.addPendingText(trees, this.lastNonWhite);
        }
        return trees.toList();
    }

    protected List<DCTree> blockTags() {
        ListBuffer<DCTree> tags = new ListBuffer<DCTree>();
        while (this.bp < this.buflen && this.ch == '@') {
            tags.add(this.blockTag());
        }
        return tags.toList();
    }

    protected DCTree blockTag() {
        int p = this.bp;
        try {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readTagName();
                TagParser tp = this.tagParsers.get(name);
                if (tp == null) {
                    List<DCTree> content = this.blockContent();
                    return this.m.at(p).newUnknownBlockTagTree((javax.lang.model.element.Name)name, content);
                }
                if (tp.allowsBlock()) {
                    return tp.parse(p, TagParser.Kind.BLOCK);
                }
                this.handleError("dc.bad.inline.tag", p);
                return tp.parse(p);
            }
            DCTree.DCErroneous err = this.erroneous("dc.no.tag.name", p);
            if (this.breakOnError) {
                return err;
            }
            List<DCTree> content = this.blockContent();
            return this.m.at(p).newUnknownBlockTagTree((javax.lang.model.element.Name)this.names.empty, content);
        }
        catch (ParseException e) {
            if (!this.breakOnError) {
                throw new IllegalStateException(e);
            }
            this.blockContent();
            return this.erroneous(e.getMessage(), p);
        }
    }

    protected void inlineTag(ListBuffer<DCTree> list) {
        this.newline = false;
        this.nextChar();
        if (this.ch == '@') {
            this.addPendingText(list, this.bp - 2);
            list.add(this.inlineTag());
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        } else {
            if (this.textStart == -1) {
                this.textStart = this.bp - 1;
            }
            this.lastNonWhite = this.bp;
        }
    }

    protected DCTree inlineTag() {
        int p = this.bp - 1;
        try {
            this.nextChar();
            if (!this.isIdentifierStart(this.ch)) {
                return this.erroneous("dc.no.tag.name", p);
            }
            Name name = this.readTagName();
            TagParser tp = this.tagParsers.get(name);
            if (tp == null) {
                this.skipWhitespace();
                DCTree.DCText text = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                this.nextChar();
                return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(text)))).setEndPos(this.bp);
            }
            if (!tp.retainWhiteSpace) {
                this.skipWhitespace();
            }
            if (tp.allowsInline()) {
                DCTree.DCEndPosTree tree = (DCTree.DCEndPosTree)tp.parse(p, TagParser.Kind.INLINE);
                return tree.setEndPos(this.bp);
            }
            DCTree.DCText text = this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
            this.nextChar();
            return ((DCTree.DCEndPosTree)((Object)this.m.at(p).newUnknownInlineTagTree((javax.lang.model.element.Name)name, List.of(text)))).setEndPos(this.bp);
        }
        catch (ParseException e) {
            if (!this.breakOnError) {
                throw new IllegalStateException(e);
            }
            return this.erroneous(e.getMessage(), p);
        }
    }

    private DCTree.DCText inlineText(WhitespaceRetentionPolicy whitespacePolicy) throws ParseException {
        switch (whitespacePolicy) {
            case REMOVE_ALL: {
                this.skipWhitespace();
                break;
            }
            case REMOVE_FIRST_SPACE: {
                if (this.ch != ' ') break;
                this.nextChar();
                break;
            }
        }
        int pos = this.bp;
        int depth = 1;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '{': {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    ++depth;
                    break;
                }
                case '}': {
                    if (--depth == 0) {
                        DCTree.DCText result = this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                        this.nextChar();
                        return result;
                    }
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                    break;
                }
                default: {
                    this.newline = false;
                    this.lastNonWhite = this.bp;
                }
            }
            this.nextChar();
        }
        this.handleError("dc.unterminated.inline.tag", pos);
        return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
    }

    protected void handleError(String errorKey, int pos) throws ParseException {
        if (this.breakOnError) {
            throw new ParseException(errorKey);
        }
        DCTree.DCErroneous err = this.erroneous(errorKey, pos);
        this.errors.add(err.diag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DCTree.DCReference reference(boolean allowMember) throws ParseException {
        List<JCTree> paramTypes;
        Name member;
        JCTree.JCExpression qualExpr;
        int pos = this.bp;
        int depth = 0;
        block12: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    if (depth != 0) break;
                    break block12;
                }
                case '(': 
                case '<': {
                    this.newline = false;
                    ++depth;
                    break;
                }
                case ')': 
                case '>': {
                    this.newline = false;
                    --depth;
                    break;
                }
                case '}': {
                    if (this.bp == pos) {
                        return null;
                    }
                    this.newline = false;
                    break block12;
                }
                case '@': {
                    if (this.newline) break block12;
                }
                case '{': {
                    break block12;
                }
                default: {
                    this.newline = false;
                }
            }
            this.nextChar();
        }
        if (depth > 0) {
            this.handleError("dc.unterminated.signature", pos);
        }
        String sig = this.newString(pos, this.bp);
        Log.DeferredDiagnosticHandler deferredDiagnosticHandler = new Log.DeferredDiagnosticHandler(this.fac.log);
        try {
            int hash = sig.indexOf("#");
            int lparen = sig.indexOf("(", hash + 1);
            if (hash == -1) {
                if (lparen == -1) {
                    qualExpr = this.parseType(sig, this.comment.getSourcePos(pos));
                    member = null;
                } else {
                    qualExpr = null;
                    member = this.parseMember(sig.substring(0, lparen));
                }
            } else {
                qualExpr = hash == 0 ? null : this.parseType(sig.substring(0, hash), this.comment.getSourcePos(pos));
                member = lparen == -1 ? this.parseMember(sig.substring(hash + 1)) : this.parseMember(sig.substring(hash + 1, lparen));
            }
            if (lparen < 0) {
                paramTypes = null;
            } else {
                int rparen = sig.indexOf(")", lparen);
                if (rparen != sig.length() - 1) {
                    this.handleError("dc.ref.bad.parens", pos);
                    if (rparen == -1) {
                        rparen = sig.length();
                    }
                }
                paramTypes = this.parseParams(sig.substring(lparen + 1, rparen), this.comment.getSourcePos(pos + lparen + 1));
            }
            if (!deferredDiagnosticHandler.getDiagnostics().isEmpty()) {
                this.handleError("dc.ref.syntax.error", pos);
            }
        }
        finally {
            this.fac.log.popDiagnosticHandler(deferredDiagnosticHandler);
        }
        return (DCTree.DCReference)this.m.at(pos).newReferenceTree(sig, qualExpr, member, paramTypes).setEndPos(this.bp);
    }

    JCTree.JCExpression parseType(String s, int startPos) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, true, false);
        JCTree.JCExpression tree = p.parseType();
        this.moveTree(startPos, tree, p, this.ept);
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", p.token().pos);
        }
        return tree;
    }

    private <T extends JCTree> T moveTree(final int offset, T toMove, final JavacParser parser, final EndPosTable targetEndPos) {
        new TreeScanner(){

            @Override
            public void scan(JCTree tree) {
                if (tree != null) {
                    int endPos = parser.getEndPos(tree) + offset;
                    tree.pos += offset;
                    ((JavacParser.AbstractEndPosTable)targetEndPos).storeEnd(tree, endPos);
                }
                super.scan(tree);
            }
        }.scan(toMove);
        return toMove;
    }

    Name parseMember(String s) throws ParseException {
        JavacParser p = this.fac.newParser(s, false, false, false);
        Name name = p.ident();
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", this.bp);
            return this.names.error;
        }
        return name;
    }

    List<JCTree> parseParams(String s, int startPos) throws ParseException {
        if (s.trim().isEmpty()) {
            return List.nil();
        }
        JavacParser p = this.fac.newParser(s.replace("...", "[ ]"), false, true, false);
        ListBuffer<JCTree.JCExpression> paramTypes = new ListBuffer<JCTree.JCExpression>();
        paramTypes.add(this.moveTree(startPos, p.parseType(), p, this.ept));
        if (p.token().kind == Tokens.TokenKind.IDENTIFIER) {
            p.nextToken();
        }
        while (p.token().kind == Tokens.TokenKind.COMMA) {
            p.nextToken();
            paramTypes.add(this.moveTree(startPos, p.parseType(), p, this.ept));
            if (p.token().kind != Tokens.TokenKind.IDENTIFIER) continue;
            p.nextToken();
        }
        if (p.token().kind != Tokens.TokenKind.EOF) {
            this.handleError("dc.ref.unexpected.input", this.bp);
        }
        return paramTypes.toList();
    }

    protected DCTree.DCIdentifier identifier() throws ParseException {
        this.skipWhitespace();
        int pos = this.bp;
        if (this.isJavaIdentifierStart(this.ch)) {
            Name name = this.readJavaIdentifier();
            return this.m.at(pos).newIdentifierTree(name);
        }
        this.handleError("dc.identifier.expected", pos);
        return this.m.at(pos).newIdentifierTree(this.names.error);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText quotedString() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    break;
                }
                case '\t': 
                case ' ': {
                    break;
                }
                case '\"': {
                    this.nextChar();
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (!this.newline) break;
                    return null;
                }
            }
            this.nextChar();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected DCTree.DCText inlineWord() {
        int pos = this.bp;
        int depth = 0;
        while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': {
                    this.newline = true;
                }
                case '\t': 
                case '\f': 
                case '\r': 
                case ' ': {
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
                case '@': {
                    if (this.newline) {
                        return null;
                    }
                }
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    if (depth == 0) return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                    if (--depth != 0) break;
                    return this.m.at(pos).newTextTree(this.newString(pos, this.bp));
                }
            }
            this.newline = false;
            this.nextChar();
        }
        return null;
    }

    private List<DCTree> inlineContent() {
        ListBuffer<DCTree> trees = new ListBuffer<DCTree>();
        this.skipWhitespace();
        int pos = this.bp;
        int depth = 1;
        this.textStart = -1;
        block9: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                }
                case '\t': 
                case ' ': {
                    this.nextChar();
                    continue block9;
                }
                case '&': {
                    this.entity(trees);
                    continue block9;
                }
                case '<': {
                    this.newline = false;
                    this.addPendingText(trees, this.bp - 1);
                    trees.add(this.html());
                    this.textStart = this.bp;
                    this.lastNonWhite = -1;
                    continue block9;
                }
                case '{': {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.newline = false;
                    if (this.peekNextChar() == '@') {
                        this.addPendingText(trees, this.bp - 1);
                        pos = this.bp;
                        break block9;
                    }
                    this.nextChar();
                    if (this.ch == '@') {
                        this.addPendingText(trees, this.bp - 2);
                        trees.add(this.inlineTag());
                        this.textStart = this.bp;
                        this.lastNonWhite = -1;
                        continue block9;
                    }
                    ++depth;
                    continue block9;
                }
                case '}': {
                    this.newline = false;
                    if (--depth == 0) {
                        this.addPendingText(trees, this.bp - 1);
                        this.nextChar();
                        return trees.toList();
                    }
                    this.nextChar();
                    continue block9;
                }
                case '@': {
                    if (this.newline) break block9;
                }
                default: {
                    if (this.textStart == -1) {
                        this.textStart = this.bp;
                    }
                    this.nextChar();
                    continue block9;
                }
            }
        }
        DCTree.DCErroneous err = this.erroneous("dc.unterminated.inline.tag", pos);
        if (!this.breakOnError) {
            return trees.toList();
        }
        return List.of(err);
    }

    protected void entity(ListBuffer<DCTree> list) {
        this.newline = false;
        this.addPendingText(list, this.bp - 1);
        list.add(this.entity());
        if (this.textStart == -1) {
            this.textStart = this.bp;
            this.lastNonWhite = -1;
        }
    }

    protected DCTree entity() {
        int p = this.bp;
        this.nextChar();
        Name name = null;
        if (this.ch == '#') {
            int namep = this.bp;
            this.nextChar();
            if (this.isDecimalDigit(this.ch)) {
                this.nextChar();
                while (this.bp < this.buflen && this.isDecimalDigit(this.ch)) {
                    this.nextChar();
                }
                name = this.names.fromChars(this.buf, namep, this.bp - namep);
            } else if (this.ch == 'x' || this.ch == 'X') {
                this.nextChar();
                if (this.isHexDigit(this.ch)) {
                    this.nextChar();
                    while (this.bp < this.buflen && this.isHexDigit(this.ch)) {
                        this.nextChar();
                    }
                    name = this.names.fromChars(this.buf, namep, this.bp - namep);
                }
            }
        } else if (this.isIdentifierStart(this.ch)) {
            name = this.readIdentifier();
        }
        if (name == null) {
            DCTree.DCErroneous err = this.erroneous("dc.bad.entity", p);
            if (this.breakOnError) {
                return err;
            }
            name = this.names.empty;
        } else if (this.ch != ';') {
            DCTree.DCErroneous err = this.erroneous("dc.missing.semicolon", p);
            if (this.breakOnError) {
                return err;
            }
        } else {
            this.nextChar();
        }
        return this.m.at(p).newEntityTree(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndPreamble() {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                String name;
                switch (name = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                    case "body": {
                        while (this.bp < this.buflen && this.ch != '>') {
                            this.nextChar();
                        }
                        if (this.ch == '>') {
                            this.nextChar();
                        }
                        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
                            this.nextChar();
                        }
                        if (this.ch == '<') {
                            this.nextChar();
                            if (this.isIdentifierStart(this.ch) && (name = StringUtils.toLowerCase(this.readIdentifier().toString())).equals("main")) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        boolean bl = true;
                        return bl;
                    }
                    case "main": {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEndBody() {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                this.nextChar();
                if (this.isIdentifierStart(this.ch)) {
                    String name;
                    switch (name = StringUtils.toLowerCase(this.readIdentifier().toString())) {
                        case "body": 
                        case "main": {
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean peek(String s) {
        int savedpos = this.bp;
        try {
            if (this.ch == '<') {
                this.nextChar();
            }
            if (this.ch == '/') {
                if (s.charAt(0) != this.ch) {
                    boolean bl = false;
                    return bl;
                }
                s = s.substring(1);
                this.nextChar();
            }
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                boolean bl = StringUtils.toLowerCase(name.toString()).equals(s);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.bp = savedpos;
            this.ch = this.buf[this.bp];
        }
    }

    private DCTree html() {
        int p = this.bp;
        this.nextChar();
        if (this.isIdentifierStart(this.ch)) {
            Name name = this.readIdentifier();
            List<DCTree> attrs = this.htmlAttrs();
            if (attrs != null) {
                boolean selfClosing = false;
                if (this.ch == '/') {
                    this.nextChar();
                    selfClosing = true;
                }
                if (this.ch == '>') {
                    this.nextChar();
                    Object dctree = ((DCTree.DCEndPosTree)((Object)this.m.at(p).newStartElementTree((javax.lang.model.element.Name)name, attrs, selfClosing))).setEndPos(this.bp);
                    return dctree;
                }
            }
        } else if (this.ch == '/') {
            this.nextChar();
            if (this.isIdentifierStart(this.ch)) {
                Name name = this.readIdentifier();
                this.skipWhitespace();
                if (this.ch == '>') {
                    this.nextChar();
                    return this.m.at(p).newEndElementTree(name).setEndPos(this.bp);
                }
            }
        } else if (this.ch == '!') {
            this.nextChar();
            if (this.ch == '-') {
                this.nextChar();
                if (this.ch == '-') {
                    this.nextChar();
                    while (this.bp < this.buflen) {
                        int dash = 0;
                        while (this.bp < this.buflen && this.ch == '-') {
                            ++dash;
                            this.nextChar();
                        }
                        if (dash >= 2 && this.ch == '>') {
                            this.nextChar();
                            return this.m.at(p).newCommentTree(this.newString(p, this.bp));
                        }
                        this.nextChar();
                    }
                }
            } else if (this.isIdentifierStart(this.ch) && this.peek("doctype")) {
                this.readIdentifier();
                this.nextChar();
                this.skipWhitespace();
                int d = this.bp;
                while (this.bp < this.buflen) {
                    if (this.ch == '>') {
                        int mark = this.bp;
                        this.nextChar();
                        return this.m.at(d).newDocTypeTree(this.newString(d, mark));
                    }
                    this.nextChar();
                }
            }
        }
        this.bp = p + 1;
        this.ch = this.buf[this.bp];
        return this.erroneous("dc.malformed.html", p);
    }

    protected List<DCTree> htmlAttrs() {
        ListBuffer<DocTree> attrs = new ListBuffer<DocTree>();
        this.skipWhitespace();
        block0: while (this.bp < this.buflen && this.isIdentifierStart(this.ch)) {
            int namePos = this.bp;
            Name name = this.readAttributeName();
            this.skipWhitespace();
            List<DCTree> value = null;
            AttributeTree.ValueKind vkind = AttributeTree.ValueKind.EMPTY;
            if (this.ch == '=') {
                ListBuffer<DCTree> v = new ListBuffer<DCTree>();
                this.nextChar();
                this.skipWhitespace();
                if (this.ch == '\'' || this.ch == '\"') {
                    this.newline = false;
                    vkind = this.ch == '\'' ? AttributeTree.ValueKind.SINGLE : AttributeTree.ValueKind.DOUBLE;
                    char quote = this.ch;
                    this.nextChar();
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && this.ch != quote) {
                        if (this.newline && this.ch == '@') {
                            DCTree.DCErroneous err = this.erroneous("dc.unterminated.string", namePos);
                            if (this.breakOnError) {
                                attrs.add(err);
                                break block0;
                            }
                            this.attrValueChar(v);
                            attrs.add(this.m.at(namePos).newAttributeTree((javax.lang.model.element.Name)name, vkind, v.toList()));
                            break block0;
                        }
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                    this.nextChar();
                } else {
                    vkind = AttributeTree.ValueKind.UNQUOTED;
                    this.textStart = this.bp;
                    while (this.bp < this.buflen && !this.isUnquotedAttrValueTerminator(this.ch)) {
                        this.attrValueChar(v);
                    }
                    this.addPendingText(v, this.bp - 1);
                }
                this.skipWhitespace();
                value = v.toList();
            }
            AttributeTree attr = this.m.at(namePos).newAttributeTree((javax.lang.model.element.Name)name, vkind, value);
            attrs.add(attr);
        }
        return attrs.toList();
    }

    protected void attrValueChar(ListBuffer<DCTree> list) {
        switch (this.ch) {
            case '&': {
                this.entity(list);
                break;
            }
            case '{': {
                this.inlineTag(list);
                break;
            }
            default: {
                this.nextChar();
            }
        }
    }

    protected void addPendingText(ListBuffer<DCTree> list, int textEnd) {
        if (this.textStart != -1) {
            if (this.textStart <= textEnd) {
                list.add(this.m.at(this.textStart).newTextTree(this.newString(this.textStart, textEnd + 1)));
            }
            this.textStart = -1;
        }
    }

    protected DCTree.DCErroneous erroneous(String code, int pos) {
        int i;
        block4: for (i = this.bp - 1; i > pos; --i) {
            switch (this.buf[i]) {
                case '\n': 
                case '\f': 
                case '\r': {
                    this.newline = true;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
            }
        }
        this.textStart = -1;
        DCTree.DCErroneous result = this.m.at(pos).newErroneousTree(this.newString(pos, i + 1), this.diagSource, code, new Object[0]);
        if (!this.breakOnError) {
            this.errors.add(result.diag);
        }
        return result;
    }

    protected boolean isIdentifierStart(char ch) {
        return Character.isUnicodeIdentifierStart(ch);
    }

    protected Name readIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readAttributeName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '-')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readTagName() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && (Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.' || this.ch == '-' || this.ch == ':')) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected boolean isJavaIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected Name readJavaIdentifier() {
        int start = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isJavaIdentifierPart(this.ch)) {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, start, this.bp - start);
    }

    protected Name readSystemPropertyName() {
        int pos = this.bp;
        this.nextChar();
        while (this.bp < this.buflen && Character.isUnicodeIdentifierPart(this.ch) || this.ch == '.') {
            this.nextChar();
        }
        return this.names.fromChars(this.buf, pos, this.bp - pos);
    }

    protected boolean isDecimalDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    protected boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    protected boolean isUnquotedAttrValueTerminator(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\"': 
            case '\'': 
            case '<': 
            case '=': 
            case '>': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    protected boolean isWhitespace(char ch) {
        return Character.isWhitespace(ch);
    }

    protected void skipWhitespace() {
        while (this.bp < this.buflen && this.isWhitespace(this.ch)) {
            this.nextChar();
        }
    }

    String newString(int start, int end) {
        return new String(this.buf, start, end - start);
    }

    private Map<Name, TagParser> createTagParsers() {
        TagParser[] parsers = new TagParser[]{new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.AUTHOR){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> name = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newAuthorTree(name);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.CODE, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newCodeTree(text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.DEPRECATED){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newDeprecatedTree(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.DOC_ROOT){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}' || !DocCommentParser.this.breakOnError) {
                    if (DocCommentParser.this.ch == '}') {
                        DocCommentParser.this.nextChar();
                    } else {
                        DocCommentParser.this.erroneous("dc.unexpected.content", DocCommentParser.this.bp);
                    }
                    return DocCommentParser.this.m.at(pos).newDocRootTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.EXCEPTION){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newExceptionTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.HIDDEN){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> reason = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newHiddenTree(reason);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INDEX){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText term;
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                DCTree.DCText dCText = term = DocCommentParser.this.ch == '\"' ? DocCommentParser.this.quotedString() : DocCommentParser.this.inlineWord();
                if (term == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                List description = List.nil();
                if (DocCommentParser.this.ch != '}') {
                    description = DocCommentParser.this.inlineContent();
                } else {
                    DocCommentParser.this.nextChar();
                }
                return DocCommentParser.this.m.at(pos).newIndexTree((DocTree)term, (java.util.List)description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.INHERIT_DOC){

            @Override
            public DCTree parse(int pos) throws ParseException {
                if (DocCommentParser.this.ch == '}' || !DocCommentParser.this.breakOnError) {
                    if (DocCommentParser.this.ch == '}') {
                        DocCommentParser.this.nextChar();
                    } else {
                        DocCommentParser.this.erroneous("dc.unexpected.content", DocCommentParser.this.bp);
                    }
                    return DocCommentParser.this.m.at(pos).newInheritDocTree();
                }
                DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_ALL);
                throw new ParseException("dc.unexpected.content");
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkTree((ReferenceTree)ref, (java.util.List)label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LINK_PLAIN){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List label = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newLinkPlainTree((ReferenceTree)ref, (java.util.List)label);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.LITERAL, true){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCText text = DocCommentParser.this.inlineText(WhitespaceRetentionPolicy.REMOVE_FIRST_SPACE);
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newLiteralTree(text);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PARAM){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                boolean typaram = false;
                if (DocCommentParser.this.ch == '<') {
                    typaram = true;
                    DocCommentParser.this.nextChar();
                }
                DCTree.DCIdentifier id = DocCommentParser.this.identifier();
                if (typaram) {
                    if (DocCommentParser.this.ch != '>') {
                        DocCommentParser.this.handleError("dc.gt.expected", DocCommentParser.this.bp);
                    }
                    DocCommentParser.this.nextChar();
                }
                DocCommentParser.this.skipWhitespace();
                List<DCTree> desc = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newParamTree(typaram, (IdentifierTree)id, desc);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.PROVIDES){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newProvidesTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.EITHER, DocTree.Kind.RETURN){

            @Override
            public DCTree parse(int pos, TagParser.Kind kind) {
                List description;
                switch (kind) {
                    case BLOCK: {
                        description = DocCommentParser.this.blockContent();
                        break;
                    }
                    case INLINE: {
                        description = DocCommentParser.this.inlineContent();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(kind.toString());
                    }
                }
                return DocCommentParser.this.m.at(pos).newReturnTree(kind == TagParser.Kind.INLINE, (java.util.List)description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SEE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                String errorKey = "dc.unexpected.content";
                switch (DocCommentParser.this.ch) {
                    case '\"': {
                        DCTree.DCText string = DocCommentParser.this.quotedString();
                        if (string == null) break;
                        DocCommentParser.this.skipWhitespace();
                        if (DocCommentParser.this.ch != '@' && (DocCommentParser.this.ch != '\u001a' || DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1)) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(List.of(string));
                    }
                    case '<': {
                        List<DCTree> html = DocCommentParser.this.blockContent();
                        if (html == null) break;
                        return DocCommentParser.this.m.at(pos).newSeeTree(html);
                    }
                    case '@': {
                        if (!DocCommentParser.this.newline) break;
                        DocCommentParser.this.handleError("dc.no.content", DocCommentParser.this.bp);
                        break;
                    }
                    case '\u001a': {
                        if (DocCommentParser.this.bp != DocCommentParser.this.buf.length - 1) break;
                        errorKey = "dc.no.content";
                        break;
                    }
                    default: {
                        if (!DocCommentParser.this.isJavaIdentifierStart(DocCommentParser.this.ch) && DocCommentParser.this.ch != '#') break;
                        DCTree.DCReference ref = DocCommentParser.this.reference(true);
                        List<DCTree> description = DocCommentParser.this.blockContent();
                        return DocCommentParser.this.m.at(pos).newSeeTree(description.prepend(ref));
                    }
                }
                DocCommentParser.this.handleError(errorKey, DocCommentParser.this.bp);
                return DocCommentParser.this.m.at(pos).newSeeTree((java.util.List)List.nil());
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_DATA){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialDataTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL_FIELD){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCIdentifier name = DocCommentParser.this.identifier();
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference type = DocCommentParser.this.reference(false);
                List<DCTree> description = null;
                if (DocCommentParser.this.isWhitespace(DocCommentParser.this.ch)) {
                    DocCommentParser.this.skipWhitespace();
                    description = DocCommentParser.this.blockContent();
                }
                return DocCommentParser.this.m.at(pos).newSerialFieldTree((IdentifierTree)name, (ReferenceTree)type, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SERIAL){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSerialTree(description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.SINCE){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newSinceTree(description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SUMMARY){

            @Override
            public DCTree parse(int pos) throws ParseException {
                List summary = DocCommentParser.this.inlineContent();
                return DocCommentParser.this.m.at(pos).newSummaryTree((java.util.List)summary);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.SYSTEM_PROPERTY){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    throw new ParseException("dc.no.content");
                }
                Name propertyName = DocCommentParser.this.readSystemPropertyName();
                if (propertyName == null) {
                    throw new ParseException("dc.no.content");
                }
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch != '}') {
                    DocCommentParser.this.nextChar();
                    throw new ParseException("dc.unexpected.content");
                }
                DocCommentParser.this.nextChar();
                return DocCommentParser.this.m.at(pos).newSystemPropertyTree(propertyName);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.THROWS){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(false);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newThrowsTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.USES){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DocCommentParser.this.skipWhitespace();
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newUsesTree((ReferenceTree)ref, description);
            }
        }, new TagParser(TagParser.Kind.INLINE, DocTree.Kind.VALUE){

            @Override
            public DCTree parse(int pos) throws ParseException {
                DCTree.DCReference ref = DocCommentParser.this.reference(true);
                DocCommentParser.this.skipWhitespace();
                if (DocCommentParser.this.ch == '}') {
                    DocCommentParser.this.nextChar();
                } else {
                    DocCommentParser.this.handleError("dc.unexpected.content", pos);
                }
                return DocCommentParser.this.m.at(pos).newValueTree(ref);
            }
        }, new TagParser(TagParser.Kind.BLOCK, DocTree.Kind.VERSION){

            @Override
            public DCTree parse(int pos) {
                List<DCTree> description = DocCommentParser.this.blockContent();
                return DocCommentParser.this.m.at(pos).newVersionTree(description);
            }
        }};
        HashMap<Name, TagParser> tagParsers = new HashMap<Name, TagParser>();
        for (TagParser p : parsers) {
            tagParsers.put(this.names.fromString(p.getTreeKind().tagName), p);
        }
        return tagParsers;
    }

    private static abstract class TagParser {
        final Kind kind;
        final DocTree.Kind treeKind;
        final boolean retainWhiteSpace;

        TagParser(Kind k, DocTree.Kind tk) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = false;
        }

        TagParser(Kind k, DocTree.Kind tk, boolean retainWhiteSpace) {
            this.kind = k;
            this.treeKind = tk;
            this.retainWhiteSpace = retainWhiteSpace;
        }

        boolean allowsBlock() {
            return this.kind != Kind.INLINE;
        }

        boolean allowsInline() {
            return this.kind != Kind.BLOCK;
        }

        DocTree.Kind getTreeKind() {
            return this.treeKind;
        }

        DCTree parse(int pos, Kind kind) throws ParseException {
            if (kind != this.kind && this.kind != Kind.EITHER) {
                throw new IllegalArgumentException(kind.toString());
            }
            return this.parse(pos);
        }

        DCTree parse(int pos) throws ParseException {
            throw new UnsupportedOperationException();
        }

        static enum Kind {
            INLINE,
            BLOCK,
            EITHER;

        }
    }

    private static enum WhitespaceRetentionPolicy {
        RETAIN_ALL,
        REMOVE_FIRST_SPACE,
        REMOVE_ALL;

    }

    private static enum Phase {
        PREAMBLE,
        BODY,
        POSTAMBLE;

    }

    static class ParseException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ParseException(String key) {
            super(key);
        }
    }
}

