/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.SourceVersion;

public enum Source {
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK5("5"),
    JDK6("6"),
    JDK7("7"),
    JDK8("8"),
    JDK9("9"),
    JDK10("10"),
    JDK11("11"),
    JDK12("12"),
    JDK13("13"),
    JDK14("14"),
    JDK15("15"),
    JDK16("16"),
    JDK17("17");

    private static final Context.Key<Source> sourceKey;
    public final String name;
    private static final Map<String, Source> tab;
    public static final Source MIN;
    private static final Source MAX;
    public static final Source DEFAULT;

    public static Source instance(Context context) {
        Source instance = context.get(sourceKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String sourceString = options.get(Option.SOURCE);
            if (sourceString != null) {
                instance = Source.lookup(sourceString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(sourceKey, instance);
        }
        return instance;
    }

    private Source(String name) {
        this.name = name;
    }

    public static Source lookup(String name) {
        return tab.get(name);
    }

    public boolean isSupported() {
        return this.compareTo(MIN) >= 0;
    }

    public Target requiredTarget() {
        if (this.compareTo(JDK17) >= 0) {
            return Target.JDK1_17;
        }
        if (this.compareTo(JDK16) >= 0) {
            return Target.JDK1_16;
        }
        if (this.compareTo(JDK15) >= 0) {
            return Target.JDK1_15;
        }
        if (this.compareTo(JDK14) >= 0) {
            return Target.JDK1_14;
        }
        if (this.compareTo(JDK13) >= 0) {
            return Target.JDK1_13;
        }
        if (this.compareTo(JDK12) >= 0) {
            return Target.JDK1_12;
        }
        if (this.compareTo(JDK11) >= 0) {
            return Target.JDK1_11;
        }
        if (this.compareTo(JDK10) >= 0) {
            return Target.JDK1_10;
        }
        if (this.compareTo(JDK9) >= 0) {
            return Target.JDK1_9;
        }
        if (this.compareTo(JDK8) >= 0) {
            return Target.JDK1_8;
        }
        if (this.compareTo(JDK7) >= 0) {
            return Target.JDK1_7;
        }
        if (this.compareTo(JDK6) >= 0) {
            return Target.JDK1_6;
        }
        if (this.compareTo(JDK5) >= 0) {
            return Target.JDK1_5;
        }
        if (this.compareTo(JDK1_4) >= 0) {
            return Target.JDK1_4;
        }
        return Target.JDK1_1;
    }

    public static SourceVersion toSourceVersion(Source source) {
        switch (source) {
            case JDK1_2: {
                return SourceVersion.RELEASE_2;
            }
            case JDK1_3: {
                return SourceVersion.RELEASE_3;
            }
            case JDK1_4: {
                return SourceVersion.RELEASE_4;
            }
            case JDK5: {
                return SourceVersion.RELEASE_5;
            }
            case JDK6: {
                return SourceVersion.RELEASE_6;
            }
            case JDK7: {
                return SourceVersion.RELEASE_7;
            }
            case JDK8: {
                return SourceVersion.RELEASE_8;
            }
            case JDK9: {
                return SourceVersion.RELEASE_9;
            }
            case JDK10: {
                return SourceVersion.RELEASE_10;
            }
            case JDK11: {
                return SourceVersion.RELEASE_11;
            }
            case JDK12: {
                return SourceVersion.RELEASE_12;
            }
            case JDK13: {
                return SourceVersion.RELEASE_13;
            }
            case JDK14: {
                return SourceVersion.RELEASE_14;
            }
            case JDK15: {
                return SourceVersion.RELEASE_15;
            }
            case JDK16: {
                return SourceVersion.RELEASE_16;
            }
            case JDK17: {
                return SourceVersion.RELEASE_17;
            }
        }
        return null;
    }

    static {
        sourceKey = new Context.Key();
        tab = new HashMap<String, Source>();
        for (Source s : Source.values()) {
            tab.put(s.name, s);
        }
        tab.put("1.5", JDK5);
        tab.put("1.6", JDK6);
        tab.put("1.7", JDK7);
        tab.put("1.8", JDK8);
        tab.put("1.9", JDK9);
        tab.put("1.10", JDK10);
        MIN = JDK7;
        DEFAULT = MAX = Source.values()[Source.values().length - 1];
    }

    public static enum Feature {
        DIAMOND(JDK7, CompilerProperties.Fragments.FeatureDiamond, DiagKind.NORMAL),
        MODULES(JDK9, CompilerProperties.Fragments.FeatureModules, DiagKind.PLURAL),
        EFFECTIVELY_FINAL_VARIABLES_IN_TRY_WITH_RESOURCES(JDK9, CompilerProperties.Fragments.FeatureVarInTryWithResources, DiagKind.PLURAL),
        DEPRECATION_ON_IMPORT(MIN, JDK8),
        POLY(JDK8),
        LAMBDA(JDK8, CompilerProperties.Fragments.FeatureLambda, DiagKind.PLURAL),
        METHOD_REFERENCES(JDK8, CompilerProperties.Fragments.FeatureMethodReferences, DiagKind.PLURAL),
        DEFAULT_METHODS(JDK8, CompilerProperties.Fragments.FeatureDefaultMethods, DiagKind.PLURAL),
        STATIC_INTERFACE_METHODS(JDK8, CompilerProperties.Fragments.FeatureStaticIntfMethods, DiagKind.PLURAL),
        STATIC_INTERFACE_METHODS_INVOKE(JDK8, CompilerProperties.Fragments.FeatureStaticIntfMethodInvoke, DiagKind.PLURAL),
        STRICT_METHOD_CLASH_CHECK(JDK8),
        EFFECTIVELY_FINAL_IN_INNER_CLASSES(JDK8),
        TYPE_ANNOTATIONS(JDK8, CompilerProperties.Fragments.FeatureTypeAnnotations, DiagKind.PLURAL),
        ANNOTATIONS_AFTER_TYPE_PARAMS(JDK8, CompilerProperties.Fragments.FeatureAnnotationsAfterTypeParams, DiagKind.PLURAL),
        REPEATED_ANNOTATIONS(JDK8, CompilerProperties.Fragments.FeatureRepeatableAnnotations, DiagKind.PLURAL),
        INTERSECTION_TYPES_IN_CAST(JDK8, CompilerProperties.Fragments.FeatureIntersectionTypesInCast, DiagKind.PLURAL),
        GRAPH_INFERENCE(JDK8),
        FUNCTIONAL_INTERFACE_MOST_SPECIFIC(JDK8),
        POST_APPLICABILITY_VARARGS_ACCESS_CHECK(JDK8),
        MAP_CAPTURES_TO_BOUNDS(MIN, JDK7),
        PRIVATE_SAFE_VARARGS(JDK9),
        DIAMOND_WITH_ANONYMOUS_CLASS_CREATION(JDK9, CompilerProperties.Fragments.FeatureDiamondAndAnonClass, DiagKind.NORMAL),
        UNDERSCORE_IDENTIFIER(MIN, JDK8),
        PRIVATE_INTERFACE_METHODS(JDK9, CompilerProperties.Fragments.FeaturePrivateIntfMethods, DiagKind.PLURAL),
        LOCAL_VARIABLE_TYPE_INFERENCE(JDK10),
        VAR_SYNTAX_IMPLICIT_LAMBDAS(JDK11, CompilerProperties.Fragments.FeatureVarSyntaxInImplicitLambda, DiagKind.PLURAL),
        IMPORT_ON_DEMAND_OBSERVABLE_PACKAGES(JDK1_2, JDK8),
        SWITCH_MULTIPLE_CASE_LABELS(JDK14, CompilerProperties.Fragments.FeatureMultipleCaseLabels, DiagKind.PLURAL),
        SWITCH_RULE(JDK14, CompilerProperties.Fragments.FeatureSwitchRules, DiagKind.PLURAL),
        SWITCH_EXPRESSION(JDK14, CompilerProperties.Fragments.FeatureSwitchExpressions, DiagKind.PLURAL),
        TEXT_BLOCKS(JDK15, CompilerProperties.Fragments.FeatureTextBlocks, DiagKind.PLURAL),
        PATTERN_MATCHING_IN_INSTANCEOF(JDK16, CompilerProperties.Fragments.FeaturePatternMatchingInstanceof, DiagKind.NORMAL),
        REIFIABLE_TYPES_INSTANCEOF(JDK16, CompilerProperties.Fragments.FeatureReifiableTypesInstanceof, DiagKind.PLURAL),
        RECORDS(JDK16, CompilerProperties.Fragments.FeatureRecords, DiagKind.PLURAL),
        SEALED_CLASSES(JDK17, CompilerProperties.Fragments.FeatureSealedClasses, DiagKind.PLURAL),
        CASE_NULL(JDK17, CompilerProperties.Fragments.FeatureCaseNull, DiagKind.NORMAL),
        PATTERN_SWITCH(JDK17, CompilerProperties.Fragments.FeaturePatternSwitch, DiagKind.PLURAL),
        REDUNDANT_STRICTFP(JDK17);

        private final Source minLevel;
        private final Source maxLevel;
        private final JCDiagnostic.Fragment optFragment;
        private final DiagKind optKind;

        private Feature(Source minLevel) {
            this(minLevel, null, null);
        }

        private Feature(Source minLevel, JCDiagnostic.Fragment optFragment, DiagKind optKind) {
            this(minLevel, MAX, optFragment, optKind);
        }

        private Feature(Source minLevel, Source maxLevel) {
            this(minLevel, maxLevel, null, null);
        }

        private Feature(Source minLevel, Source maxLevel, JCDiagnostic.Fragment optFragment, DiagKind optKind) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
            this.optFragment = optFragment;
            this.optKind = optKind;
        }

        public boolean allowedInSource(Source source) {
            return source.compareTo(this.minLevel) >= 0 && source.compareTo(this.maxLevel) <= 0;
        }

        public boolean isPlural() {
            Assert.checkNonNull(this.optKind);
            return this.optKind == DiagKind.PLURAL;
        }

        public JCDiagnostic.Fragment nameFragment() {
            Assert.checkNonNull(this.optFragment);
            return this.optFragment;
        }

        public JCDiagnostic.Fragment fragment(String sourceName) {
            Assert.checkNonNull(this.optFragment);
            return this.optKind == DiagKind.NORMAL ? CompilerProperties.Fragments.FeatureNotSupportedInSource(this.optFragment, sourceName, this.minLevel.name) : CompilerProperties.Fragments.FeatureNotSupportedInSourcePlural(this.optFragment, sourceName, this.minLevel.name);
        }

        public JCDiagnostic.Error error(String sourceName) {
            Assert.checkNonNull(this.optFragment);
            return this.optKind == DiagKind.NORMAL ? CompilerProperties.Errors.FeatureNotSupportedInSource(this.optFragment, sourceName, this.minLevel.name) : CompilerProperties.Errors.FeatureNotSupportedInSourcePlural(this.optFragment, sourceName, this.minLevel.name);
        }

        static enum DiagKind {
            NORMAL,
            PLURAL;

        }
    }
}

