/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.classfile;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassReader;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import java.io.IOException;

public class Module_attribute
extends Attribute {
    public static final int ACC_TRANSITIVE = 32;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int ACC_OPEN = 32;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_MANDATED = 32768;
    public final int module_name;
    public final int module_flags;
    public final int module_version_index;
    public final int requires_count;
    public final RequiresEntry[] requires;
    public final int exports_count;
    public final ExportsEntry[] exports;
    public final int opens_count;
    public final OpensEntry[] opens;
    public final int uses_count;
    public final int[] uses_index;
    public final int provides_count;
    public final ProvidesEntry[] provides;

    Module_attribute(ClassReader cr, int name_index, int length) throws IOException {
        super(name_index, length);
        int i;
        this.module_name = cr.readUnsignedShort();
        this.module_flags = cr.readUnsignedShort();
        this.module_version_index = cr.readUnsignedShort();
        this.requires_count = cr.readUnsignedShort();
        this.requires = new RequiresEntry[this.requires_count];
        for (i = 0; i < this.requires_count; ++i) {
            this.requires[i] = new RequiresEntry(cr);
        }
        this.exports_count = cr.readUnsignedShort();
        this.exports = new ExportsEntry[this.exports_count];
        for (i = 0; i < this.exports_count; ++i) {
            this.exports[i] = new ExportsEntry(cr);
        }
        this.opens_count = cr.readUnsignedShort();
        this.opens = new OpensEntry[this.opens_count];
        for (i = 0; i < this.opens_count; ++i) {
            this.opens[i] = new OpensEntry(cr);
        }
        this.uses_count = cr.readUnsignedShort();
        this.uses_index = new int[this.uses_count];
        for (i = 0; i < this.uses_count; ++i) {
            this.uses_index[i] = cr.readUnsignedShort();
        }
        this.provides_count = cr.readUnsignedShort();
        this.provides = new ProvidesEntry[this.provides_count];
        for (i = 0; i < this.provides_count; ++i) {
            this.provides[i] = new ProvidesEntry(cr);
        }
    }

    public Module_attribute(int name_index, int module_name, int module_flags, int module_version_index, RequiresEntry[] requires, ExportsEntry[] exports, OpensEntry[] opens, int[] uses, ProvidesEntry[] provides) {
        super(name_index, 2);
        this.module_name = module_name;
        this.module_flags = module_flags;
        this.module_version_index = module_version_index;
        this.requires_count = requires.length;
        this.requires = requires;
        this.exports_count = exports.length;
        this.exports = exports;
        this.opens_count = opens.length;
        this.opens = opens;
        this.uses_count = uses.length;
        this.uses_index = uses;
        this.provides_count = provides.length;
        this.provides = provides;
    }

    public String getUses(int index, ConstantPool constant_pool) throws ConstantPoolException {
        int i = this.uses_index[index];
        return constant_pool.getClassInfo(i).getName();
    }

    @Override
    public <R, D> R accept(Attribute.Visitor<R, D> visitor, D data) {
        return visitor.visitModule(this, data);
    }

    public static class ProvidesEntry {
        public static final int length = 4;
        public final int provides_index;
        public final int with_count;
        public final int[] with_index;

        ProvidesEntry(ClassReader cr) throws IOException {
            this.provides_index = cr.readUnsignedShort();
            this.with_count = cr.readUnsignedShort();
            this.with_index = new int[this.with_count];
            for (int i = 0; i < this.with_count; ++i) {
                this.with_index[i] = cr.readUnsignedShort();
            }
        }

        public ProvidesEntry(int provides, int[] with) {
            this.provides_index = provides;
            this.with_count = with.length;
            this.with_index = with;
        }
    }

    public static class OpensEntry {
        public final int opens_index;
        public final int opens_flags;
        public final int opens_to_count;
        public final int[] opens_to_index;

        OpensEntry(ClassReader cr) throws IOException {
            this.opens_index = cr.readUnsignedShort();
            this.opens_flags = cr.readUnsignedShort();
            this.opens_to_count = cr.readUnsignedShort();
            this.opens_to_index = new int[this.opens_to_count];
            for (int i = 0; i < this.opens_to_count; ++i) {
                this.opens_to_index[i] = cr.readUnsignedShort();
            }
        }

        public OpensEntry(int index, int flags, int[] to) {
            this.opens_index = index;
            this.opens_flags = flags;
            this.opens_to_count = to.length;
            this.opens_to_index = to;
        }

        public int length() {
            return 4 + 2 * this.opens_to_index.length;
        }
    }

    public static class ExportsEntry {
        public final int exports_index;
        public final int exports_flags;
        public final int exports_to_count;
        public final int[] exports_to_index;

        ExportsEntry(ClassReader cr) throws IOException {
            this.exports_index = cr.readUnsignedShort();
            this.exports_flags = cr.readUnsignedShort();
            this.exports_to_count = cr.readUnsignedShort();
            this.exports_to_index = new int[this.exports_to_count];
            for (int i = 0; i < this.exports_to_count; ++i) {
                this.exports_to_index[i] = cr.readUnsignedShort();
            }
        }

        public ExportsEntry(int index, int flags, int[] to) {
            this.exports_index = index;
            this.exports_flags = flags;
            this.exports_to_count = to.length;
            this.exports_to_index = to;
        }

        public int length() {
            return 4 + 2 * this.exports_to_index.length;
        }
    }

    public static class RequiresEntry {
        public static final int length = 4;
        public final int requires_index;
        public final int requires_flags;
        public final int requires_version_index;

        RequiresEntry(ClassReader cr) throws IOException {
            this.requires_index = cr.readUnsignedShort();
            this.requires_flags = cr.readUnsignedShort();
            this.requires_version_index = cr.readUnsignedShort();
        }

        public RequiresEntry(int index, int flags, int version_index) {
            this.requires_index = index;
            this.requires_flags = flags;
            this.requires_version_index = version_index;
        }

        public String getRequires(ConstantPool constant_pool) throws ConstantPoolException {
            ConstantPool.CONSTANT_Module_info info = constant_pool.getModuleInfo(this.requires_index);
            return info.getName();
        }
    }
}

