/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.compiler.client.CompileParameter;
import com.dslplatform.compiler.client.Context;
import com.dslplatform.compiler.client.Either;
import com.dslplatform.compiler.client.Main;
import com.dslplatform.compiler.client.Utils;
import com.dslplatform.compiler.client.parameters.DisablePrompt;
import com.dslplatform.compiler.client.parameters.Download;
import com.dslplatform.compiler.client.parameters.DslCompiler;
import com.dslplatform.compiler.client.parameters.DslPath;
import com.dslplatform.compiler.client.parameters.Namespace;
import com.dslplatform.compiler.client.parameters.Settings;
import com.dslplatform.compiler.client.parameters.Targets;
import com.dslplatform.compiler.client.parameters.TempPath;
import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.processor.LogLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

abstract class AnnotationCompiler {
    AnnotationCompiler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String buildExternalJson(String dsl, CompileOptions options, LogLevel logLevel, Messager messager) throws IOException {
        File temp = File.createTempFile("annotation-", ".dsl");
        try {
            File compiler;
            FileOutputStream fos = new FileOutputStream(temp);
            fos.write(dsl.getBytes());
            fos.close();
            DslContext ctx = new DslContext(messager, logLevel);
            Targets.Option target = options.useAndroid ? Targets.Option.ANDORID_EXTERNAL_JSON : Targets.Option.JAVA_EXTERNAL_JSON;
            ctx.put("library:" + Targets.Option.JAVA_EXTERNAL_JSON.toString(), "1.9.0");
            ctx.put(target.toString(), null);
            ctx.put((CompileParameter)DslPath.INSTANCE, temp.getAbsolutePath());
            ctx.put((CompileParameter)DisablePrompt.INSTANCE, null);
            ctx.put(Settings.Option.SOURCE_ONLY.toString(), null);
            ctx.put(Settings.Option.MANUAL_JSON.toString(), null);
            if (options.useJodaTime) {
                ctx.put(Settings.Option.JODA_TIME.toString(), null);
            }
            ctx.put((CompileParameter)Namespace.INSTANCE, options.namespace);
            if (options.compiler != null && options.compiler.length() > 0) {
                compiler = new File(options.compiler);
                if (!compiler.exists()) {
                    throw new ConfigurationException("DSL compiler specified with dsljson.compiler option not found. Check used option: " + options.compiler);
                }
                if (compiler.isDirectory()) {
                    throw new ConfigurationException("DSL compiler specified with dsljson.compiler option is an folder. Please specify file instead: " + options.compiler);
                }
            } else {
                compiler = new File("dsl-compiler.exe");
                if (!compiler.exists()) {
                    ctx.put((CompileParameter)Download.INSTANCE, null);
                }
            }
            ctx.put((CompileParameter)DslCompiler.INSTANCE, options.compiler);
            List parameters = Main.initializeParameters((Context)ctx, (String)".");
            if (!Main.processContext((Context)ctx, (List)parameters)) {
                if (logLevel != LogLevel.DEBUG) {
                    throw new ConfigurationException("Unable to setup DSL-JSON processing environment. Specify dsljson.loglevel=DEBUG for more information.");
                }
                throw new ConfigurationException("Unable to setup DSL-JSON processing environment. Inspect javac output log for more information.");
            }
            File projectPath = TempPath.getTempProjectPath((Context)ctx);
            File rootPackage = new File(new File(projectPath, target.name()), options.namespace);
            File jsonFolder = new File(rootPackage, "json");
            Either content = Utils.readFile((File)new File(jsonFolder, "ExternalSerialization.java"));
            if (!content.isSuccess()) {
                throw new ConfigurationException((Throwable)content.whyNot());
            }
            String string = (String)content.get();
            return string;
        }
        finally {
            if (!temp.delete() && logLevel != LogLevel.NONE) {
                messager.printMessage(Diagnostic.Kind.WARNING, "Unable to delete temporary file: " + temp.getAbsolutePath());
            }
        }
    }

    private static class DslContext
    extends Context {
        private Messager messager;
        private LogLevel logLevel;

        DslContext(Messager messager, LogLevel logLevel) {
            this.messager = messager;
            this.logLevel = logLevel;
        }

        public void show(String ... values) {
            if (LogLevel.INFO.isVisible(this.logLevel)) {
                for (String v : values) {
                    this.messager.printMessage(Diagnostic.Kind.OTHER, v);
                }
            }
        }

        public void log(String value) {
            if (LogLevel.DEBUG.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.OTHER, value);
            }
        }

        public void log(char[] value, int len) {
            if (LogLevel.DEBUG.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.OTHER, new String(value, 0, len));
            }
        }

        public void warning(String value) {
            if (LogLevel.INFO.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, value);
            }
        }

        public void warning(Exception ex) {
            if (LogLevel.INFO.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, ex.getMessage());
            }
        }

        public void error(String value) {
            if (LogLevel.ERRORS.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, value);
            }
        }

        public void error(Exception ex) {
            if (LogLevel.ERRORS.isVisible(this.logLevel)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            }
        }
    }

    static class CompileOptions {
        boolean useJodaTime;
        boolean useAndroid;
        String namespace;
        String compiler;

        CompileOptions() {
        }
    }
}

