/*
 * Decompiled with CFR 0.152.
 */
package dsl_json.java.util;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JavaTimeConverter;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;

public class DateDslJsonConverter
implements Configuration {
    public void configure(DslJson json) {
        json.registerReader(Date.class, (JsonReader.ReadObject)new JsonReader.ReadObject<Date>(){

            @Nullable
            public Date read(JsonReader reader) throws IOException {
                return reader.wasNull() ? null : Date.from(JavaTimeConverter.deserializeDateTime(reader).toInstant());
            }
        });
        json.registerWriter(Date.class, (JsonWriter.WriteObject)new JsonWriter.WriteObject<Date>(){

            public void write(JsonWriter writer, @Nullable Date value) {
                if (value == null) {
                    writer.writeNull();
                } else {
                    JavaTimeConverter.serialize(OffsetDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()), writer);
                }
            }
        });
    }
}

