/*
 * Decompiled with CFR 0.152.
 */
package dsl_json.java.sql;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JavaTimeConverter;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public class TimestampDslJsonConverter
implements Configuration {
    public void configure(DslJson json) {
        json.registerReader(Timestamp.class, (JsonReader.ReadObject)new JsonReader.ReadObject<Timestamp>(){

            @Nullable
            public Timestamp read(JsonReader reader) throws IOException {
                return reader.wasNull() ? null : Timestamp.from(JavaTimeConverter.deserializeDateTime(reader).toInstant());
            }
        });
        json.registerWriter(Timestamp.class, (JsonWriter.WriteObject)new JsonWriter.WriteObject<Timestamp>(){

            public void write(JsonWriter writer, @Nullable Timestamp value) {
                if (value == null) {
                    writer.writeNull();
                } else {
                    JavaTimeConverter.serialize(OffsetDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()), writer);
                }
            }
        });
    }
}

