/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.Settings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

abstract class Reflection {
    Reflection() {
    }

    static final class SetMethod
    implements Settings.BiConsumer {
        private final Method method;

        SetMethod(Method method) {
            this.method = method;
        }

        public void accept(Object instance, @Nullable Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigurationException("Unable to call method " + this.method.getName() + " of " + this.method.getDeclaringClass(), (Throwable)e);
            }
        }
    }

    static final class SetField
    implements Settings.BiConsumer {
        private final Field field;

        SetField(Field field) {
            this.field = field;
        }

        public void accept(Object instance, @Nullable Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Unable to set field " + this.field.getName() + " of " + this.field.getDeclaringClass(), (Throwable)e);
            }
        }
    }

    static final class ReadMethod
    implements Settings.Function {
        private final Method method;

        ReadMethod(Method method) {
            this.method = method;
        }

        public Object apply(@Nullable Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigurationException("Unable to call method " + this.method.getName() + " of " + this.method.getDeclaringClass(), (Throwable)e);
            }
        }
    }

    static final class ReadField
    implements Settings.Function {
        private final Field field;

        ReadField(Field field) {
            this.field = field;
        }

        public Object apply(@Nullable Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Unable to read field " + this.field.getName() + " of " + this.field.getDeclaringClass(), (Throwable)e);
            }
        }
    }
}

