/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import java.util.Optional;

public final class OptionalEncoder<T>
implements JsonWriter.WriteObject<Optional<T>> {
    private final DslJson json;
    private final JsonWriter.WriteObject<T> encoder;

    public OptionalEncoder(DslJson json, @Nullable JsonWriter.WriteObject<T> encoder) {
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        this.json = json;
        this.encoder = encoder;
    }

    public void write(JsonWriter writer, @Nullable Optional<T> value) {
        if (value == null || !value.isPresent()) {
            writer.writeNull();
        } else if (this.encoder != null) {
            this.encoder.write(writer, value.get());
        } else {
            T unpacked = value.get();
            JsonWriter.WriteObject jw = this.json.tryFindWriter(unpacked.getClass());
            if (jw == null) {
                throw new ConfigurationException("Unable to find writer for " + unpacked.getClass());
            }
            jw.write(writer, unpacked);
        }
    }
}

