/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.Generics;
import com.dslplatform.json.runtime.InstanceFactory;
import com.dslplatform.json.runtime.ObjectFormatDescription;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class ObjectAnalyzer {
    public static final DslJson.ConverterFactory<ObjectFormatDescription> CONVERTER = new DslJson.ConverterFactory<ObjectFormatDescription>(){

        @Nullable
        public ObjectFormatDescription tryCreate(Type manifest, DslJson dslJson) {
            if (manifest instanceof Class) {
                return ObjectAnalyzer.analyze(manifest, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)manifest;
                return ObjectAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static <T> ObjectFormatDescription<T, T> analyze(Type manifest, final Class<T> raw, DslJson json) {
        if (raw.isArray() || Object.class == manifest || Collection.class.isAssignableFrom(raw) || raw.isInterface() || (raw.getModifiers() & 0x400) != 0 || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0) {
            return null;
        }
        Set currentEncoders = json.getRegisteredEncoders();
        Set currentDecoders = json.getRegisteredDecoders();
        Set currentBinders = json.getRegisteredBinders();
        boolean hasEncoder = currentEncoders.contains(manifest);
        boolean hasDecoder = currentDecoders.contains(manifest);
        boolean hasBinder = currentBinders.contains(manifest);
        try {
            raw.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ignore) {
            return null;
        }
        InstanceFactory newInstance = new InstanceFactory(){

            public Object create() {
                try {
                    return raw.newInstance();
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Unable to create an instance of " + raw);
                }
            }
        };
        LazyObjectDescription lazy = new LazyObjectDescription(json, manifest);
        if (!hasEncoder) {
            json.registerWriter(manifest, (JsonWriter.WriteObject)lazy);
        }
        if (!hasDecoder) {
            json.registerReader(manifest, (JsonReader.ReadObject)lazy);
        }
        LinkedHashMap<String, JsonWriter.WriteObject> foundWrite = new LinkedHashMap<String, JsonWriter.WriteObject>();
        LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead = new LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>>();
        HashMap<Type, Type> genericMappings = Generics.analyze(manifest, raw);
        int index = 0;
        for (Field field : raw.getFields()) {
            if (!ObjectAnalyzer.analyzeField(json, foundWrite, foundRead, field, index, genericMappings)) continue;
            ++index;
        }
        for (AccessibleObject accessibleObject : raw.getMethods()) {
            if (!ObjectAnalyzer.analyzeMethods((Method)accessibleObject, raw, json, foundWrite, foundRead, index, genericMappings)) continue;
            ++index;
        }
        JsonWriter.WriteObject[] writeProps = foundWrite.values().toArray(new JsonWriter.WriteObject[0]);
        DecodePropertyInfo[] readProps = foundRead.values().toArray(new DecodePropertyInfo[0]);
        ObjectFormatDescription<T, T> converter = ObjectFormatDescription.create(raw, newInstance, writeProps, readProps, json, true);
        if (!hasEncoder) {
            json.registerWriter(manifest, converter);
        }
        if (!hasDecoder) {
            json.registerReader(manifest, converter);
        }
        if (!hasBinder) {
            json.registerBinder(manifest, converter);
        }
        lazy.resolved = converter;
        return converter;
    }

    private static boolean analyzeField(DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead, Field field, int index, HashMap<Type, Type> genericMappings) {
        if (!ObjectAnalyzer.canRead(field.getModifiers()) || !ObjectAnalyzer.canWrite(field.getModifiers())) {
            return false;
        }
        Type type = field.getGenericType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(field.getName(), Settings.createEncoder(new Reflection.ReadField(field), field.getName(), json, isUnknown ? null : concreteType));
            foundRead.put(field.getName(), Settings.createDecoder(new Reflection.SetField(field), field.getName(), json, false, false, index, false, concreteType));
            return true;
        }
        return false;
    }

    private static boolean analyzeMethods(Method mget, Class<?> manifest, DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, LinkedHashMap<String, DecodePropertyInfo<JsonReader.BindObject>> foundRead, int index, HashMap<Type, Type> genericMappings) {
        Method mset;
        if (mget.getParameterTypes().length != 0) {
            return false;
        }
        String setName = mget.getName().startsWith("get") ? "set" + mget.getName().substring(3) : mget.getName();
        try {
            mset = manifest.getMethod(setName, mget.getReturnType());
        }
        catch (NoSuchMethodException ignore) {
            return false;
        }
        String name = Analysis.beanOrActualName((String)mget.getName());
        if (!ObjectAnalyzer.canRead(mget.getModifiers()) || !ObjectAnalyzer.canWrite(mset.getModifiers())) {
            return false;
        }
        if (foundRead.containsKey(name) && foundWrite.containsKey(name)) {
            return false;
        }
        Type type = mget.getGenericReturnType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(name, Settings.createEncoder(new Reflection.ReadMethod(mget), name, json, isUnknown ? null : concreteType));
            foundRead.put(name, Settings.createDecoder(new Reflection.SetMethod(mset), name, json, false, false, index, false, concreteType));
            return true;
        }
        return false;
    }

    private static boolean canRead(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 8) == 0;
    }

    private static boolean canWrite(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 0x10) == 0 && (modifiers & 8) == 0;
    }

    private static class LazyObjectDescription
    implements JsonWriter.WriteObject,
    JsonReader.ReadObject,
    JsonReader.BindObject {
        private final DslJson json;
        private final Type type;
        private JsonWriter.WriteObject resolvedWriter;
        private JsonReader.BindObject resolvedBinder;
        private JsonReader.ReadObject resolvedReader;
        volatile ObjectFormatDescription resolved;

        LazyObjectDescription(DslJson json, Type type) {
            this.json = json;
            this.type = type;
        }

        private boolean checkSignatureNotFound() {
            ObjectFormatDescription local = null;
            for (int i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                local = this.resolved;
                if (local == null) continue;
                this.resolvedWriter = local;
                this.resolvedReader = local;
                this.resolvedBinder = local;
                break;
            }
            return local == null;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.resolvedReader == null && this.checkSignatureNotFound()) {
                JsonReader.ReadObject tmp = this.json.tryFindReader(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find reader for " + this.type);
                }
                this.resolvedReader = tmp;
            }
            return this.resolvedReader.read(reader);
        }

        public Object bind(JsonReader reader, Object instance) throws IOException {
            if (this.resolvedBinder == null && this.checkSignatureNotFound()) {
                JsonReader.BindObject tmp = this.json.tryFindBinder(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find binder for " + this.type);
                }
                this.resolvedBinder = tmp;
            }
            return this.resolvedBinder.bind(reader, instance);
        }

        public void write(JsonWriter writer, @Nullable Object value) {
            if (this.resolvedWriter == null && this.checkSignatureNotFound()) {
                JsonWriter.WriteObject tmp = this.json.tryFindWriter(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find writer for " + this.type);
                }
                this.resolvedWriter = tmp;
            }
            this.resolvedWriter.write(writer, value);
        }
    }

    public static class Runtime {
        public static final JsonReader.ReadObject<Object> JSON_READER = new JsonReader.ReadObject<Object>(){

            public Object read(JsonReader r) throws IOException {
                if (r.wasNull()) {
                    return null;
                }
                return ObjectConverter.deserializeObject((JsonReader)r);
            }
        };
        public static final JsonWriter.WriteObject<Object> JSON_WRITER = new JsonWriter.WriteObject<Object>(){

            public void write(JsonWriter writer, @Nullable Object value) {
                if (value != null) {
                    writer.serializeObject(value);
                } else {
                    writer.writeNull();
                }
            }
        };
    }
}

