/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.FormatDescription;
import java.lang.reflect.Type;

public final class MixinWriter<T>
implements JsonWriter.WriteObject<T> {
    private final Type manifest;
    private final FormatDescription<T>[] descriptions;

    public MixinWriter(Class<T> manifest, DslJson json, FormatDescription<T>[] descriptions) {
        this((Type)manifest, json, descriptions);
    }

    MixinWriter(Type manifest, DslJson json, FormatDescription<T>[] descriptions) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (descriptions == null || descriptions.length == 0) {
            throw new IllegalArgumentException("descriptions can't be null or empty");
        }
        this.manifest = manifest;
        this.descriptions = descriptions;
    }

    public void write(JsonWriter writer, @Nullable T instance) {
        if (instance == null) {
            writer.writeNull();
            return;
        }
        Class<?> current = instance.getClass();
        for (FormatDescription<T> od : this.descriptions) {
            if (current != od.manifest) continue;
            if (od.isObjectFormatFirst) {
                od.objectFormat.write(writer, instance);
            } else {
                od.arrayFormat.write(writer, instance);
            }
            return;
        }
        throw new ConfigurationException("Unable to find encoder for '" + instance.getClass() + "' while encoding " + this.manifest.getTypeName() + ". Add @CompiledJson to specified type to allow serialization from it");
    }
}

