/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.FormatConverter;
import com.dslplatform.json.runtime.Generics;
import com.dslplatform.json.runtime.InstanceFactory;
import com.dslplatform.json.runtime.ObjectFormatDescription;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;

public abstract class MixinAnalyzer {
    public static final DslJson.ConverterFactory<ObjectFormatDescription> WRITER = new DslJson.ConverterFactory<ObjectFormatDescription>(){

        @Nullable
        public ObjectFormatDescription tryCreate(Type manifest, DslJson dslJson) {
            if (manifest instanceof Class) {
                return MixinAnalyzer.analyze(manifest, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)manifest;
                return MixinAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static <T> ObjectFormatDescription<T, T> analyze(Type manifest, Class<T> raw, DslJson json) {
        if (raw.isArray() || Object.class == manifest || !raw.isInterface() && (raw.getModifiers() & 0x400) == 0 || Collection.class.isAssignableFrom(raw) || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0) {
            return null;
        }
        Set currentEncoders = json.getRegisteredEncoders();
        Set currentDecoders = json.getRegisteredDecoders();
        boolean hasEncoder = currentEncoders.contains(manifest);
        if (!currentDecoders.contains(manifest)) {
            return null;
        }
        JsonReader.ReadObject currentReader = json.tryFindReader(manifest);
        if (!(currentReader instanceof FormatConverter)) {
            return null;
        }
        InstanceFactory newInstance = new InstanceFactory(){

            public Object create() {
                throw new IllegalArgumentException("Internal DSL-JSON error. Should not be used for deserialization");
            }
        };
        LazyMixinDescription lazy = new LazyMixinDescription(json, manifest);
        if (!hasEncoder) {
            json.registerWriter(manifest, (JsonWriter.WriteObject)lazy);
        }
        LinkedHashMap<String, JsonWriter.WriteObject> foundWrite = new LinkedHashMap<String, JsonWriter.WriteObject>();
        HashMap<Type, Type> genericMappings = Generics.analyze(manifest, raw);
        for (Field field : raw.getDeclaredFields()) {
            MixinAnalyzer.analyzeField(json, foundWrite, field, genericMappings);
        }
        for (AccessibleObject accessibleObject : raw.getDeclaredMethods()) {
            MixinAnalyzer.analyzeMethods((Method)accessibleObject, json, foundWrite, genericMappings);
        }
        JsonWriter.WriteObject[] writeProps = foundWrite.values().toArray(new JsonWriter.WriteObject[0]);
        ObjectFormatDescription<T, T> converter = ObjectFormatDescription.create(raw, newInstance, writeProps, new DecodePropertyInfo[0], json, true);
        if (!hasEncoder) {
            json.registerWriter(manifest, converter);
        }
        lazy.resolved = converter;
        return converter;
    }

    private static void analyzeField(DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, Field field, HashMap<Type, Type> genericMappings) {
        if (!MixinAnalyzer.canRead(field.getModifiers())) {
            return;
        }
        Type type = field.getGenericType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(field.getName(), Settings.createEncoder(new Reflection.ReadField(field), field.getName(), json, isUnknown ? null : concreteType));
        }
    }

    private static void analyzeMethods(Method mget, DslJson json, LinkedHashMap<String, JsonWriter.WriteObject> foundWrite, HashMap<Type, Type> genericMappings) {
        if (mget.getParameterTypes().length != 0) {
            return;
        }
        if (!MixinAnalyzer.canRead(mget.getModifiers())) {
            return;
        }
        String name = Analysis.beanOrActualName((String)mget.getName());
        if (foundWrite.containsKey(name)) {
            return;
        }
        Type type = mget.getGenericReturnType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null) {
            foundWrite.put(name, Settings.createEncoder(new Reflection.ReadMethod(mget), name, json, isUnknown ? null : concreteType));
        }
    }

    private static boolean canRead(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 8) == 0;
    }

    private static class LazyMixinDescription
    implements JsonWriter.WriteObject {
        private final DslJson json;
        private final Type type;
        private JsonWriter.WriteObject resolvedWriter;
        volatile ObjectFormatDescription resolved;

        LazyMixinDescription(DslJson json, Type type) {
            this.json = json;
            this.type = type;
        }

        private boolean checkSignatureNotFound() {
            for (int i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                if (this.resolved == null) continue;
                this.resolvedWriter = this.resolved;
                break;
            }
            return this.resolved == null;
        }

        public void write(JsonWriter writer, @Nullable Object value) {
            if (this.resolvedWriter == null && this.checkSignatureNotFound()) {
                JsonWriter.WriteObject tmp = this.json.tryFindWriter(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find writer for " + this.type);
                }
                this.resolvedWriter = tmp;
            }
            this.resolvedWriter.write(writer, value);
        }
    }
}

