/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.Settings;
import java.lang.reflect.Type;

class LazyAttributeArrayEncoder<T, R>
implements JsonWriter.WriteObject<T> {
    private final Settings.Function<T, R> read;
    private JsonWriter.WriteObject<R> encoder;
    private final DslJson json;
    private final Type type;

    LazyAttributeArrayEncoder(Settings.Function<T, R> read, DslJson json, @Nullable Type type) {
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        this.read = read;
        this.json = json;
        this.type = type;
    }

    public void write(JsonWriter writer, @Nullable T value) {
        R attr;
        if (this.type != null && this.encoder == null) {
            this.encoder = this.json.tryFindWriter(this.type);
            if (this.encoder == null) {
                throw new ConfigurationException("Unable to find writer for " + this.type);
            }
        }
        if ((attr = this.read.apply(value)) == null) {
            writer.writeNull();
        } else if (this.type == null) {
            JsonWriter.WriteObject tmp = this.json.tryFindWriter(attr.getClass());
            if (tmp == null) {
                throw new ConfigurationException("Unable to find writer for " + attr.getClass());
            }
            tmp.write(writer, attr);
        } else {
            this.encoder.write(writer, attr);
        }
    }
}

