/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.runtime.CompositeParameterNameExtractor;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.Generics;
import com.dslplatform.json.runtime.ImmutableDescription;
import com.dslplatform.json.runtime.Java8ParameterNameExtractor;
import com.dslplatform.json.runtime.ParameterNameExtractor;
import com.dslplatform.json.runtime.ParanamerParameterNameExtractor;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ImmutableAnalyzer {
    private static final Set<String> objectMethods = new HashSet<String>();
    private static final ParameterNameExtractor parameterNameExtractor;
    public static final DslJson.ConverterFactory<ImmutableDescription> CONVERTER;

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ignore) {
            return false;
        }
    }

    @Nullable
    public static String[] extractNames(Constructor<?> ctor) {
        if (ctor == null) {
            throw new IllegalArgumentException("ctor can't be null");
        }
        return parameterNameExtractor.extractNames(ctor);
    }

    @Nullable
    private static <T> ImmutableDescription<T> analyze(Type manifest, final Class<T> raw, DslJson<?> json) {
        JsonWriter.WriteObject[] writeProps;
        if (raw.isArray() || Collection.class.isAssignableFrom(raw) || (raw.getModifiers() & 0x400) != 0 || raw.isInterface() || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0 || (raw.getModifiers() & 1) == 0) {
            return null;
        }
        ArrayList ctors = new ArrayList();
        for (Constructor<?> ctor : raw.getDeclaredConstructors()) {
            if ((ctor.getModifiers() & 1) != 1) continue;
            ctors.add(ctor);
        }
        if (ctors.size() != 1) {
            return null;
        }
        final Constructor ctor = (Constructor)ctors.get(0);
        Type[] paramTypes = ctor.getGenericParameterTypes();
        if (paramTypes.length == 0) {
            return null;
        }
        String[] names = ImmutableAnalyzer.extractNames(ctor);
        if (names == null) {
            HashSet<Type> types = new HashSet<Type>();
            for (Type p : paramTypes) {
                if (types.add(p)) continue;
                return null;
            }
        }
        LazyImmutableDescription lazy = new LazyImmutableDescription(json, manifest);
        JsonWriter.WriteObject oldWriter = json.registerWriter(manifest, (JsonWriter.WriteObject)lazy);
        JsonReader.ReadObject oldReader = json.registerReader(manifest, (JsonReader.ReadObject)lazy);
        LinkedHashMap<String, JsonWriter.WriteObject> fields = new LinkedHashMap<String, JsonWriter.WriteObject>();
        LinkedHashMap<String, JsonWriter.WriteObject> methods = new LinkedHashMap<String, JsonWriter.WriteObject>();
        HashMap<Type, Type> genericMappings = Generics.analyze(manifest, raw);
        Object[] defArgs = ImmutableAnalyzer.findDefaultArguments(paramTypes, genericMappings, json);
        LinkedHashMap<String, Field> matchingFields = new LinkedHashMap<String, Field>();
        for (Field f : raw.getFields()) {
            if (!ImmutableAnalyzer.isPublicFinalNonStatic(f.getModifiers())) continue;
            matchingFields.put(f.getName(), f);
        }
        LinkedHashMap<String, Method> matchingMethods = new LinkedHashMap<String, Method>();
        for (Method mget : raw.getMethods()) {
            if (mget.getParameterTypes().length != 0) continue;
            String name = Analysis.beanOrActualName((String)mget.getName());
            if (!ImmutableAnalyzer.isPublicNonStatic(mget.getModifiers()) || name.contains("$") || objectMethods.contains(name)) continue;
            matchingMethods.put(name, mget);
        }
        if (names != null) {
            int i;
            if (matchingFields.size() == paramTypes.length) {
                for (i = 0; i < paramTypes.length; ++i) {
                    Field f = (Field)matchingFields.get(names[i]);
                    if (f != null && ImmutableAnalyzer.analyzeField(json, paramTypes[i], fields, f, genericMappings)) continue;
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = fields.values().toArray(new JsonWriter.WriteObject[0]);
            } else {
                for (i = 0; i < paramTypes.length; ++i) {
                    Method m = (Method)matchingMethods.get(names[i]);
                    if (m != null && ImmutableAnalyzer.analyzeMethod(m, json, paramTypes[i], names[i], methods, genericMappings)) continue;
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = methods.values().toArray(new JsonWriter.WriteObject[0]);
            }
        } else {
            names = new String[paramTypes.length];
            if (matchingFields.size() == paramTypes.length) {
                ArrayList orderedFields = new ArrayList(matchingFields.values());
                for (int i = 0; i < paramTypes.length; ++i) {
                    Field f = (Field)orderedFields.get(i);
                    if (!ImmutableAnalyzer.analyzeField(json, paramTypes[i], fields, f, genericMappings)) {
                        return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                    }
                    names[i] = f.getName();
                }
                writeProps = fields.values().toArray(new JsonWriter.WriteObject[0]);
            } else {
                block7: for (Type p : paramTypes) {
                    for (Map.Entry kv : matchingMethods.entrySet()) {
                        Method m = (Method)kv.getValue();
                        if (!ImmutableAnalyzer.analyzeMethod(m, json, p, (String)kv.getKey(), methods, genericMappings)) continue;
                        matchingMethods.remove(kv.getKey());
                        continue block7;
                    }
                }
                if (methods.size() != paramTypes.length) {
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = methods.values().toArray(new JsonWriter.WriteObject[0]);
                names = (fields.isEmpty() ? methods.keySet() : fields.keySet()).toArray(new String[0]);
            }
        }
        DecodePropertyInfo[] readProps = new DecodePropertyInfo[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Type concreteType = Generics.makeConcrete(paramTypes[i], genericMappings);
            readProps[i] = new DecodePropertyInfo<WriteCtor>(names[i], false, false, i, false, new WriteCtor(json, concreteType, ctor));
        }
        ImmutableDescription converter = new ImmutableDescription(manifest, defArgs, new Settings.Function<Object[], T>(){

            @Override
            public T apply(@Nullable Object[] args) {
                try {
                    return raw.cast(ctor.newInstance(args));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }, writeProps, readProps, !json.omitDefaults, true);
        json.registerWriter(manifest, converter);
        json.registerReader(manifest, converter);
        lazy.resolved = converter;
        return converter;
    }

    @Nullable
    private static <T> ImmutableDescription<T> unregister(Type manifest, DslJson<?> json, @Nullable JsonWriter.WriteObject oldWriter, @Nullable JsonReader.ReadObject oldReader) {
        json.registerWriter(manifest, oldWriter);
        json.registerReader(manifest, oldReader);
        return null;
    }

    private static Object[] findDefaultArguments(Type[] paramTypes, HashMap<Type, Type> genericMappings, DslJson json) {
        Object[] defArgs = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Type concreteType = Generics.makeConcrete(paramTypes[i], genericMappings);
            defArgs[i] = json.getDefault(concreteType);
        }
        return defArgs;
    }

    private static boolean analyzeField(DslJson json, Type paramType, LinkedHashMap<String, JsonWriter.WriteObject> found, Field field, HashMap<Type, Type> genericMappings) {
        Type type = field.getGenericType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (type.equals(paramType) && (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null)) {
            found.put(field.getName(), Settings.createEncoder(new Reflection.ReadField(field), field.getName(), json, isUnknown ? null : concreteType));
            return true;
        }
        return false;
    }

    private static boolean analyzeMethod(Method mget, DslJson json, Type paramType, String name, HashMap<String, JsonWriter.WriteObject> found, HashMap<Type, Type> genericMappings) {
        Type type = mget.getGenericReturnType();
        Type concreteType = Generics.makeConcrete(type, genericMappings);
        boolean isUnknown = Generics.isUnknownType(type);
        if (type.equals(paramType) && (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null)) {
            found.put(name, Settings.createEncoder(new Reflection.ReadMethod(mget), name, json, isUnknown ? null : concreteType));
            return true;
        }
        return false;
    }

    private static boolean isPublicFinalNonStatic(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 0x10) != 0 && (modifiers & 8) == 0;
    }

    private static boolean isPublicNonStatic(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 8) == 0;
    }

    static {
        for (Method m : Object.class.getMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            objectMethods.add(m.getName());
        }
        ArrayList<ParameterNameExtractor> extractors = new ArrayList<ParameterNameExtractor>();
        if (ImmutableAnalyzer.isClassAvailable("java.lang.reflect.Parameter")) {
            extractors.add(new Java8ParameterNameExtractor());
        }
        if (ImmutableAnalyzer.isClassAvailable("com.thoughtworks.paranamer.Paranamer")) {
            extractors.add(new ParanamerParameterNameExtractor());
        }
        parameterNameExtractor = new CompositeParameterNameExtractor(extractors);
        CONVERTER = new DslJson.ConverterFactory<ImmutableDescription>(){

            @Nullable
            public ImmutableDescription tryCreate(Type manifest, DslJson dslJson) {
                ParameterizedType pt;
                if (manifest instanceof Class) {
                    return ImmutableAnalyzer.analyze(manifest, (Class)manifest, dslJson);
                }
                if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                    return ImmutableAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
                }
                return null;
            }
        };
    }

    private static class WriteCtor
    implements JsonReader.ReadObject {
        private final DslJson json;
        private final Type type;
        private final Constructor<?> ctor;
        private JsonReader.ReadObject decoder;

        WriteCtor(DslJson json, Type type, Constructor<?> ctor) {
            this.json = json;
            this.type = type;
            this.ctor = ctor;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.decoder == null) {
                this.decoder = this.json.tryFindReader(this.type);
                if (this.decoder == null) {
                    throw new ConfigurationException("Unable to find reader for " + this.type + " on " + this.ctor);
                }
            }
            return this.decoder.read(reader);
        }
    }

    private static class LazyImmutableDescription
    implements JsonWriter.WriteObject,
    JsonReader.ReadObject {
        private final DslJson json;
        private final Type type;
        private JsonWriter.WriteObject encoder;
        private JsonReader.ReadObject decoder;
        volatile ImmutableDescription resolved;

        LazyImmutableDescription(DslJson json, Type type) {
            this.json = json;
            this.type = type;
        }

        private boolean checkSignatureNotFound() {
            ImmutableDescription local = null;
            for (int i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                local = this.resolved;
                if (local == null) continue;
                this.encoder = local;
                this.decoder = local;
                break;
            }
            return local == null;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.decoder == null && this.checkSignatureNotFound()) {
                JsonReader.ReadObject tmp = this.json.tryFindReader(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find reader for " + this.type);
                }
                this.decoder = tmp;
            }
            return this.decoder.read(reader);
        }

        public void write(JsonWriter writer, @Nullable Object value) {
            if (this.encoder == null && this.checkSignatureNotFound()) {
                JsonWriter.WriteObject tmp = this.json.tryFindWriter(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find writer for " + this.type);
                }
                this.encoder = tmp;
            }
            this.encoder.write(writer, value);
        }
    }
}

