/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.Nullable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class Generics {
    private static final ConcurrentMap<String, Type> typeCache = new ConcurrentHashMap<String, Type>();

    public static HashMap<Type, Type> analyze(Type manifest, Class<?> raw) {
        HashMap<Type, Type> genericMappings = new HashMap<Type, Type>();
        if (manifest instanceof ParameterizedType) {
            Type[] actual = ((ParameterizedType)manifest).getActualTypeArguments();
            TypeVariable<Class<?>>[] variables = raw.getTypeParameters();
            for (int i = 0; i < variables.length; ++i) {
                genericMappings.put(variables[i], actual[i]);
            }
        } else {
            for (TypeVariable<Class<?>> tp : raw.getTypeParameters()) {
                genericMappings.put(tp, (Type)((Object)Object.class));
            }
        }
        return genericMappings;
    }

    public static Type makeConcrete(Type manifest, HashMap<Type, Type> mappings) {
        GenericArrayType gat;
        Type newType;
        if (mappings.isEmpty()) {
            return manifest;
        }
        if (manifest instanceof TypeVariable) {
            return mappings.get(manifest);
        }
        if (manifest instanceof GenericArrayType && (newType = Generics.makeConcrete((gat = (GenericArrayType)manifest).getGenericComponentType(), mappings)) instanceof Class) {
            return Array.newInstance((Class)newType, 0).getClass();
        }
        if (manifest instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)manifest;
            Type[] generics = pt.getActualTypeArguments();
            boolean changed = false;
            for (int i = 0; i < generics.length; ++i) {
                Type newType2 = Generics.makeConcrete(generics[i], mappings);
                changed = changed || newType2 != generics[i];
                generics[i] = newType2;
            }
            if (changed) {
                return Generics.makeParameterizedType((Class)pt.getRawType(), generics);
            }
        }
        return manifest;
    }

    public static ParameterizedType makeParameterizedType(Class<?> container, Type ... arguments) {
        if (container == null) {
            throw new IllegalArgumentException("container can't be null");
        }
        int containerParameterCount = container.getTypeParameters().length;
        if (containerParameterCount == 0) {
            throw new IllegalArgumentException("container must be parameterized type");
        }
        if (arguments == null || arguments.length != containerParameterCount) {
            throw new IllegalArgumentException("arguments must have " + containerParameterCount + " elements");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(container.getName());
        sb.append("<");
        sb.append(Generics.getTypeNameCompat(arguments[0]));
        for (int i = 1; i < arguments.length; ++i) {
            sb.append(", ");
            sb.append(Generics.getTypeNameCompat(arguments[i]));
        }
        sb.append(">");
        String name = sb.toString();
        GenericType found = (GenericType)typeCache.get(name);
        if (found == null) {
            found = new GenericType(name, container, arguments);
            typeCache.put(name, found);
        }
        return found;
    }

    public static Type makeArrayType(Type componentType) {
        if (componentType == null) {
            throw new IllegalArgumentException("componentType can't be null");
        }
        String name = componentType.toString() + "[]";
        Type found = (Class<?>)typeCache.get(name);
        if (found == null) {
            if (componentType instanceof Class) {
                found = Array.newInstance((Class)componentType, 0).getClass();
            } else if (componentType instanceof ParameterizedType) {
                found = new GenericArrayTypeImpl(name, componentType);
            } else {
                throw new IllegalArgumentException("Invalid componentType provided: " + componentType + ". Only ParameterizedType or Class supported");
            }
            typeCache.put(name, found);
        }
        return found;
    }

    private static String getTypeNameCompat(Type type) {
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (clazz.isArray()) {
                try {
                    int dimensions = 0;
                    while (clazz.isArray()) {
                        ++dimensions;
                        clazz = clazz.getComponentType();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(clazz.getName());
                    for (int i = 0; i < dimensions; ++i) {
                        sb.append("[]");
                    }
                    return sb.toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return clazz.getName();
        }
        return type.toString();
    }

    public static boolean isUnknownType(Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Generics.isUnknownType(gat.getGenericComponentType());
        }
        return Object.class == type || type instanceof TypeVariable;
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final String name;
        private final Type componentType;

        private GenericArrayTypeImpl(String name, Type componentType) {
            this.name = name;
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            if (o instanceof GenericArrayType) {
                return this.componentType.equals(((GenericArrayType)o).getGenericComponentType());
            }
            return false;
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }

    private static class GenericType
    implements ParameterizedType {
        private final String name;
        private final Type raw;
        private final Type[] arguments;

        GenericType(String name, Type raw, Type[] arguments) {
            this.name = name;
            this.raw = raw;
            this.arguments = arguments;
        }

        public int hashCode() {
            return Arrays.hashCode(this.arguments) ^ this.raw.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)other;
                return this.raw.equals(pt.getRawType()) && Arrays.equals(this.arguments, pt.getActualTypeArguments());
            }
            return false;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.arguments;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

