/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.FormatConverter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public final class FormatDescription<T>
implements JsonWriter.WriteObject<T>,
JsonReader.ReadObject<T>,
JsonReader.BindObject<T> {
    private static final Charset utf8 = Charset.forName("UTF-8");
    final Type manifest;
    final boolean isObjectFormatFirst;
    final FormatConverter<T> objectFormat;
    private final JsonReader.BindObject<T> objectBinder;
    final FormatConverter<T> arrayFormat;
    private final JsonReader.BindObject<T> arrayBinder;
    final int typeHash;
    final byte[] typeName;
    final byte[] quotedTypeName;
    private final String startErrorBoth;
    private final String startErrorObject;
    private final String startErrorArray;
    private final String formatErrorObject;
    private final String formatErrorArray;

    public FormatDescription(Type manifest, @Nullable FormatConverter<T> objectFormat, @Nullable FormatConverter<T> arrayFormat, boolean isObjectFormatFirst, String typeName, DslJson json) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (objectFormat == null && arrayFormat == null) {
            throw new IllegalArgumentException("both objectConverter and arrayFormat can't be null at the same time");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        if (typeName == null) {
            throw new IllegalArgumentException("typeName can't be null");
        }
        if (!json.allowArrayFormat && objectFormat == null) {
            throw new IllegalArgumentException("Since array format is not allowed, objectFormat can't be null");
        }
        if (isObjectFormatFirst && objectFormat == null) {
            throw new IllegalArgumentException("Object format is defined as primary format, but object format is not defined");
        }
        this.manifest = manifest;
        this.objectFormat = objectFormat;
        this.objectBinder = objectFormat instanceof JsonReader.BindObject ? (JsonReader.BindObject)objectFormat : null;
        this.arrayFormat = arrayFormat;
        this.arrayBinder = arrayFormat instanceof JsonReader.BindObject ? (JsonReader.BindObject)arrayFormat : null;
        this.isObjectFormatFirst = isObjectFormatFirst || !json.allowArrayFormat;
        String name = typeName.replace("$", ".");
        this.typeName = name.getBytes(utf8);
        this.quotedTypeName = ("\"" + name + "\"").getBytes(utf8);
        this.typeHash = DecodePropertyInfo.calcHash(name);
        this.startErrorBoth = String.format("Expecting '{' or '[' to start decoding %s", manifest.getTypeName());
        this.startErrorObject = String.format("Expecting '{' to start decoding %s", manifest.getTypeName());
        this.startErrorArray = String.format("Expecting '[' to start decoding %s", manifest.getTypeName());
        this.formatErrorObject = String.format("Object format for %s is not defined", manifest.getTypeName());
        this.formatErrorArray = String.format("Array format for %s is not defined", manifest.getTypeName());
    }

    public final void write(JsonWriter writer, @Nullable T instance) {
        if (instance == null) {
            writer.writeNull();
        } else if (this.isObjectFormatFirst) {
            this.objectFormat.write(writer, instance);
        } else {
            this.arrayFormat.write(writer, instance);
        }
    }

    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        if (reader.last() == 123) {
            if (this.objectFormat == null) {
                throw reader.newParseError(this.formatErrorObject);
            }
            return (T)this.objectFormat.read(reader);
        }
        if (reader.last() == 91) {
            if (this.arrayFormat == null) {
                throw reader.newParseError(this.formatErrorArray);
            }
            return (T)this.arrayFormat.read(reader);
        }
        if (this.objectFormat != null && this.arrayFormat != null) {
            throw reader.newParseError(this.startErrorBoth);
        }
        if (this.objectFormat != null) {
            throw reader.newParseError(this.startErrorObject);
        }
        throw reader.newParseError(this.startErrorArray);
    }

    public T bind(JsonReader reader, T instance) throws IOException {
        if (reader.last() == 123) {
            if (this.objectFormat == null) {
                throw reader.newParseError(this.formatErrorObject);
            }
            if (this.objectBinder == null) {
                throw new ConfigurationException(this.manifest.getTypeName() + " does not support binding");
            }
            return (T)this.objectBinder.bind(reader, instance);
        }
        if (reader.last() == 91) {
            if (this.arrayFormat == null) {
                throw reader.newParseError(this.formatErrorArray);
            }
            if (this.arrayBinder == null) {
                throw new ConfigurationException(this.manifest.getTypeName() + " does not support binding");
            }
            return (T)this.arrayBinder.bind(reader, instance);
        }
        if (this.objectFormat != null && this.arrayFormat != null) {
            throw reader.newParseError(this.startErrorBoth);
        }
        if (this.objectFormat != null) {
            throw reader.newParseError(this.startErrorObject);
        }
        throw reader.newParseError(this.startErrorArray);
    }
}

