/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.runtime.CollectionDecoder;
import com.dslplatform.json.runtime.CollectionEncoder;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;

public abstract class CollectionAnalyzer {
    public static final DslJson.ConverterFactory<CollectionDecoder> READER = new DslJson.ConverterFactory<CollectionDecoder>(){

        @Nullable
        public CollectionDecoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof Class) {
                return CollectionAnalyzer.analyzeDecoding(manifest, Object.class, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                return CollectionAnalyzer.analyzeDecoding(manifest, pt.getActualTypeArguments()[0], (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };
    public static final DslJson.ConverterFactory<CollectionEncoder> WRITER = new DslJson.ConverterFactory<CollectionEncoder>(){

        @Nullable
        public CollectionEncoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof Class) {
                return CollectionAnalyzer.analyzeEncoding(manifest, Object.class, (Class)manifest, dslJson);
            }
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                return CollectionAnalyzer.analyzeEncoding(manifest, pt.getActualTypeArguments()[0], (Class)pt.getRawType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static CollectionDecoder analyzeDecoding(Type manifest, Type element, final Class<?> collection, DslJson json) {
        Callable newInstance;
        if (!Collection.class.isAssignableFrom(collection)) {
            return null;
        }
        if (!collection.isInterface()) {
            try {
                collection.newInstance();
            }
            catch (Exception ex) {
                return null;
            }
            newInstance = new Callable(){

                public Object call() throws Exception {
                    return collection.newInstance();
                }
            };
        } else if (Set.class.isAssignableFrom(collection)) {
            newInstance = new Callable(){

                public Object call() {
                    return new LinkedHashSet(4);
                }
            };
        } else if (List.class.isAssignableFrom(collection) || Collection.class == collection) {
            newInstance = new Callable(){

                public Object call() throws Exception {
                    return new ArrayList(4);
                }
            };
        } else if (Queue.class.isAssignableFrom(collection)) {
            newInstance = new Callable(){

                public Object call() throws Exception {
                    return new LinkedList();
                }
            };
        } else {
            return null;
        }
        JsonReader.ReadObject reader = json.tryFindReader(element);
        if (reader == null) {
            return null;
        }
        CollectionDecoder decoder = new CollectionDecoder(manifest, newInstance, reader);
        json.registerReader(manifest, decoder);
        return decoder;
    }

    @Nullable
    private static CollectionEncoder analyzeEncoding(Type manifest, Type element, Class<?> collection, DslJson json) {
        JsonWriter.WriteObject writer;
        if (!Collection.class.isAssignableFrom(collection)) {
            return null;
        }
        JsonWriter.WriteObject writeObject = writer = Object.class == element ? null : json.tryFindWriter(element);
        if (Object.class != element && writer == null) {
            return null;
        }
        CollectionEncoder encoder = new CollectionEncoder(json, Settings.isKnownType(element) ? writer : null);
        json.registerWriter(manifest, encoder);
        return encoder;
    }

    public static class Runtime {
        public static final JsonReader.ReadObject<List<Object>> JSON_READER = new JsonReader.ReadObject<List<Object>>(){

            public List<Object> read(JsonReader reader) throws IOException {
                if (reader.wasNull()) {
                    return null;
                }
                return ObjectConverter.deserializeList((JsonReader)reader);
            }
        };
        public static final JsonWriter.WriteObject<List<Object>> JSON_WRITER = new JsonWriter.WriteObject<List<Object>>(){

            public void write(JsonWriter writer, @Nullable List<Object> value) {
                if (value == null) {
                    writer.writeNull();
                } else if (value.isEmpty()) {
                    writer.writeAscii("[]");
                } else if (value instanceof RandomAccess) {
                    writer.writeByte((byte)91);
                    writer.serializeObject(value.get(0));
                    for (int i = 1; i < value.size(); ++i) {
                        writer.writeByte((byte)44);
                        writer.serializeObject(value.get(i));
                    }
                    writer.writeByte((byte)93);
                } else {
                    writer.writeByte((byte)91);
                    Iterator<Object> iter = value.iterator();
                    writer.serializeObject(iter.next());
                    while (iter.hasNext()) {
                        writer.writeByte((byte)44);
                        writer.serializeObject(iter.next());
                    }
                    writer.writeByte((byte)93);
                }
            }
        };
    }
}

