/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.BoolConverter;
import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.JavaTimeConverter;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.StringConverter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneId;

public abstract class ResultSetConverter {
    public static final JsonWriter.WriteObject<ResultSet> WRITER = new JsonWriter.WriteObject<ResultSet>(){

        public void write(JsonWriter writer, @Nullable ResultSet value) {
            if (value == null) {
                writer.writeNull();
            } else {
                try {
                    ResultSetConverter.serialize(value, writer, null);
                }
                catch (IOException | SQLException e) {
                    throw new SerializationException((Throwable)e);
                }
            }
        }
    };

    public static void serialize(ResultSet rs, JsonWriter buffer, @Nullable OutputStream stream) throws SQLException, IOException {
        ResultSetMetaData metadata = rs.getMetaData();
        int columns = metadata.getColumnCount();
        if (columns == 0) {
            throw new ConfigurationException("No columns found in ResultSet");
        }
        Writer[] writers = new Writer[columns];
        for (int i = 0; i < writers.length; ++i) {
            writers[i] = ResultSetConverter.createWriter(metadata, i + 1);
            Writer wrt = writers[i];
            if (wrt != null) continue;
            throw new ConfigurationException("Unable to find Writer for column " + i);
        }
        ResultSetConverter.serialize(rs, stream, buffer, writers);
    }

    public static void serialize(ResultSet rs, @Nullable OutputStream stream, JsonWriter buffer, Writer[] writers) throws SQLException, IOException {
        int i;
        if (stream != null) {
            buffer.reset();
        }
        buffer.writeByte((byte)91);
        if (rs.next()) {
            buffer.writeByte((byte)91);
            writers[0].write(rs, buffer);
            for (i = 1; i < writers.length; ++i) {
                buffer.writeByte((byte)44);
                writers[i].write(rs, buffer);
            }
        } else {
            buffer.writeByte((byte)93);
            if (stream != null) {
                buffer.toStream(stream);
            }
            return;
        }
        while (rs.next()) {
            buffer.writeAscii("],[", 3);
            writers[0].write(rs, buffer);
            for (i = 1; i < writers.length; ++i) {
                buffer.writeByte((byte)44);
                writers[i].write(rs, buffer);
            }
            if (stream == null) continue;
            buffer.toStream(stream);
            buffer.reset();
        }
        buffer.writeAscii("]]");
        if (stream != null) {
            buffer.toStream(stream);
        }
    }

    @Nullable
    public static Writer createWriter(ResultSetMetaData metaData, int index) throws SQLException {
        switch (metaData.getColumnType(index)) {
            case 2003: {
                return null;
            }
            case -5: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((long)rs.getLong(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    long value = rs.getLong(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((long)value, (JsonWriter)buffer);
                    }
                };
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> buffer.writeBinary(rs.getBytes(index)) : (rs, buffer) -> {
                    byte[] value = rs.getBytes(index);
                    if (value == null) {
                        buffer.writeNull();
                    } else {
                        buffer.writeBinary(value);
                    }
                };
            }
            case -7: 
            case 16: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> BoolConverter.serialize((boolean)rs.getBoolean(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    boolean value = rs.getBoolean(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        BoolConverter.serialize((boolean)value, (JsonWriter)buffer);
                    }
                };
            }
            case 70: {
                return null;
            }
            case 91: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> JavaTimeConverter.serialize(rs.getDate(index).toLocalDate(), buffer) : (rs, buffer) -> {
                    Date date = rs.getDate(index);
                    if (date == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(date.toLocalDate(), buffer);
                    }
                };
            }
            case 2: 
            case 3: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((BigDecimal)rs.getBigDecimal(index), (JsonWriter)buffer) : (rs, buffer) -> NumberConverter.serializeNullable((BigDecimal)rs.getBigDecimal(index), (JsonWriter)buffer);
            }
            case 2001: {
                return null;
            }
            case 8: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((double)rs.getDouble(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    double value = rs.getDouble(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((double)value, (JsonWriter)buffer);
                    }
                };
            }
            case 6: 
            case 7: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((float)rs.getFloat(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    float value = rs.getFloat(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((float)value, (JsonWriter)buffer);
                    }
                };
            }
            case -6: 
            case 5: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((int)rs.getShort(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    short value = rs.getShort(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((int)value, (JsonWriter)buffer);
                    }
                };
            }
            case 4: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> NumberConverter.serialize((int)rs.getInt(index), (JsonWriter)buffer) : (rs, buffer) -> {
                    int value = rs.getInt(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((int)value, (JsonWriter)buffer);
                    }
                };
            }
            case 2000: {
                return null;
            }
            case 0: {
                return (rs, buffer) -> buffer.writeNull();
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> buffer.writeString(rs.getNString(index)) : (rs, buffer) -> StringConverter.serializeNullable((String)rs.getNString(index), (JsonWriter)buffer);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> buffer.writeString(rs.getString(index)) : (rs, buffer) -> StringConverter.serializeNullable((String)rs.getString(index), (JsonWriter)buffer);
            }
            case 1111: {
                return null;
            }
            case 2006: {
                return null;
            }
            case 2012: {
                return null;
            }
            case -8: {
                return null;
            }
            case 2009: {
                return (rs, buffer) -> {
                    SQLXML xml = rs.getSQLXML(index);
                    if (xml == null) {
                        buffer.writeNull();
                    } else {
                        StringConverter.serialize((String)xml.getString(), (JsonWriter)buffer);
                        xml.free();
                    }
                };
            }
            case 2002: {
                return null;
            }
            case 92: {
                return null;
            }
            case 2013: {
                return null;
            }
            case 93: 
            case 2014: {
                ZoneId zone = ZoneId.systemDefault();
                return metaData.isNullable(index) == 0 ? (rs, buffer) -> JavaTimeConverter.serialize(OffsetDateTime.ofInstant(rs.getTimestamp(index).toInstant(), zone), buffer) : (rs, buffer) -> {
                    Timestamp timestamp = rs.getTimestamp(index);
                    if (timestamp == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(OffsetDateTime.ofInstant(timestamp.toInstant(), zone), buffer);
                    }
                };
            }
        }
        return null;
    }

    public static interface Writer {
        public void write(ResultSet var1, JsonWriter var2) throws SQLException;
    }
}

