/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.annotation;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZipFileIterator {
    private final File file;
    private final ZipFile zipFile;
    private final String[] entryNameFilter;
    private final Enumeration<? extends ZipEntry> entries;
    private ZipEntry current;

    ZipFileIterator(File file, String[] entryNameFilter) throws IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.entryNameFilter = entryNameFilter;
        this.entries = this.zipFile.entries();
    }

    public ZipEntry getEntry() {
        return this.current;
    }

    public InputStream next(FilenameFilter filter) throws IOException {
        while (this.entries.hasMoreElements()) {
            this.current = this.entries.nextElement();
            if (filter != null && !this.accept(this.current, filter)) continue;
            return this.zipFile.getInputStream(this.current);
        }
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean accept(ZipEntry entry, FilenameFilter filter) {
        if (entry.isDirectory()) {
            return false;
        }
        String name = entry.getName();
        if (name.endsWith(".class") && filter.accept(this.file, name)) {
            if (this.entryNameFilter == null) {
                return true;
            }
            for (String entryName : this.entryNameFilter) {
                if (!name.startsWith(entryName)) continue;
                return true;
            }
        }
        return false;
    }
}

