/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.annotation;

import dorkbox.annotation.ClassIterator;
import dorkbox.annotation.FileIterator;
import dorkbox.annotation.ZipFileIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class ClassFileIterator
implements ClassIterator {
    private FileIterator fileIter;
    protected final String[] pkgNameFilter;
    private ZipFileIterator zipIter;
    private boolean isFile;

    protected ClassFileIterator(String[] pkgNameFilter) {
        this.pkgNameFilter = pkgNameFilter;
    }

    protected ClassFileIterator(File[] filesOrDirectories, String[] pkgNameFilter) {
        this.fileIter = new FileIterator(filesOrDirectories);
        this.pkgNameFilter = pkgNameFilter;
    }

    @Override
    public String getName() {
        return this.zipIter == null ? this.fileIter.getFile().getPath() : this.zipIter.getEntry().getName();
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public InputStream next(FilenameFilter filter) throws IOException {
        InputStream is;
        while (true) {
            if (this.zipIter == null) {
                File file = this.fileIter.next();
                if (file == null) {
                    return null;
                }
                String path = file.getPath();
                if (path.endsWith(".class") && (filter == null || filter.accept(this.fileIter.getRootFile(), this.fileIter.relativize(path)))) {
                    this.isFile = true;
                    return new FileInputStream(file);
                }
                if (!this.fileIter.isRootFile() || !ClassFileIterator.endsWithIgnoreCase(path, ".jar")) continue;
                this.zipIter = new ZipFileIterator(file, this.pkgNameFilter);
                continue;
            }
            is = this.zipIter.next(filter);
            if (is != null) break;
            this.zipIter = null;
        }
        this.isFile = false;
        return is;
    }

    private static boolean endsWithIgnoreCase(String value, String suffix) {
        int n = suffix.length();
        return value.regionMatches(true, value.length() - n, suffix, 0, n);
    }
}

