/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.utilities.status;

import com.djrapitops.plugin.utilities.FormatUtils;
import com.djrapitops.plugin.utilities.status.obj.BenchmarkObj;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Timings {
    private final Map<String, BenchmarkObj> avgTimings = new HashMap<String, BenchmarkObj>();

    public void markExecution(String benchmark, long time) {
        this.avgTimings.computeIfAbsent(benchmark, computedBench -> new BenchmarkObj()).addBenchmark(time);
    }

    public String[] asStringArray() {
        String[] states = new String[this.avgTimings.size()];
        int i = 0;
        List msgs = this.avgTimings.keySet().stream().sorted().map(bench -> {
            try {
                return FormatUtils.formatBench(bench, this.avgTimings.get(bench).getAverage());
            }
            catch (NullPointerException e) {
                return FormatUtils.formatBench(bench, -1L);
            }
        }).collect(Collectors.toList());
        Iterator iterator = msgs.iterator();
        while (iterator.hasNext()) {
            String msg;
            states[i] = msg = (String)iterator.next();
            ++i;
        }
        return states;
    }
}

