/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.utilities;

import com.djrapitops.plugin.command.ISender;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;

public class Verify {
    public static boolean exists(File file) {
        return Verify.notNull(file) && file.exists();
    }

    public static File existCheck(File file) throws IllegalArgumentException {
        return Verify.existCheck(file, () -> new IllegalArgumentException("File did not exist"));
    }

    public static <K extends Throwable> File existCheck(File file, ErrorLoader<K> exception) throws K {
        Verify.nullCheck(file, exception);
        if (Verify.exists(file)) {
            return file;
        }
        throw exception.load();
    }

    public static boolean isEmpty(String string) {
        return !Verify.notNull(string) || string.isEmpty();
    }

    public static <T> boolean isEmpty(Collection<T> coll) {
        return !Verify.notNull(coll) || coll.isEmpty();
    }

    public static <T, K> boolean isEmpty(Map<T, K> map) {
        return !Verify.notNull(map) || map.isEmpty();
    }

    public static <T> boolean contains(T lookFor, Collection<T> coll) {
        return !Verify.isEmpty(coll) && Verify.contains(lookFor, coll.stream());
    }

    public static <T> boolean contains(T lookFor, Stream<T> stream) {
        return stream.anyMatch(obj -> Verify.equals(obj, lookFor));
    }

    @SafeVarargs
    public static <T> boolean contains(T lookFor, T ... objects) {
        return Verify.contains(lookFor, Arrays.stream(objects));
    }

    public static <T> boolean contains(T lookFor, Map<T, Object> map) {
        return Verify.contains(lookFor, map.keySet().stream());
    }

    public static boolean equalsIgnoreCase(String one, String two) {
        return Verify.notNull(one) && one.equalsIgnoreCase(two);
    }

    public static boolean equalsOne(String toCheck, String ... isEqual) {
        if (isEqual == null) {
            return false;
        }
        if (toCheck == null && Verify.containsNull(new Object[]{isEqual})) {
            return true;
        }
        for (String s : isEqual) {
            if (!s.equals(toCheck)) continue;
            return true;
        }
        return false;
    }

    public static <T, K> boolean equals(T object, K object2) {
        return Verify.notNull(object) && object.equals(object2);
    }

    public static boolean notNull(Object ... object) {
        if (object == null) {
            return false;
        }
        return !Verify.containsNull(object);
    }

    public static boolean containsNull(Object ... object) {
        for (Object t : object) {
            if (t != null) continue;
            return true;
        }
        return false;
    }

    public static <T> T nullCheck(T object) throws IllegalArgumentException {
        return Verify.nullCheck(object, () -> new IllegalArgumentException("Something was null!"));
    }

    public static <T, K extends Throwable> T nullCheck(T object, ErrorLoader<K> exception) throws K {
        if (!Verify.notNull(object)) {
            throw exception.load();
        }
        return object;
    }

    @SafeVarargs
    public static <T> T[] nullCheck(T ... objects) throws IllegalArgumentException {
        return Verify.nullCheck(() -> new IllegalArgumentException("Contained a null object!"), objects);
    }

    public static <T, K extends Throwable> T[] nullCheck(ErrorLoader<K> exception, T ... objects) throws K {
        for (T obj : objects) {
            if (Verify.notNull(obj)) continue;
            throw exception.load();
        }
        return objects;
    }

    public static <K extends Throwable> void checkCondition(boolean condition, ErrorLoader<K> exception) throws K {
        if (!condition) {
            throw exception.load();
        }
    }

    public static boolean hasPermission(String permission, ISender sender) {
        return sender.hasPermission(permission);
    }

    public static interface ErrorLoader<K extends Throwable> {
        public K load();
    }
}

