/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plugin.utilities;

import com.djrapitops.plugin.api.utility.log.Log;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;

public class FormatUtils {
    public static String formatTimeStamp(long epochMs) {
        Date date = new Date(epochMs);
        String timeStamp = date.toString();
        String day = timeStamp.substring(4, 10);
        String clock = timeStamp.substring(11, 16);
        return day + ", " + clock;
    }

    public static String formatTimeStampSecond(long epochMs) {
        Date date = new Date(epochMs);
        String timeStamp = date.toString();
        String day = timeStamp.substring(4, 10);
        String clock = timeStamp.substring(11, 19);
        return day + ", " + clock;
    }

    public static String formatTimeStampYear(long epochMs) {
        Date date = new Date(epochMs);
        String timeStamp = date.toString();
        String year = timeStamp.substring(24);
        String day = timeStamp.substring(4, 10);
        String clock = timeStamp.substring(11, 16);
        return day + " " + year + ", " + clock;
    }

    public static String removeLetters(String dataPoint) {
        return dataPoint.replaceAll("[A-Za-z]", "");
    }

    public static String removeNumbers(String dataPoint) {
        return dataPoint.replaceAll("[0-9]", "");
    }

    public static String removeSymbols(String dataPoint) {
        return dataPoint.replaceAll("[^a-zA-Z0-9_\\s]", "");
    }

    public static String removeSymbolsButDot(String dataPoint) {
        return dataPoint.replaceAll("[^a-zA-Z0-9_\\s\\.]", "");
    }

    public static String spaceWhitespace(String dataPoint) {
        return dataPoint.replaceAll("[\\s]", " ");
    }

    public static String removeWhitespace(String dataPoint) {
        return dataPoint.replaceAll("[\\s]", "");
    }

    public static long parseVersionNumber(String versionString) throws NumberFormatException {
        String replaced = versionString.replaceAll("[^0-9]", ".");
        String[] split = replaced.split("\\.");
        List version = Arrays.stream(split).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        long versionNumber = 0L;
        for (int i = 0; i < version.size(); ++i) {
            try {
                int num = Integer.parseInt((String)version.get(i));
                long multiplier = (long)Math.pow(100.0, 8 - i);
                versionNumber += (long)num * multiplier;
                continue;
            }
            catch (NumberFormatException e) {
                Log.toLog(FormatUtils.class, (Throwable)e);
            }
        }
        return versionNumber;
    }

    public static String[] removeFirstArgument(String ... args) {
        String[] arguments = new String[args.length - 1];
        System.arraycopy(args, 1, arguments, 0, args.length - 1);
        return arguments;
    }

    public static String[] mergeArrays(String[] ... arrays) {
        int arraySize = 0;
        for (String[] array : arrays) {
            arraySize += array.length;
        }
        String[] result = new String[arraySize];
        int j = 0;
        String[][] stringArray = arrays;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] array;
            for (String string : array = stringArray[i]) {
                result[j++] = string;
            }
        }
        return result;
    }

    public static String formatLocation(Location loc) {
        return "x " + loc.getBlockX() + " z " + loc.getBlockZ() + " in " + loc.getWorld();
    }

    public static String cutDecimals(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(d);
    }

    public static <T> String collectionToStringNoBrackets(Collection<T> coll) {
        return coll.toString().replace("[", "").replace("]", "").replace("{", "").replace("}", "");
    }

    public static String formatBench(String source, long ms) {
        StringBuilder b = new StringBuilder();
        b.append(ms).append(" ms");
        while (b.length() < 10) {
            b.append(" ");
        }
        b.append(source);
        return b.toString();
    }
}

